/*
 * Decompiled with CFR 0.152.
 */
package forge.game.ability.effects;

import com.google.common.collect.Maps;
import forge.game.Game;
import forge.game.ability.AbilityKey;
import forge.game.ability.AbilityUtils;
import forge.game.ability.SpellAbilityEffect;
import forge.game.card.Card;
import forge.game.card.CardCollection;
import forge.game.card.CardCollectionView;
import forge.game.card.CardLists;
import forge.game.player.Player;
import forge.game.player.PlayerController;
import forge.game.spellability.SpellAbility;
import forge.game.trigger.TriggerType;
import forge.game.zone.ZoneType;
import forge.util.Lang;
import forge.util.Localizer;
import java.util.EnumMap;
import java.util.HashMap;

public class TapOrUntapAllEffect
extends SpellAbilityEffect {
    @Override
    protected String getStackDescription(SpellAbility sa) {
        StringBuilder sb = new StringBuilder();
        sb.append("Tap or untap ");
        if (sa.hasParam("ValidMessage")) {
            sb.append(sa.getParam("ValidMessage"));
        } else {
            sb.append(Lang.joinHomogenous(TapOrUntapAllEffect.getTargetCards(sa)));
        }
        sb.append(".");
        return sb.toString();
    }

    @Override
    public void resolve(SpellAbility sa) {
        EnumMap<AbilityKey, Object> runParams;
        Player activator = sa.getActivatingPlayer();
        Game game = activator.getGame();
        CardCollectionView validCards = sa.hasParam("ValidCards") ? AbilityUtils.filterListByType(game.getCardsIn(ZoneType.Battlefield), sa.getParam("ValidCards"), sa) : TapOrUntapAllEffect.getTargetCards(sa);
        if (sa.usesTargeting() || sa.hasParam("Defined")) {
            validCards = CardLists.filterControlledBy((Iterable<Card>)validCards, TapOrUntapAllEffect.getTargetPlayers(sa));
        }
        boolean toTap = true;
        StringBuilder sb = new StringBuilder(Localizer.getInstance().getMessage("lblTapOrUntapTarget", new Object[0]) + " ");
        if (sa.hasParam("ValidMessage")) {
            sb.append(sa.getParam("ValidMessage"));
        } else {
            sb.append(Localizer.getInstance().getMessage("lblPermanents", new Object[0]));
        }
        sb.append("?");
        toTap = sa.getActivatingPlayer().getController().chooseBinary(sa, sb.toString(), PlayerController.BinaryChoiceType.TapOrUntap);
        CardCollection tapped = new CardCollection();
        CardCollection untapped = new CardCollection();
        for (Card tgtC : validCards) {
            if (!tgtC.isInPlay()) continue;
            if (toTap) {
                if (!tgtC.tap(true, sa, activator)) continue;
                tapped.add(tgtC);
                continue;
            }
            if (!tgtC.untap(true)) continue;
            untapped.add(tgtC);
        }
        if (!tapped.isEmpty()) {
            runParams = AbilityKey.newMap();
            runParams.put(AbilityKey.Cards, tapped);
            game.getTriggerHandler().runTrigger(TriggerType.TapAll, runParams, false);
        }
        if (!untapped.isEmpty()) {
            runParams = AbilityKey.newMap();
            HashMap<Player, CardCollection> map = Maps.newHashMap();
            map.put(activator, untapped);
            runParams.put(AbilityKey.Map, map);
            game.getTriggerHandler().runTrigger(TriggerType.UntapAll, runParams, false);
        }
    }
}

