/*
 * Decompiled with CFR 0.152.
 */
package forge.game.ability.effects;

import forge.game.CardTraitBase;
import forge.game.ability.AbilityKey;
import forge.game.ability.AbilityUtils;
import forge.game.ability.SpellAbilityEffect;
import forge.game.card.Card;
import forge.game.card.CardCollection;
import forge.game.card.CardLists;
import forge.game.player.Player;
import forge.game.spellability.SpellAbility;
import forge.game.trigger.TriggerType;
import forge.game.zone.ZoneType;
import forge.util.Lang;
import forge.util.Localizer;
import java.util.EnumMap;
import java.util.List;

public class TapEffect
extends SpellAbilityEffect {
    @Override
    public void resolve(SpellAbility sa) {
        List<Card> toTap;
        Player activator = sa.getActivatingPlayer();
        Card card = sa.getHostCard();
        boolean remTapped = sa.hasParam("RememberTapped");
        boolean alwaysRem = sa.hasParam("AlwaysRemember");
        if (remTapped) {
            card.clearRemembered();
        }
        if (sa.hasParam("CardChoices")) {
            CardCollection choices = CardLists.getValidCards((Iterable<Card>)card.getGame().getCardsIn(ZoneType.Battlefield), sa.getParam("CardChoices"), activator, card, (CardTraitBase)sa);
            int n = sa.hasParam("ChoiceAmount") ? AbilityUtils.calculateAmount(card, sa.getParam("ChoiceAmount"), sa) : 1;
            int min2 = sa.hasParam("AnyNumber") ? 0 : n;
            String prompt = sa.hasParam("ChoicePrompt") ? sa.getParam("ChoicePrompt") : Localizer.getInstance().getMessage("lblChoosePermanentstoTap", new Object[0]);
            toTap = activator.getController().chooseEntitiesForEffect(choices, min2, n, null, sa, prompt, null, null);
        } else {
            toTap = TapEffect.getTargetCards(sa);
        }
        Player tapper = activator;
        if (sa.hasParam("Tapper")) {
            tapper = (Player)AbilityUtils.getDefinedPlayers(card, sa.getParam("Tapper"), sa).getFirst();
        }
        CardCollection tapped = new CardCollection();
        for (Card tgtC : toTap) {
            if (tgtC.isPhasedOut()) continue;
            if (tgtC.isInPlay()) {
                if (tgtC.isUntapped() && remTapped || alwaysRem) {
                    card.addRemembered(tgtC);
                }
                if (tgtC.tap(true, sa, tapper)) {
                    tapped.add(tgtC);
                }
            }
            if (!sa.hasParam("ETB")) continue;
            tgtC.setTapped(true);
        }
        if (!tapped.isEmpty()) {
            EnumMap<AbilityKey, Object> runParams = AbilityKey.newMap();
            runParams.put(AbilityKey.Cards, tapped);
            activator.getGame().getTriggerHandler().runTrigger(TriggerType.TapAll, runParams, false);
        }
    }

    @Override
    protected String getStackDescription(SpellAbility sa) {
        StringBuilder sb = new StringBuilder();
        sb.append("Tap ");
        sb.append(Lang.joinHomogenous(TapEffect.getTargetCards(sa)));
        sb.append(".");
        return sb.toString();
    }
}

