/*
 * Decompiled with CFR 0.152.
 */
package forge.game.ability.effects;

import com.google.common.collect.Lists;
import forge.card.MagicColor;
import forge.game.Game;
import forge.game.GameOutcome;
import forge.game.ability.AbilityKey;
import forge.game.ability.ApiType;
import forge.game.ability.SpellAbilityEffect;
import forge.game.card.Card;
import forge.game.card.CardCollectionView;
import forge.game.event.GameEventSubgameEnd;
import forge.game.event.GameEventSubgameStart;
import forge.game.player.Player;
import forge.game.player.PlayerCollection;
import forge.game.player.PlayerController;
import forge.game.player.RegisteredPlayer;
import forge.game.spellability.SpellAbility;
import forge.game.zone.PlayerZone;
import forge.game.zone.ZoneType;
import forge.item.PaperCard;
import forge.util.CardTranslation;
import forge.util.Lang;
import forge.util.Localizer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class SubgameEffect
extends SpellAbilityEffect {
    private Game createSubGame(Game maingame, int startingLife) {
        ArrayList<RegisteredPlayer> players = Lists.newArrayList();
        for (Player p : maingame.getPlayers()) {
            players.add(p.getRegisteredPlayer());
        }
        return new Game(players, maingame.getRules(), maingame.getMatch(), maingame, startingLife);
    }

    private void setCardsInZone(Player player, ZoneType zoneType, CardCollectionView oldCards, boolean addMapping) {
        PlayerZone zone = player.getZone(zoneType);
        ArrayList<Card> newCards = Lists.newArrayList();
        for (Card card : oldCards) {
            if (card.isToken() || card.isCopiedSpell()) continue;
            Card newCard = Card.fromPaperCard(card.getPaperCard(), player);
            newCards.add(newCard);
            if (!addMapping) continue;
            player.addMaingameCardMapping(newCard, card);
        }
        zone.setCards(newCards);
    }

    private void initVariantsZonesSubgame(Game subgame, Player maingamePlayer, Player player) {
        PlayerZone com = player.getZone(ZoneType.Command);
        RegisteredPlayer registeredPlayer = player.getRegisteredPlayer();
        if (registeredPlayer.getVanguardAvatars() != null) {
            for (PaperCard avatar : registeredPlayer.getVanguardAvatars()) {
                com.add(Card.fromPaperCard(avatar, player));
            }
        }
        CardCollectionView commandCards = maingamePlayer.getCardsIn(ZoneType.Command);
        for (Card card : commandCards) {
            if (!card.isCommander()) continue;
            Card cmd = Card.fromPaperCard(card.getPaperCard(), player);
            if (cmd.hasKeyword("If CARDNAME is your commander, choose a color before the game begins.")) {
                ArrayList<String> colorChoices = new ArrayList<String>(MagicColor.Constant.ONLY_COLORS);
                String prompt = Localizer.getInstance().getMessage("lblChooseAColorFor", cmd.getName());
                SpellAbility.EmptySa cmdColorsa = new SpellAbility.EmptySa(ApiType.ChooseColor, cmd, player);
                List<String> chosenColors = player.getController().chooseColors(prompt, cmdColorsa, 1, 1, colorChoices);
                cmd.setChosenColors(chosenColors);
                subgame.getAction().notifyOfValue(cmdColorsa, cmd, Localizer.getInstance().getMessage("lblPlayerPickedChosen", player.getName(), Lang.joinHomogenous(chosenColors)), player);
            }
            com.add(cmd);
            player.addCommander(cmd);
        }
    }

    private void prepareAllZonesSubgame(Game maingame, Game subgame) {
        PlayerCollection players = subgame.getPlayers();
        PlayerCollection maingamePlayers = maingame.getPlayers();
        List<ZoneType> outsideZones = Arrays.asList(ZoneType.Hand, ZoneType.Battlefield, ZoneType.Graveyard, ZoneType.Exile, ZoneType.Stack, ZoneType.Sideboard, ZoneType.Ante, ZoneType.Merged);
        for (int i = 0; i < players.size(); ++i) {
            Player player = (Player)players.get(i);
            Player maingamePlayer = (Player)maingamePlayers.get(i);
            this.setCardsInZone(player, ZoneType.Library, maingamePlayer.getCardsIn(ZoneType.Library), false);
            CardCollectionView outsideCards = maingame.getCardsInOwnedBy(outsideZones, maingamePlayer);
            if (!outsideCards.isEmpty()) {
                this.setCardsInZone(player, ZoneType.Sideboard, outsideCards, true);
                for (Card c : player.getCardsIn(ZoneType.Sideboard)) {
                    c.updateStateForView();
                }
                PlayerController person = player.getController();
                Card companion = player.assignCompanion(subgame, person);
                if (companion != null) {
                    PlayerZone commandZone = player.getZone(ZoneType.Command);
                    companion = subgame.getAction().moveTo(ZoneType.Command, companion, null, AbilityKey.newMap());
                    commandZone.add(Player.createCompanionEffect(subgame, companion));
                    player.updateZoneForView(commandZone);
                }
            }
            this.setCardsInZone(player, ZoneType.SchemeDeck, maingamePlayer.getCardsIn(ZoneType.SchemeDeck), false);
            this.setCardsInZone(player, ZoneType.PlanarDeck, maingamePlayer.getCardsIn(ZoneType.PlanarDeck), false);
            this.setCardsInZone(player, ZoneType.AttractionDeck, maingamePlayer.getCardsIn(ZoneType.AttractionDeck), false);
            this.initVariantsZonesSubgame(subgame, maingamePlayer, player);
            player.shuffle(null);
            player.getZone(ZoneType.SchemeDeck).shuffle();
            player.getZone(ZoneType.PlanarDeck).shuffle();
            player.getZone(ZoneType.AttractionDeck).shuffle();
        }
    }

    @Override
    public void resolve(SpellAbility sa) {
        Card hostCard = sa.getHostCard();
        Game maingame = hostCard.getGame();
        int startingLife = -1;
        if (sa.hasParam("StartingLife")) {
            startingLife = Integer.parseInt(sa.getParam("StartingLife"));
        }
        Game subgame = this.createSubGame(maingame, startingLife);
        String startMessage = Localizer.getInstance().getMessage("lblSubgameStart", CardTranslation.getTranslatedName(hostCard.getName()));
        maingame.fireEvent(new GameEventSubgameStart(subgame, startMessage));
        this.prepareAllZonesSubgame(maingame, subgame);
        subgame.getAction().startGame(null, null);
        subgame.clearCaches();
        GameOutcome outcome = subgame.getOutcome();
        ArrayList<Player> winPlayers = Lists.newArrayList();
        ArrayList<Player> notWinPlayers = Lists.newArrayList();
        StringBuilder sbWinners = new StringBuilder();
        StringBuilder sbLosers = new StringBuilder();
        for (Player p : maingame.getPlayers()) {
            if (outcome.isWinner(p.getRegisteredPlayer())) {
                if (!winPlayers.isEmpty()) {
                    sbWinners.append(", ");
                }
                sbWinners.append(p.getName());
                winPlayers.add(p);
                continue;
            }
            if (!notWinPlayers.isEmpty()) {
                sbLosers.append(", ");
            }
            sbLosers.append(p.getName());
            notWinPlayers.add(p);
        }
        if (sa.hasParam("RememberPlayers")) {
            String param = sa.getParam("RememberPlayers");
            if (param.equals("Win")) {
                hostCard.addRemembered(winPlayers);
            } else if (param.equals("NotWin")) {
                hostCard.addRemembered(notWinPlayers);
            }
        }
        String endMessage = outcome.isDraw() ? Localizer.getInstance().getMessage("lblSubgameEndDraw", new Object[0]) : Localizer.getInstance().getMessage("lblSubgameEnd", sbWinners.toString(), sbLosers.toString());
        maingame.fireEvent(new GameEventSubgameEnd(maingame, endMessage));
        PlayerCollection subgamePlayers = subgame.getRegisteredPlayers();
        PlayerCollection players = maingame.getPlayers();
        for (int i = 0; i < players.size(); ++i) {
            Player subgamePlayer = (Player)subgamePlayers.get(i);
            Player player = (Player)players.get(i);
            CardCollectionView movedCards = player.getCardsIn(ZoneType.Subgame);
            PlayerZone library = player.getZone(ZoneType.Library);
            for (Card card : movedCards) {
                library.add(card);
            }
            player.getZone(ZoneType.Subgame).removeAllCards(true);
            ArrayList<Card> subgameCommanders = Lists.newArrayList();
            ArrayList<Card> movedCommanders = Lists.newArrayList();
            for (Card card : subgamePlayer.getCardsIn(ZoneType.Command)) {
                if (!card.isCommander()) continue;
                subgameCommanders.add(card);
            }
            for (Card card : player.getCardsIn(ZoneType.Command)) {
                if (!card.isCommander()) continue;
                boolean isInSubgameCommand = false;
                for (Card subCard : subgameCommanders) {
                    if (!card.getName().equals(subCard.getName())) continue;
                    isInSubgameCommand = true;
                }
                if (isInSubgameCommand) continue;
                movedCommanders.add(card);
            }
            for (Card card : movedCommanders) {
                maingame.getAction().moveTo(ZoneType.Library, card, null, AbilityKey.newMap());
            }
            player.shuffle(sa);
            player.getZone(ZoneType.SchemeDeck).shuffle();
            player.getZone(ZoneType.PlanarDeck).shuffle();
            player.getZone(ZoneType.AttractionDeck).shuffle();
        }
    }
}

