/*
 * Decompiled with CFR 0.152.
 */
package forge.game.ability.effects;

import forge.GameCommand;
import forge.game.Game;
import forge.game.ability.AbilityFactory;
import forge.game.ability.SpellAbilityEffect;
import forge.game.card.Card;
import forge.game.player.Player;
import forge.game.replacement.ReplacementEffect;
import forge.game.replacement.ReplacementHandler;
import forge.game.replacement.ReplacementLayer;
import forge.game.spellability.SpellAbility;

public class SkipPhaseEffect
extends SpellAbilityEffect {
    @Override
    protected String getStackDescription(SpellAbility sa) {
        StringBuilder sb = new StringBuilder();
        String duration = sa.getParam("Duration");
        String phase = sa.getParam("Phase");
        String step = sa.getParam("Step");
        for (Player player : SkipPhaseEffect.getTargetPlayers(sa)) {
            sb.append(player).append(" ");
            sb.append("skips their ");
            if (duration == null) {
                sb.append("next ");
            }
            if (phase != null) {
                sb.append(phase.toLowerCase()).append(" phase.");
                continue;
            }
            sb.append(step.toLowerCase()).append(" step.");
        }
        return sb.toString();
    }

    @Override
    public void resolve(SpellAbility sa) {
        String duration = sa.getParam("Duration");
        String phase = sa.getParam("Phase");
        String step = sa.getParam("Step");
        for (Player player : SkipPhaseEffect.getTargetPlayers(sa)) {
            SkipPhaseEffect.createSkipPhaseEffect(sa, player, duration, phase, step);
        }
    }

    public static void createSkipPhaseEffect(final SpellAbility sa, Player player, String duration, String phase, String step) {
        Card hostCard = sa.getHostCard();
        final Game game = hostCard.getGame();
        String name = hostCard + "'s Effect";
        String image = hostCard.getImageKey();
        boolean isNextThisTurn = duration != null && duration.equals("NextThisTurn");
        final Card eff = SkipPhaseEffect.createEffect(sa, player, name, image);
        StringBuilder sb = new StringBuilder();
        sb.append("Event$ BeginPhase | ActiveZones$ Command | ValidPlayer$ You | Phase$ ");
        sb.append(phase != null ? phase : step);
        if (duration != null && !isNextThisTurn) {
            sb.append(" | Skip$ True");
        }
        sb.append("| Description$ Skip ");
        if (duration == null || isNextThisTurn) {
            sb.append("your next ");
        } else {
            sb.append("each ");
        }
        if (phase != null) {
            sb.append(phase.toLowerCase()).append(" phase");
        } else {
            sb.append(step.toLowerCase()).append(" step");
        }
        if (duration == null) {
            sb.append(".");
        } else if (game.getPhaseHandler().getPlayerTurn().equals(player)) {
            sb.append(" of this turn.");
        } else {
            sb.append(" of your next turn.");
        }
        String repeffstr = sb.toString();
        ReplacementEffect re = ReplacementHandler.parseReplacement(repeffstr, eff, true);
        re.setLayer(ReplacementLayer.Control);
        if (duration == null || isNextThisTurn) {
            String exilestr = "DB$ ChangeZone | Defined$ Self | Origin$ Command | Destination$ Exile";
            SpellAbility exile = AbilityFactory.getAbility(exilestr, eff);
            re.setOverridingAbility(exile);
        }
        if (duration != null) {
            SkipPhaseEffect.addUntilCommand(sa, SkipPhaseEffect.exileEffectCommand(game, eff));
        }
        eff.addReplacementEffect(re);
        if (sa.hasParam("Start")) {
            GameCommand startEffect = new GameCommand(){
                private static final long serialVersionUID = -5861749814760561373L;

                @Override
                public void run() {
                    game.getAction().moveToCommand(eff, sa);
                }
            };
            game.getUpkeep().addUntil(player, startEffect);
        } else {
            game.getAction().moveToCommand(eff, sa);
        }
    }
}

