/*
 * Decompiled with CFR 0.152.
 */
package forge.game.ability.effects;

import forge.card.CardStateName;
import forge.game.CardTraitBase;
import forge.game.Game;
import forge.game.GameEntityCounterTable;
import forge.game.GameLogEntryType;
import forge.game.ability.AbilityKey;
import forge.game.ability.AbilityUtils;
import forge.game.ability.SpellAbilityEffect;
import forge.game.card.Card;
import forge.game.card.CardCollection;
import forge.game.card.CardCollectionView;
import forge.game.card.CardCopyService;
import forge.game.card.CardFactoryUtil;
import forge.game.card.CardLists;
import forge.game.card.CounterEnumType;
import forge.game.event.GameEventCardStatsChanged;
import forge.game.player.Player;
import forge.game.player.PlayerActionConfirmMode;
import forge.game.spellability.SpellAbility;
import forge.game.trigger.TriggerHandler;
import forge.game.trigger.TriggerType;
import forge.game.zone.ZoneType;
import forge.util.Lang;
import forge.util.Localizer;
import forge.util.TextUtil;
import java.util.Map;

public class SetStateEffect
extends SpellAbilityEffect {
    @Override
    protected String getStackDescription(SpellAbility sa) {
        Card host = sa.getHostCard();
        StringBuilder sb = new StringBuilder();
        boolean specialize = sa.getParam("Mode").equals("Specialize");
        if (sa.hasParam("Flip")) {
            sb.append("Flip ");
        } else if (!specialize) {
            sb.append("Transform ");
        }
        sb.append(Lang.joinHomogenous(SetStateEffect.getTargetCards(sa)));
        if (specialize) {
            sb.append(" perpetually specializes into ");
            sb.append(host.hasChosenColor() ? host.getChosenColor() : "the chosen color");
        }
        sb.append(".");
        return sb.toString();
    }

    @Override
    public void resolve(SpellAbility sa) {
        CardCollectionView cardsToTransform;
        Player p = sa.getActivatingPlayer();
        String mode = sa.getParam("Mode");
        Card host = sa.getHostCard();
        Game game = host.getGame();
        boolean remChanged = sa.hasParam("RememberChanged");
        boolean hiddenAgenda = sa.hasParam("HiddenAgenda");
        boolean optional = sa.hasParam("Optional");
        CardCollection transformedCards = new CardCollection();
        if (sa.hasParam("Choices")) {
            int minAmount;
            CardCollection choices = CardLists.getValidCards((Iterable<Card>)game.getCardsIn(ZoneType.Battlefield), sa.getParam("Choices"), p, host, (CardTraitBase)sa);
            int validAmount = AbilityUtils.calculateAmount(host, sa.getParamOrDefault("Amount", "1"), sa);
            int n = minAmount = sa.hasParam("MinAmount") ? Integer.parseInt(sa.getParam("MinAmount")) : validAmount;
            if (validAmount <= 0) {
                return;
            }
            String title = sa.hasParam("ChoiceTitle") ? sa.getParam("ChoiceTitle") : Localizer.getInstance().getMessage("lblChooseaCard", new Object[0]) + " ";
            cardsToTransform = p.getController().chooseCardsForEffect(choices, sa, title, minAmount, validAmount, !sa.hasParam("Mandatory"), null);
        } else {
            cardsToTransform = SetStateEffect.getTargetCards(sa);
        }
        GameEntityCounterTable table = new GameEntityCounterTable();
        for (Card tgtCard : cardsToTransform) {
            String sb;
            Card lki;
            Card gameCard = game.getCardState(tgtCard, null);
            if (gameCard == null || !tgtCard.equalsWithGameTimestamp(gameCard) || !"TurnFaceUp".equals(mode) && !"TurnFaceDown".equals(mode) && !"Unspecialize".equals(mode) && !"Specialize".equals(mode) && !gameCard.isInPlay() && !sa.hasParam("ETB")) continue;
            if (sa.hasParam("RevealFirst")) {
                lki = CardCopyService.getLKICopy(tgtCard);
                lki.forceTurnFaceUp();
                game.getAction().reveal(new CardCollection(lki), lki.getOwner(), true, Localizer.getInstance().getMessage("lblRevealFaceDownCards", new Object[0]));
                if (sa.hasParam("ValidNewFace") && !lki.isValid(sa.getParam("ValidNewFace").split(","), p, host, (CardTraitBase)sa)) continue;
            }
            if ("TurnFaceUp".equals(mode) && gameCard.isFaceDown() && gameCard.isInPlay()) {
                if (gameCard.hasMergedCard()) {
                    boolean hasNonPermanent = false;
                    Object nonPermanentCard = null;
                    for (Card c : gameCard.getMergedCards()) {
                        if (c.getState(CardStateName.Original).getType().isPermanent()) continue;
                        hasNonPermanent = true;
                        nonPermanentCard = c;
                        break;
                    }
                    if (hasNonPermanent) {
                        Card lki2 = CardCopyService.getLKICopy(nonPermanentCard);
                        lki2.forceTurnFaceUp();
                        game.getAction().reveal(new CardCollection(lki2), lki2.getOwner(), true, Localizer.getInstance().getMessage("lblFaceDownCardCantTurnFaceUp", new Object[0]));
                        continue;
                    }
                } else if (!gameCard.getState(CardStateName.Original).getType().isPermanent()) {
                    lki = CardCopyService.getLKICopy(gameCard);
                    lki.forceTurnFaceUp();
                    game.getAction().reveal(new CardCollection(lki), lki.getOwner(), true, Localizer.getInstance().getMessage("lblFaceDownCardCantTurnFaceUp", new Object[0]));
                    continue;
                }
            }
            if ("TurnFaceDown".equals(mode) && !gameCard.isFaceDown() && gameCard.isInPlay() && gameCard.hasMergedCard()) {
                boolean hasBackSide = false;
                for (Card c : gameCard.getMergedCards()) {
                    if (!c.isDoubleFaced()) continue;
                    hasBackSide = true;
                    break;
                }
                if (hasBackSide) continue;
            }
            if ("Transform".equals(mode) && !gameCard.canTransform(sa)) continue;
            if ("Transform".equals(mode) && gameCard.equals(host) && sa.hasSVar("StoredTransform")) {
                boolean skip = gameCard.getTransformedTimestamp() != Long.parseLong(sa.getSVar("StoredTransform"));
                sa.removeSVar("StoredTransform");
                if (skip) continue;
            }
            if (optional) {
                String message = TextUtil.concatWithSpace("Transform", gameCard.getName(), "?");
                if (!p.getController().confirmAction(sa, PlayerActionConfirmMode.Random, message, null)) {
                    return;
                }
            }
            boolean hasTransformed = false;
            if (sa.isTurnFaceUp()) {
                hasTransformed = gameCard.turnFaceUp(sa);
            } else if ("Specialize".equals(mode)) {
                hasTransformed = gameCard.changeCardState(mode, host.getChosenColor(), sa);
                host.setChosenColors(null);
            } else {
                hasTransformed = gameCard.changeCardState(mode, sa.getParam("NewState"), sa);
                if (hasTransformed && (sa.hasParam("FaceDownPower") || sa.hasParam("FaceDownToughness") || sa.hasParam("FaceDownSetType"))) {
                    CardFactoryUtil.setFaceDownState(gameCard, sa);
                }
            }
            if (!hasTransformed) continue;
            if (sa.isMorphUp()) {
                sb = p + " has unmorphed " + gameCard.getName();
                game.getGameLog().add(GameLogEntryType.STACK_RESOLVE, sb);
            } else if (sa.isManifestUp()) {
                sb = p + " has unmanifested " + gameCard.getName();
                game.getGameLog().add(GameLogEntryType.STACK_RESOLVE, sb);
            } else if (sa.isDisguiseUp()) {
                sb = p + " has undisguised " + gameCard.getName();
                game.getGameLog().add(GameLogEntryType.STACK_RESOLVE, sb);
            } else if (sa.isCloakUp()) {
                sb = p + " has uncloaked " + gameCard.getName();
                game.getGameLog().add(GameLogEntryType.STACK_RESOLVE, sb);
            } else if (hiddenAgenda) {
                if (gameCard.hasKeyword("Double agenda")) {
                    sb = p + " has revealed " + gameCard.getName() + " with the chosen names: " + gameCard.getNamedCards();
                    game.getGameLog().add(GameLogEntryType.STACK_RESOLVE, sb);
                } else {
                    sb = p + " has revealed " + gameCard.getName() + " with the chosen name " + gameCard.getNamedCard();
                    game.getGameLog().add(GameLogEntryType.STACK_RESOLVE, sb);
                }
            }
            game.fireEvent(new GameEventCardStatsChanged(gameCard));
            if (sa.hasParam("Mega")) {
                gameCard.addCounter(CounterEnumType.P1P1, 1, p, table);
            }
            if (remChanged) {
                host.addRemembered(gameCard);
            }
            if (!gameCard.isTransformable()) {
                transformedCards.add(gameCard);
            }
            if ("Specialize".equals(mode)) {
                gameCard.setSpecialized(true);
                TriggerHandler th = game.getTriggerHandler();
                th.clearActiveTriggers(gameCard, null);
                th.registerActiveTrigger(gameCard, false);
                Map<AbilityKey, Object> runParams = AbilityKey.mapFromCard(gameCard);
                th.runTrigger(TriggerType.Specializes, runParams, false);
                continue;
            }
            if (!"Unspecialize".equals(mode)) continue;
            gameCard.setSpecialized(false);
        }
        table.replaceCounterEffect(game, sa, true);
        if (!transformedCards.isEmpty()) {
            game.getAction().reveal(transformedCards, p, true, "Transformed cards in ");
        }
    }
}

