/*
 * Decompiled with CFR 0.152.
 */
package forge.game.ability.effects;

import com.google.common.collect.Lists;
import forge.game.CardTraitBase;
import forge.game.Game;
import forge.game.ability.AbilityKey;
import forge.game.ability.AbilityUtils;
import forge.game.ability.SpellAbilityEffect;
import forge.game.card.Card;
import forge.game.card.CardCollection;
import forge.game.card.CardCollectionView;
import forge.game.card.CardLists;
import forge.game.card.CardZoneTable;
import forge.game.player.Player;
import forge.game.spellability.SpellAbility;
import forge.game.trigger.TriggerType;
import forge.game.zone.ZoneType;
import forge.util.Aggregates;
import forge.util.Localizer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;

public class SeekEffect
extends SpellAbilityEffect {
    @Override
    protected String getStackDescription(SpellAbility sa) {
        return sa.getDescription();
    }

    @Override
    public void resolve(SpellAbility sa) {
        Card source = sa.getHostCard();
        Game game = source.getGame();
        ArrayList<String> seekTypes = Lists.newArrayList();
        if (sa.hasParam("Types")) {
            seekTypes.addAll(Arrays.asList(sa.getParam("Types").split(",")));
        } else {
            seekTypes.add(sa.getParamOrDefault("Type", "Card"));
        }
        int seekNum = AbilityUtils.calculateAmount(source, sa.getParamOrDefault("Num", "1"), sa);
        if (seekNum <= 0) {
            return;
        }
        CardZoneTable triggerList = new CardZoneTable();
        CardCollectionView lastStateBattlefield = game.copyLastStateBattlefield();
        CardCollectionView lastStateGraveyard = game.copyLastStateGraveyard();
        for (Player seeker : SeekEffect.getTargetPlayers(sa)) {
            if (!seeker.isInGame()) continue;
            CardCollection soughtCards = new CardCollection();
            StringBuilder notify = new StringBuilder();
            for (String seekType : seekTypes) {
                CardCollection pool = sa.hasParam("DefinedCards") ? AbilityUtils.getDefinedCards(source, sa.getParam("DefinedCards"), sa) : new CardCollection(seeker.getCardsIn(ZoneType.Library));
                if (!seekType.equals("Card")) {
                    pool = CardLists.getValidCards((Iterable<Card>)pool, seekType, source.getController(), source, (CardTraitBase)sa);
                }
                if (pool.isEmpty()) {
                    if (notify.length() != 0) {
                        notify.append("\r\n");
                    }
                    notify.append(Localizer.getInstance().getMessage("lblSeekFailed", seekType));
                    continue;
                }
                for (Card c : Aggregates.random(pool, seekNum)) {
                    EnumMap<AbilityKey, Object> moveParams = AbilityKey.newMap();
                    moveParams.put(AbilityKey.LastStateBattlefield, lastStateBattlefield);
                    moveParams.put(AbilityKey.LastStateGraveyard, lastStateGraveyard);
                    Card movedCard = game.getAction().moveToHand(c, sa, moveParams);
                    ZoneType resultZone = movedCard.getZone().getZoneType();
                    if (!resultZone.equals((Object)ZoneType.Library)) {
                        triggerList.put(ZoneType.Library, movedCard.getZone().getZoneType(), movedCard);
                    }
                    if (!resultZone.equals((Object)ZoneType.Hand)) continue;
                    soughtCards.add(movedCard);
                }
            }
            if (notify.length() != 0) {
                game.getAction().notifyOfValue(sa, source, notify.toString(), null);
            }
            if (soughtCards.isEmpty()) continue;
            if (sa.hasParam("RememberFound")) {
                source.addRemembered(soughtCards);
            }
            if (sa.hasParam("ImprintFound")) {
                source.addImprintedCards(soughtCards);
            }
            game.getTriggerHandler().runTrigger(TriggerType.SeekAll, AbilityKey.mapFromPlayer(seeker), false);
        }
        triggerList.triggerChangesZoneAll(game, sa);
    }
}

