/*
 * Decompiled with CFR 0.152.
 */
package forge.game.ability.effects;

import forge.game.Game;
import forge.game.GameActionUtil;
import forge.game.ability.AbilityKey;
import forge.game.ability.AbilityUtils;
import forge.game.ability.SpellAbilityEffect;
import forge.game.card.Card;
import forge.game.card.CardCollection;
import forge.game.card.CardCollectionView;
import forge.game.card.CardLists;
import forge.game.card.CardZoneTable;
import forge.game.player.Player;
import forge.game.player.PlayerCollection;
import forge.game.spellability.SpellAbility;
import forge.game.zone.ZoneType;
import forge.util.Lang;
import java.util.EnumMap;

public class SacrificeAllEffect
extends SpellAbilityEffect {
    @Override
    protected String getStackDescription(SpellAbility sa) {
        StringBuilder sb = new StringBuilder();
        if (sa.hasParam("Controller")) {
            PlayerCollection conts = SacrificeAllEffect.getDefinedPlayersOrTargeted(sa, "Controller");
            sb.append(Lang.joinHomogenous(conts)).append(conts.size() == 1 ? " sacrifices " : " sacrifice ");
        } else {
            sb.append("Sacrifice ");
        }
        if (sa.hasParam("Defined")) {
            CardCollection toSac = SacrificeAllEffect.getDefinedCardsOrTargeted(sa);
            sb.append(Lang.joinHomogenous(toSac)).append(".");
        } else {
            sb.append("permanents.");
        }
        return sb.toString();
    }

    @Override
    public void resolve(SpellAbility sa) {
        CardCollectionView list;
        Card host = sa.getHostCard();
        Player activator = sa.getActivatingPlayer();
        Game game = activator.getGame();
        if (sa.hasParam("Defined")) {
            list = AbilityUtils.getDefinedCards(host, sa.getParam("Defined"), sa);
        } else {
            list = game.getCardsIn(ZoneType.Battlefield);
            if (sa.hasParam("ValidCards")) {
                list = AbilityUtils.filterListByType(list, sa.getParam("ValidCards"), sa);
            }
        }
        boolean remSacrificed = sa.hasParam("RememberSacrificed");
        if (remSacrificed) {
            host.clearRemembered();
        }
        CardCollection gameList = new CardCollection();
        for (Card sac : list) {
            if (!sac.canBeSacrificedBy(sa, true)) continue;
            gameList.add(game.getCardState(sac, null));
        }
        list = gameList;
        if (sa.hasParam("Controller")) {
            list = CardLists.filterControlledBy((Iterable<Card>)list, AbilityUtils.getDefinedPlayers(sa.getHostCard(), sa.getParam("Controller"), sa));
        }
        list = GameActionUtil.orderCardsByTheirOwners(game, list, ZoneType.Graveyard, sa);
        EnumMap<AbilityKey, Object> params = AbilityKey.newMap();
        CardZoneTable zoneMovements = AbilityKey.addCardZoneTableParams(params, sa);
        for (Card sac : game.getAction().sacrifice(list, sa, true, params)) {
            Card lKICopy = zoneMovements.getLastStateBattlefield().get(sac);
            if (remSacrificed) {
                host.addRemembered(lKICopy);
            }
            if (!sa.hasParam("ImprintSacrificed")) continue;
            host.addImprintedCard(lKICopy);
        }
        zoneMovements.triggerChangesZoneAll(game, sa);
    }
}

