/*
 * Decompiled with CFR 0.152.
 */
package forge.game.ability.effects;

import forge.game.ability.SpellAbilityEffect;
import forge.game.card.Card;
import forge.game.card.CardCollectionView;
import forge.game.card.CardLists;
import forge.game.player.Player;
import forge.game.player.PlayerCollection;
import forge.game.spellability.SpellAbility;
import forge.game.zone.ZoneType;
import forge.util.Lang;
import forge.util.Localizer;

public class RevealHandEffect
extends SpellAbilityEffect {
    @Override
    protected String getStackDescription(SpellAbility sa) {
        StringBuilder sb = new StringBuilder();
        PlayerCollection tgtPlayers = RevealHandEffect.getTargetPlayers(sa);
        int numTgts = tgtPlayers.size();
        if (numTgts <= 0) {
            sb.append("Error - no target players for RevealHand.");
        } else if (sa.hasParam("Look")) {
            sb.append(sa.getActivatingPlayer()).append(" looks at ").append(Lang.joinHomogenous(tgtPlayers));
            sb.append("'s ").append(numTgts == 1 ? "hand." : "hands.");
        } else {
            sb.append(Lang.joinHomogenous(tgtPlayers)).append(numTgts == 1 ? " reveals" : " reveal");
            sb.append(" their ").append(numTgts == 1 ? "hand." : "hands.");
        }
        return sb.toString();
    }

    @Override
    public void resolve(SpellAbility sa) {
        Card host = sa.getHostCard();
        boolean optional = sa.hasParam("Optional");
        for (Player p : RevealHandEffect.getTargetPlayers(sa)) {
            if (!p.isInGame() || optional && !p.getController().confirmAction(sa, null, Localizer.getInstance().getMessage("lblDoYouWantRevealYourHand", new Object[0]), null)) continue;
            CardCollectionView hand = p.getCardsIn(ZoneType.Hand);
            if (sa.hasParam("RevealType")) {
                hand = CardLists.getType(hand, sa.getParam("RevealType"));
            }
            if (sa.hasParam("Look")) {
                sa.getActivatingPlayer().getController().reveal(hand, ZoneType.Hand, p);
            } else {
                host.getGame().getAction().reveal(hand, p);
            }
            if (sa.hasParam("RememberRevealed")) {
                host.addRemembered(hand);
            }
            if (sa.hasParam("ImprintRevealed")) {
                host.addImprintedCards(hand);
            }
            if (!sa.hasParam("RememberRevealedPlayer")) continue;
            host.addRemembered(p);
        }
    }
}

