/*
 * Decompiled with CFR 0.152.
 */
package forge.game.ability.effects;

import forge.game.Game;
import forge.game.ability.AbilityUtils;
import forge.game.ability.SpellAbilityEffect;
import forge.game.card.Card;
import forge.game.card.CardCollection;
import forge.game.combat.Combat;
import forge.game.player.Player;
import forge.game.spellability.SpellAbility;
import forge.util.Lang;

public class RemoveFromCombatEffect
extends SpellAbilityEffect {
    @Override
    protected String getStackDescription(SpellAbility sa) {
        StringBuilder sb = new StringBuilder();
        sb.append("Remove ");
        sb.append(Lang.joinHomogenous(RemoveFromCombatEffect.getTargetCards(sa)));
        sb.append(" from combat.");
        return sb.toString();
    }

    @Override
    public void resolve(SpellAbility sa) {
        Player activator = sa.getActivatingPlayer();
        Game game = activator.getGame();
        boolean rem = sa.hasParam("RememberRemovedFromCombat");
        Combat combat = game.getPhaseHandler().getCombat();
        for (Card c : RemoveFromCombatEffect.getTargetCards(sa)) {
            CardCollection attackers;
            if (combat == null || !c.isInPlay()) continue;
            if (sa.hasParam("UnblockCreaturesBlockedOnlyBy") && !(attackers = AbilityUtils.getDefinedCards(sa.getHostCard(), sa.getParam("UnblockCreaturesBlockedOnlyBy"), sa)).isEmpty()) {
                CardCollection blockedByCard = combat.getAttackersBlockedBy((Card)attackers.getFirst());
                for (Card atk : blockedByCard) {
                    boolean blockedOnlyByCard = true;
                    for (Card blocker : combat.getBlockers(atk)) {
                        if (blocker.equals(attackers.getFirst())) continue;
                        blockedOnlyByCard = false;
                        break;
                    }
                    if (!blockedOnlyByCard) continue;
                    combat.setBlocked(atk, false);
                }
            }
            game.getCombat().saveLKI(c);
            combat.removeFromCombat(c);
            if (!rem) continue;
            sa.getHostCard().addRemembered(c);
        }
    }
}

