/*
 * Decompiled with CFR 0.152.
 */
package forge.game.ability.effects;

import forge.game.Game;
import forge.game.ability.AbilityKey;
import forge.game.ability.SpellAbilityEffect;
import forge.game.card.Card;
import forge.game.card.CardCollection;
import forge.game.event.GameEventCardRegenerated;
import forge.game.spellability.SpellAbility;
import forge.game.trigger.TriggerType;
import java.util.EnumMap;

public class RegenerationEffect
extends SpellAbilityEffect {
    @Override
    public void resolve(SpellAbility sa) {
        Card host = sa.getHostCard();
        Game game = host.getGame();
        CardCollection tapped = new CardCollection();
        for (Card c : RegenerationEffect.getTargetCards(sa)) {
            SpellAbility cause = (SpellAbility)sa.getReplacingObject(AbilityKey.Cause);
            c.setDamage(0);
            c.setHasBeenDealtDeathtouchDamage(false);
            if (c.tap(true, cause, c.getController())) {
                tapped.add(c);
            }
            c.addRegeneratedThisTurn();
            if (game.getCombat() != null) {
                game.getCombat().saveLKI(c);
                game.getCombat().removeFromCombat(c);
            }
            game.fireEvent(new GameEventCardRegenerated(c));
            if (!host.isImmutable()) continue;
            c.decShieldCount();
            host.removeRemembered(c);
        }
        if (!tapped.isEmpty()) {
            EnumMap<AbilityKey, Object> runParams = AbilityKey.newMap();
            runParams.put(AbilityKey.Cards, tapped);
            game.getTriggerHandler().runTrigger(TriggerType.TapAll, runParams, false);
        }
    }
}

