/*
 * Decompiled with CFR 0.152.
 */
package forge.game.ability.effects;

import com.google.common.collect.Iterables;
import forge.game.ability.AbilityUtils;
import forge.game.ability.SpellAbilityEffect;
import forge.game.card.Card;
import forge.game.card.CardCollection;
import forge.game.card.CardCollectionView;
import forge.game.player.Player;
import forge.game.player.PlayerCollection;
import forge.game.spellability.SpellAbility;
import forge.game.zone.ZoneType;
import forge.util.Lang;
import forge.util.Localizer;

public class RearrangeTopOfLibraryEffect
extends SpellAbilityEffect {
    @Override
    protected String getStackDescription(SpellAbility sa) {
        int numCards = 0;
        PlayerCollection tgtPlayers = RearrangeTopOfLibraryEffect.getTargetPlayers(sa);
        boolean shuffle = false;
        Card host = sa.getHostCard();
        numCards = AbilityUtils.calculateAmount(host, sa.getParam("NumCards"), sa);
        shuffle = sa.hasParam("MayShuffle");
        StringBuilder ret = new StringBuilder();
        ret.append("Look at the top ");
        ret.append(numCards);
        ret.append(" cards of ");
        for (Player p : tgtPlayers) {
            ret.append(Lang.getInstance().getPossesive(p.getName()));
            ret.append(" & ");
        }
        ret.delete(ret.length() - 3, ret.length());
        ret.append(" library. Then put them back in any order.");
        if (shuffle) {
            ret.append("You may have ");
            if (tgtPlayers.size() > 1) {
                ret.append("those");
            } else {
                ret.append("that");
            }
            ret.append(" player shuffle their library.");
        }
        return ret.toString();
    }

    @Override
    public void resolve(SpellAbility sa) {
        Card host = sa.getHostCard();
        int numCards = AbilityUtils.calculateAmount(host, sa.getParam("NumCards"), sa);
        boolean shuffle = sa.hasParam("MayShuffle");
        for (Player p : RearrangeTopOfLibraryEffect.getTargetPlayers(sa)) {
            if (!p.isInGame()) continue;
            RearrangeTopOfLibraryEffect.rearrangeTopOfLibrary(host, p, numCards, shuffle, sa);
        }
    }

    private static void rearrangeTopOfLibrary(Card src, Player player, int numCards, boolean mayshuffle, SpellAbility sa) {
        Player activator;
        Player player2 = activator = sa.hasParam("RearrangePlayer") ? (Player)Iterables.getFirst(AbilityUtils.getDefinedPlayers(src, sa.getParam("RearrangePlayer"), sa), null) : sa.getActivatingPlayer();
        if (activator == null) {
            return;
        }
        CardCollection topCards = player.getTopXCardsFromLibrary(numCards);
        CardCollectionView orderedCards = activator.getController().orderMoveToZoneList(topCards, ZoneType.Library, sa);
        for (Card next : orderedCards) {
            player.getGame().getAction().moveToLibrary(next, 0, sa);
        }
        if (mayshuffle && activator.getController().confirmAction(sa, null, Localizer.getInstance().getMessage("lblDoyouWantShuffleTheLibrary", new Object[0]), null)) {
            player.shuffle(sa);
        }
    }
}

