/*
 * Decompiled with CFR 0.152.
 */
package forge.game.ability.effects;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import forge.GameCommand;
import forge.card.CardType;
import forge.game.Game;
import forge.game.GameEntity;
import forge.game.ability.AbilityUtils;
import forge.game.ability.SpellAbilityEffect;
import forge.game.card.Card;
import forge.game.card.CardCollection;
import forge.game.card.CardFactoryUtil;
import forge.game.card.CardUtil;
import forge.game.event.GameEventCardStatsChanged;
import forge.game.player.Player;
import forge.game.player.PlayerCollection;
import forge.game.spellability.AbilitySub;
import forge.game.spellability.SpellAbility;
import forge.game.zone.ZoneType;
import forge.util.Aggregates;
import forge.util.Lang;
import forge.util.Localizer;
import forge.util.TextUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class PumpEffect
extends SpellAbilityEffect {
    private static void applyPump(SpellAbility sa, Card applyTo, int a, int d, final List<String> keywords, final long timestamp) {
        HashMap<String, Object> params;
        final Card host = sa.getHostCard();
        final Game game = host.getGame();
        String duration = sa.getParam("Duration");
        boolean perpetual = "Perpetual".equals(duration);
        final Card gameCard = game.getCardState(applyTo, null);
        if (gameCard == null || !applyTo.equalsWithGameTimestamp(gameCard)) {
            return;
        }
        ArrayList<String> kws = Lists.newArrayList();
        ArrayList<String> hiddenKws = Lists.newArrayList();
        boolean redrawPT = false;
        for (String kw : keywords) {
            if (kw.startsWith("HIDDEN")) {
                hiddenKws.add(kw.substring(7));
                redrawPT |= kw.contains("CARDNAME's power and toughness are switched");
                continue;
            }
            kws.add(kw);
        }
        if (a != 0 || d != 0) {
            if (perpetual) {
                params = new HashMap<String, Object>();
                params.put("Power", a);
                params.put("Toughness", d);
                params.put("Timestamp", timestamp);
                params.put("Category", "PTBoost");
                gameCard.addPerpetual(params);
            }
            gameCard.addPTBoost(a, d, timestamp, 0L);
            redrawPT = true;
        }
        if (!kws.isEmpty()) {
            if (perpetual) {
                params = new HashMap();
                params.put("AddKeywords", kws);
                params.put("Timestamp", timestamp);
                params.put("Category", "Keywords");
                gameCard.addPerpetual(params);
            }
            gameCard.addChangedCardKeywords(kws, Lists.newArrayList(), false, timestamp, null);
        }
        if (!hiddenKws.isEmpty()) {
            gameCard.addHiddenExtrinsicKeywords(timestamp, 0L, hiddenKws);
        }
        if (redrawPT) {
            gameCard.updatePowerToughnessForView();
        }
        if (sa.hasParam("CanBlockAny")) {
            gameCard.addCanBlockAny(timestamp);
        }
        if (sa.hasParam("CanBlockAmount")) {
            int v = AbilityUtils.calculateAmount(host, sa.getParam("CanBlockAmount"), sa, true);
            gameCard.addCanBlockAdditional(v, timestamp);
        }
        if (sa.hasParam("LeaveBattlefield")) {
            PumpEffect.addLeaveBattlefieldReplacement(gameCard, sa, sa.getParam("LeaveBattlefield"));
        }
        if (sa.hasParam("RememberPumped")) {
            host.addRemembered(gameCard);
        }
        if (!"Permanent".equals(duration) && !perpetual) {
            GameCommand untilEOT = new GameCommand(){
                private static final long serialVersionUID = -42244224L;

                @Override
                public void run() {
                    host.removeGainControlTargets(gameCard);
                    gameCard.removePTBoost(timestamp, 0L);
                    boolean updateText = gameCard.removeCanBlockAny(timestamp);
                    updateText |= gameCard.removeCanBlockAdditional(timestamp);
                    if (keywords.size() > 0) {
                        gameCard.removeHiddenExtrinsicKeywords(timestamp, 0L);
                        gameCard.removeChangedCardKeywords(timestamp, 0L);
                    }
                    gameCard.updatePowerToughnessForView();
                    if (updateText) {
                        gameCard.updateAbilityTextForView();
                    }
                    game.fireEvent(new GameEventCardStatsChanged(gameCard));
                }
            };
            if ("UntilUntaps".equals(duration)) {
                host.addGainControlTarget(gameCard);
            }
            PumpEffect.addUntilCommand(sa, untilEOT);
        }
        game.fireEvent(new GameEventCardStatsChanged(gameCard));
    }

    private static void applyPump(SpellAbility sa, final Player p, List<String> keywords, final long timestamp) {
        String duration = sa.getParam("Duration");
        if (!keywords.isEmpty()) {
            p.addChangedKeywords(keywords, ImmutableList.of(), timestamp, 0L);
        }
        if (!"Permanent".equals(duration)) {
            GameCommand untilEOT = new GameCommand(){
                private static final long serialVersionUID = -32453460L;

                @Override
                public void run() {
                    p.removeChangedKeywords(timestamp, 0L);
                }
            };
            PumpEffect.addUntilCommand(sa, untilEOT);
        }
    }

    @Override
    protected String getStackDescription(SpellAbility sa) {
        StringBuilder sb = new StringBuilder();
        ArrayList<GameEntity> tgts = Lists.newArrayList();
        tgts.addAll(PumpEffect.getCardsfromTargets(sa));
        if (sa.usesTargeting() && sa.getTargetRestrictions().canTgtPlayer() || sa.hasParam("Defined")) {
            tgts.addAll(PumpEffect.getTargetPlayers(sa));
        }
        if (tgts.size() > 0) {
            boolean gains;
            ArrayList<String> keywords = Lists.newArrayList();
            if (sa.hasParam("KW")) {
                if (sa.getParam("KW").equals("HIDDEN This card doesn't untap during your next untap step.")) {
                    if (sa instanceof AbilitySub) {
                        sb.append(tgts.size() == 1 ? "It doesn't " : "They don't ");
                    } else {
                        sb.append(Lang.joinHomogenous(tgts)).append(tgts.size() == 1 ? " doesn't " : " don't ");
                    }
                    sb.append("untap during ");
                    String whose = "your";
                    for (GameEntity t2 : tgts) {
                        Card c = (Card)t2;
                        if (c.getOwner() == sa.getActivatingPlayer()) continue;
                        whose = tgts.size() == 1 ? "its controller's" : "their controller's";
                        break;
                    }
                    sb.append(whose).append(" next untap step.");
                    return sb.toString();
                }
                keywords.addAll(Arrays.asList(sa.getParam("KW").split(" & ")));
            }
            if (sa.hasParam("IfDesc")) {
                if (sa.getParam("IfDesc").equals("True") && sa.hasParam("SpellDescription")) {
                    String ifDesc = sa.getParam("SpellDescription");
                    sb.append(ifDesc, 0, ifDesc.indexOf(",") + 1);
                } else {
                    sb.append(sa.getParam("IfDesc"));
                }
                sb.append(" ");
            }
            if (sa instanceof AbilitySub && sa.getRootAbility().getTargets().containsAll(tgts)) {
                sb.append(tgts.size() == 1 && tgts.get(0) instanceof Card ? "It " : "They ");
            } else {
                sb.append(Lang.joinHomogenous(tgts)).append(" ");
            }
            if (sa.hasParam("Radiance")) {
                sb.append("and each other ").append(sa.getParam("ValidTgts")).append(" that shares a color with ");
                sb.append(tgts.size() > 1 ? "them " : "it ");
            }
            int atk = AbilityUtils.calculateAmount(sa.getHostCard(), sa.getParam("NumAtt"), sa, true);
            int def = AbilityUtils.calculateAmount(sa.getHostCard(), sa.getParam("NumDef"), sa, true);
            boolean gets = sa.hasParam("NumAtt") || sa.hasParam("NumDef");
            boolean bl = gains = !keywords.isEmpty();
            if (gets) {
                sb.append("gets ");
                if (atk != 0) {
                    sb.append(atk > 0 ? "+" : "").append(atk).append("/");
                } else {
                    sb.append(def < 0 ? "-" : "+").append(atk).append("/");
                }
                if (def != 0) {
                    sb.append(def > 0 ? "+" : "").append(def).append(" ");
                } else {
                    sb.append(atk < 0 ? "-" : "+").append(def).append(" ");
                }
                sb.append(gains ? "and gains " : "");
            } else if (gains) {
                sb.append("gains ");
            }
            for (int i = 0; i < keywords.size(); ++i) {
                sb.append(((String)keywords.get(i)).toLowerCase());
                sb.append(keywords.size() > 2 && i + 1 != keywords.size() ? ", " : "");
                sb.append(keywords.size() == 2 && i == 0 ? " " : "");
                sb.append(i + 2 == keywords.size() ? "and " : "");
            }
            if (sa.hasParam("CanBlockAny")) {
                if (gets || gains) {
                    sb.append(" and ");
                }
                sb.append("can block any number of creatures");
            } else if (sa.hasParam("CanBlockAmount")) {
                if (gets || gains) {
                    sb.append(" and ");
                }
                String n = sa.getParam("CanBlockAmount");
                sb.append("can block an additional ");
                sb.append("1".equals(n) ? "creature" : Lang.nounWithNumeral(n, "creature"));
                sb.append(" each combat");
            }
            String duration = sa.getParam("Duration");
            if (!"Permanent".equals(duration)) {
                if ("UntilUntaps".equals(duration)) {
                    sb.append(" for as long as CARDNAME remains tapped.");
                } else {
                    sb.append(" until end of turn.");
                }
            } else {
                sb.append(".");
            }
        }
        return sb.toString();
    }

    @Override
    public void resolve(SpellAbility sa) {
        if (!PumpEffect.checkValidDuration(sa.getParam("Duration"), sa)) {
            return;
        }
        Player activator = sa.getActivatingPlayer();
        Game game = activator.getGame();
        Card host = sa.getHostCard();
        long timestamp = game.getNextTimestamp();
        List<Card> tgtCards = PumpEffect.getCardsfromTargets(sa);
        PlayerCollection tgtPlayers = PumpEffect.getTargetPlayers(sa);
        List<String> keywords = Lists.newArrayList();
        if (sa.hasParam("KW")) {
            keywords.addAll(Arrays.asList(sa.getParam("KW").split(" & ")));
        } else if (sa.hasParam("KWChoice")) {
            List<String> options = Arrays.asList(sa.getParam("KWChoice").split(","));
            String chosen = activator.getController().chooseKeywordForPump(options, sa, Localizer.getInstance().getMessage("lblChooseKeyword", new Object[0]), tgtCards.get(0));
            keywords.add(chosen);
        }
        int a = 0;
        int d = 0;
        if (sa.hasParam("NumAtt") && !sa.getParam("NumAtt").equals("Double")) {
            a = AbilityUtils.calculateAmount(host, sa.getParam("NumAtt"), sa, true);
        }
        if (sa.hasParam("NumDef") && !sa.getParam("NumDef").equals("Double")) {
            d = AbilityUtils.calculateAmount(host, sa.getParam("NumDef"), sa, true);
        }
        if (sa.hasParam("SharedKeywordsZone")) {
            String[] stringArray;
            List<ZoneType> zones = ZoneType.listValueOf(sa.getParam("SharedKeywordsZone"));
            if (sa.hasParam("SharedRestrictions")) {
                stringArray = sa.getParam("SharedRestrictions").split(",");
            } else {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = "Card";
            }
            String[] restrictions = stringArray;
            keywords = CardFactoryUtil.sharedKeywords(keywords, restrictions, zones, host, sa);
        }
        CardCollection untargetedCards = CardUtil.getRadiance(sa);
        if (sa.hasParam("DefinedKW")) {
            Object s2;
            String defined = sa.getParam("DefinedKW");
            if (defined.equals("ChosenType")) {
                if (!host.hasChosenType()) {
                    return;
                }
                String replaced = host.getChosenType();
                for (int i = 0; i < keywords.size(); ++i) {
                    s2 = keywords.get(i);
                    s2 = ((String)s2).replaceAll(defined, replaced);
                    keywords.set(i, (String)s2);
                }
            } else if (defined.equals("ChosenPlayer")) {
                if (!host.hasChosenPlayer()) {
                    return;
                }
                Player cp = host.getChosenPlayer();
                for (int i = 0; i < keywords.size(); ++i) {
                    s2 = keywords.get(i);
                    s2 = ((String)s2).replaceAll("ChosenPlayerUID", String.valueOf(cp.getId()));
                    s2 = ((String)s2).replaceAll("ChosenPlayerName", cp.getName());
                    keywords.set(i, (String)s2);
                }
            } else if (defined.equals("ChosenColor")) {
                if (!host.hasChosenColor()) {
                    return;
                }
                for (int i = 0; i < keywords.size(); ++i) {
                    String s3 = keywords.get(i);
                    s3 = s3.replaceAll("ChosenColor", StringUtils.capitalize(host.getChosenColor()));
                    s3 = s3.replaceAll("chosenColor", host.getChosenColor().toLowerCase());
                    keywords.set(i, s3);
                }
            } else {
                PlayerCollection players = AbilityUtils.getDefinedPlayers(host, defined, sa);
                if (players.isEmpty()) {
                    return;
                }
                ArrayList newKeywords = Lists.newArrayList();
                Iterables.removeIf(keywords, input -> {
                    if (!input.contains("ChosenPlayerUID") && !input.contains("ChosenPlayerName")) {
                        return false;
                    }
                    for (Player p : players) {
                        String replacedID = String.valueOf(p.getId());
                        String replacedName = p.getName();
                        String s2 = input.replaceAll("ChosenPlayerUID", replacedID);
                        s2 = s2.replaceAll("ChosenPlayerName", replacedName);
                        newKeywords.add(s2);
                    }
                    return true;
                });
                keywords.addAll(newKeywords);
            }
        }
        if (sa.hasParam("DefinedLandwalk")) {
            String landtype = sa.getParam("DefinedLandwalk");
            for (Card c : AbilityUtils.getDefinedCards(host, landtype, sa)) {
                for (Object type : c.getType()) {
                    if (!CardType.isALandType((String)type)) continue;
                    keywords.add("Landwalk:" + (String)type);
                }
            }
        }
        if (sa.hasParam("RandomKeyword")) {
            String num = sa.getParamOrDefault("RandomKWNum", "1");
            int numkw = AbilityUtils.calculateAmount(host, num, sa);
            ArrayList<String> choice = Lists.newArrayList();
            ArrayList<String> total = Lists.newArrayList(keywords);
            if (sa.hasParam("NoRepetition")) {
                for (String kw : keywords) {
                    if (!tgtCards.get(0).hasKeyword(kw)) continue;
                    total.remove(kw);
                }
            }
            int min2 = Math.min(total.size(), numkw);
            for (int i = 0; i < min2; ++i) {
                String random = Aggregates.random(total);
                choice.add(random);
                total.remove(random);
            }
            keywords = choice;
        }
        if (sa.hasParam("Optional")) {
            String message;
            Iterator targets = Lang.joinHomogenous(tgtCards);
            String string = message = sa.hasParam("OptionQuestion") ? TextUtil.fastReplace(sa.getParam("OptionQuestion"), "TARGETS", (String)((Object)targets)) : Localizer.getInstance().getMessage("lblApplyPumpToTarget", targets);
            if (!activator.getController().confirmAction(sa, null, message, null)) {
                return;
            }
        }
        if (sa.hasParam("RememberObjects")) {
            host.addRemembered(AbilityUtils.getDefinedObjects(host, sa.getParam("RememberObjects"), sa));
        }
        if (sa.hasParam("NoteCardsFor")) {
            for (Card c : AbilityUtils.getDefinedCards(host, sa.getParam("NoteCards"), sa)) {
                for (Player p : tgtPlayers) {
                    p.addNoteForName(sa.getParam("NoteCardsFor"), "Id:" + c.getId());
                }
            }
        }
        if (sa.hasParam("ClearNotedCardsFor")) {
            for (Player p : tgtPlayers) {
                for (String s4 : sa.getParam("ClearNotedCardsFor").split(",")) {
                    p.clearNotesForName(s4);
                }
            }
        }
        if (sa.hasParam("NoteNumber")) {
            int num = AbilityUtils.calculateAmount(host, sa.getParam("NoteNumber"), sa);
            for (Player p : tgtPlayers) {
                p.noteNumberForName(host.getName(), num);
            }
        }
        if (sa.hasParam("ForgetObjects")) {
            host.removeRemembered(AbilityUtils.getDefinedObjects(host, sa.getParam("ForgetObjects"), sa));
        }
        if (sa.hasParam("ImprintCards")) {
            host.addImprintedCards(AbilityUtils.getDefinedCards(host, sa.getParam("ImprintCards"), sa));
        }
        if (sa.hasParam("ForgetImprinted")) {
            host.removeImprintedCards(AbilityUtils.getDefinedCards(host, sa.getParam("ForgetImprinted"), sa));
        }
        List<ZoneType> pumpZones = sa.hasParam("PumpZone") ? ZoneType.listValueOf(sa.getParam("PumpZone")) : ZoneType.listValueOf("Battlefield");
        for (Card tgtC : tgtCards) {
            if (tgtC.isPhasedOut() || !tgtC.isInZones(pumpZones)) continue;
            List<String> affectedKeywords = Lists.newArrayList(keywords);
            if (!affectedKeywords.isEmpty()) {
                Iterables.removeIf(affectedKeywords, input -> input.contains("CardManaCost") && tgtC.getManaCost().isNoCost());
                affectedKeywords = Lists.transform(affectedKeywords, input -> {
                    if (input.contains("CardManaCost")) {
                        input = input.replace("CardManaCost", tgtC.getManaCost().getShortString());
                    } else if (input.contains("ConvertedManaCost")) {
                        String costcmc = Integer.toString(tgtC.getCMC());
                        input = input.replace("ConvertedManaCost", costcmc);
                    }
                    return input;
                });
            }
            if (sa.hasParam("NumAtt") && sa.getParam("NumAtt").equals("Double")) {
                a = tgtC.getNetPower();
            }
            if (sa.hasParam("NumDef") && sa.getParam("NumDef").equals("Double")) {
                d = tgtC.getNetToughness();
            }
            PumpEffect.applyPump(sa, tgtC, a, d, affectedKeywords, timestamp);
        }
        if (sa.hasParam("AtEOT") && !tgtCards.isEmpty()) {
            PumpEffect.registerDelayedTrigger(sa, sa.getParam("AtEOT"), tgtCards);
        }
        for (Card tgtC : untargetedCards) {
            if (!tgtC.isInZones(pumpZones)) continue;
            PumpEffect.applyPump(sa, tgtC, a, d, keywords, timestamp);
        }
        for (Player p : tgtPlayers) {
            if (!p.isInGame()) continue;
            PumpEffect.applyPump(sa, p, keywords, timestamp);
        }
        PumpEffect.replaceDying(sa);
    }
}

