/*
 * Decompiled with CFR 0.152.
 */
package forge.game.ability.effects;

import forge.GameCommand;
import forge.game.Game;
import forge.game.ability.SpellAbilityEffect;
import forge.game.card.Card;
import forge.game.card.CardCollection;
import forge.game.event.GameEventCardStatsChanged;
import forge.game.spellability.SpellAbility;
import java.util.HashMap;

public class PowerExchangeEffect
extends SpellAbilityEffect {
    @Override
    protected String getStackDescription(SpellAbility sa) {
        StringBuilder sb = new StringBuilder();
        CardCollection tgtCards = PowerExchangeEffect.getTargetCards(sa);
        if (tgtCards.size() == 1) {
            sb.append(sa.getHostCard()).append(" exchanges power with ");
            sb.append(tgtCards.get(0));
        } else if (tgtCards.size() > 1) {
            sb.append(tgtCards.get(0)).append(" exchanges power with ");
            sb.append(tgtCards.get(1));
        }
        sb.append(".");
        return sb.toString();
    }

    @Override
    public void resolve(SpellAbility sa) {
        Card c2;
        Card c1;
        boolean perpetual = "Perpetual".equals(sa.getParam("Duration"));
        Card source = sa.getHostCard();
        final Game game = source.getGame();
        CardCollection tgtCards = PowerExchangeEffect.getTargetCards(sa);
        if (tgtCards.size() == 1) {
            c1 = source;
            c2 = (Card)tgtCards.get(0);
        } else {
            c1 = (Card)tgtCards.get(0);
            c2 = (Card)tgtCards.get(1);
        }
        if (!c1.isInPlay() || !c2.isInPlay()) {
            return;
        }
        boolean basePower = sa.hasParam("BasePower");
        int power1 = basePower ? c1.getCurrentPower() : c1.getNetPower();
        int power2 = basePower ? c2.getCurrentPower() : c2.getNetPower();
        final long timestamp = game.getNextTimestamp();
        if (perpetual) {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("Power", power2);
            params.put("Timestamp", timestamp);
            params.put("Category", "NewPT");
            c1.addPerpetual(params);
            params.put("Power", power1);
            c2.addPerpetual(params);
        }
        c1.addNewPT(power2, null, timestamp, 0L);
        c2.addNewPT(power1, null, timestamp, 0L);
        game.fireEvent(new GameEventCardStatsChanged(c1));
        game.fireEvent(new GameEventCardStatsChanged(c2));
        if (!"Permanent".equals(sa.getParam("Duration")) && !perpetual) {
            GameCommand untilEOT = new GameCommand(){
                private static final long serialVersionUID = -4890579038956651232L;

                @Override
                public void run() {
                    c1.removeNewPT(timestamp, 0L);
                    c2.removeNewPT(timestamp, 0L);
                    game.fireEvent(new GameEventCardStatsChanged(c1));
                    game.fireEvent(new GameEventCardStatsChanged(c2));
                }
            };
            PowerExchangeEffect.addUntilCommand(sa, untilEOT);
        }
    }
}

