/*
 * Decompiled with CFR 0.152.
 */
package forge.game.ability.effects;

import forge.game.Game;
import forge.game.GameEntityCounterTable;
import forge.game.ability.AbilityUtils;
import forge.game.ability.SpellAbilityEffect;
import forge.game.card.Card;
import forge.game.card.CounterEnumType;
import forge.game.player.Player;
import forge.game.player.PlayerCollection;
import forge.game.spellability.SpellAbility;
import forge.util.Lang;

public class PoisonEffect
extends SpellAbilityEffect {
    @Override
    public void resolve(SpellAbility sa) {
        Card host = sa.getHostCard();
        Game game = host.getGame();
        int amount = AbilityUtils.calculateAmount(host, sa.getParam("Num"), sa);
        GameEntityCounterTable table = new GameEntityCounterTable();
        for (Player p : PoisonEffect.getTargetPlayers(sa)) {
            if (!p.isInGame()) continue;
            if (amount >= 0) {
                p.addPoisonCounters(amount, sa.getActivatingPlayer(), table);
                continue;
            }
            p.removePoisonCounters(-amount, sa.getActivatingPlayer());
        }
        table.replaceCounterEffect(game, sa, true);
    }

    @Override
    protected String getStackDescription(SpellAbility sa) {
        StringBuilder sb = new StringBuilder();
        int amount = AbilityUtils.calculateAmount(sa.getHostCard(), sa.getParam("Num"), sa);
        PlayerCollection tgtPlayers = PoisonEffect.getTargetPlayers(sa);
        sb.append(Lang.joinHomogenous(tgtPlayers));
        sb.append(" ");
        sb.append("get");
        if (tgtPlayers.size() < 2) {
            sb.append("s");
        }
        String type = CounterEnumType.POISON.getName() + " counter";
        sb.append(" ").append(Lang.nounWithAmount(amount, type)).append(".");
        return sb.toString();
    }
}

