/*
 * Decompiled with CFR 0.152.
 */
package forge.game.ability.effects;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import forge.GameCommand;
import forge.game.CardTraitBase;
import forge.game.Game;
import forge.game.ability.AbilityUtils;
import forge.game.ability.SpellAbilityEffect;
import forge.game.card.Card;
import forge.game.card.CardCollection;
import forge.game.card.CardCollectionView;
import forge.game.card.CardLists;
import forge.game.player.Player;
import forge.game.spellability.SpellAbility;
import forge.game.zone.ZoneType;
import forge.util.Localizer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class MustBlockEffect
extends SpellAbilityEffect {
    @Override
    public void resolve(SpellAbility sa) {
        List<Card> cards;
        Card host = sa.getHostCard();
        Player activator = sa.getActivatingPlayer();
        Game game = activator.getGame();
        if (sa.hasParam("DefinedAttacker")) {
            cards = AbilityUtils.getDefinedCards(host, sa.getParam("DefinedAttacker"), sa);
            if (cards.isEmpty()) {
                return;
            }
        } else {
            cards = Lists.newArrayList(host);
        }
        final ArrayList<Card> tgtCards = Lists.newArrayList();
        if (sa.hasParam("Choices")) {
            Player chooser = activator;
            if (sa.hasParam("Chooser")) {
                String choose = sa.getParam("Chooser");
                chooser = (Player)AbilityUtils.getDefinedPlayers(host, choose, sa).get(false);
            }
            CardCollectionView choices = game.getCardsIn(ZoneType.Battlefield);
            if (!(choices = CardLists.getValidCards((Iterable<Card>)choices, sa.getParam("Choices"), activator, host, (CardTraitBase)sa)).isEmpty()) {
                String title = sa.hasParam("ChoiceTitle") ? sa.getParam("ChoiceTitle") : Localizer.getInstance().getMessage("lblChooseaCard", new Object[0]) + " ";
                HashMap params = Maps.newHashMap();
                params.put("Attackers", cards);
                Card choosen = chooser.getController().chooseSingleEntityForEffect(choices, sa, title, false, params);
                if (choosen != null) {
                    tgtCards.add(choosen);
                }
            }
        } else {
            tgtCards.addAll(MustBlockEffect.getTargetCards(sa));
        }
        boolean mustBlockAll = sa.hasParam("BlockAllDefined");
        final long ts = game.getNextTimestamp();
        for (Card c : tgtCards) {
            if (mustBlockAll) {
                c.addMustBlockCards(ts, cards);
                continue;
            }
            Card attacker = cards.get(0);
            c.addMustBlockCard(ts, attacker);
        }
        if (sa.hasParam("Duration")) {
            GameCommand removeBlockingRequirements = new GameCommand(){
                private static final long serialVersionUID = -5861529814760561373L;

                @Override
                public void run() {
                    for (Card c : tgtCards) {
                        c.removeMustBlockCards(ts);
                    }
                }
            };
            MustBlockEffect.addUntilCommand(sa, removeBlockingRequirements);
        }
    }

    @Override
    protected String getStackDescription(SpellAbility sa) {
        Card host = sa.getHostCard();
        StringBuilder sb = new StringBuilder();
        String attacker = null;
        if (sa.hasParam("DefinedAttacker")) {
            CardCollection cards = AbilityUtils.getDefinedCards(host, sa.getParam("DefinedAttacker"), sa);
            attacker = ((Card)cards.get(0)).toString();
        } else {
            attacker = host.toString();
        }
        if (sa.hasParam("Choices")) {
            sb.append("Choosen creature ").append(" must block ").append(attacker).append(" if able.");
        } else {
            for (Card c : MustBlockEffect.getTargetCards(sa)) {
                sb.append(c).append(" must block ").append(attacker).append(" if able.");
            }
        }
        return sb.toString();
    }
}

