/*
 * Decompiled with CFR 0.152.
 */
package forge.game.ability.effects;

import com.google.common.collect.Iterables;
import forge.game.CardTraitBase;
import forge.game.Game;
import forge.game.ability.AbilityKey;
import forge.game.ability.AbilityUtils;
import forge.game.ability.SpellAbilityEffect;
import forge.game.card.Card;
import forge.game.card.CardCollection;
import forge.game.card.CardCollectionView;
import forge.game.card.CardLists;
import forge.game.card.CardPredicates;
import forge.game.card.CardZoneTable;
import forge.game.player.Player;
import forge.game.spellability.SpellAbility;
import forge.game.zone.ZoneType;
import java.util.EnumMap;
import java.util.Map;

public abstract class ManifestBaseEffect
extends SpellAbilityEffect {
    @Override
    public void resolve(SpellAbility sa) {
        Card source = sa.getHostCard();
        int amount = sa.hasParam("Amount") ? AbilityUtils.calculateAmount(source, sa.getParam("Amount"), sa) : 1;
        for (Player p : ManifestBaseEffect.getTargetPlayers(sa, "DefinedPlayer")) {
            this.manifestLoop(sa, p, amount);
        }
    }

    protected void manifestLoop(SpellAbility sa, Player p, int amount) {
        CardCollection tgtCards;
        Card source = sa.getHostCard();
        Player activator = sa.getActivatingPlayer();
        Game game = source.getGame();
        boolean fromLibrary = false;
        if (sa.hasParam("Choices") || sa.hasParam("ChoiceZone")) {
            Object choiceZone = ZoneType.Hand;
            if (sa.hasParam("ChoiceZone")) {
                choiceZone = ZoneType.smartValueOf(sa.getParam("ChoiceZone"));
                fromLibrary = ((Enum)choiceZone).equals((Object)ZoneType.Library);
            }
            CardCollectionView choices = p.getCardsIn((ZoneType)((Object)choiceZone));
            if (sa.hasParam("Choices")) {
                choices = CardLists.getValidCards((Iterable<Card>)choices, sa.getParam("Choices"), activator, source, (CardTraitBase)sa);
            }
            if (choices.isEmpty()) {
                return;
            }
            String title = sa.hasParam("ChoiceTitle") ? sa.getParam("ChoiceTitle") : this.getDefaultMessage() + " ";
            tgtCards = new CardCollection(p.getController().chooseCardsForEffect(choices, sa, title, amount, amount, false, null));
        } else if ("TopOfLibrary".equals(sa.getParamOrDefault("Defined", "TopOfLibrary"))) {
            tgtCards = p.getTopXCardsFromLibrary(amount);
            fromLibrary = true;
        } else {
            tgtCards = ManifestBaseEffect.getTargetCards(sa);
            if (Iterables.all(tgtCards, CardPredicates.inZone(ZoneType.Library))) {
                fromLibrary = true;
            }
        }
        if (sa.hasParam("Shuffle")) {
            CardLists.shuffle(tgtCards);
        }
        if (fromLibrary) {
            for (Card c : tgtCards) {
                EnumMap<AbilityKey, Object> moveParams = AbilityKey.newMap();
                CardZoneTable triggerList = AbilityKey.addCardZoneTableParams(moveParams, sa);
                this.internalEffect(c, p, sa, moveParams);
                triggerList.triggerChangesZoneAll(game, sa);
            }
        } else {
            EnumMap<AbilityKey, Object> moveParams = AbilityKey.newMap();
            CardZoneTable triggerList = AbilityKey.addCardZoneTableParams(moveParams, sa);
            for (Card c : tgtCards) {
                this.internalEffect(c, p, sa, moveParams);
            }
            triggerList.triggerChangesZoneAll(game, sa);
        }
    }

    protected abstract String getDefaultMessage();

    protected abstract Card internalEffect(Card var1, Player var2, SpellAbility var3, Map<AbilityKey, Object> var4);
}

