/*
 * Decompiled with CFR 0.152.
 */
package forge.game.ability.effects;

import forge.card.ColorSet;
import forge.card.MagicColor;
import forge.game.ability.AbilityUtils;
import forge.game.ability.SpellAbilityEffect;
import forge.game.card.CardUtil;
import forge.game.player.Player;
import forge.game.spellability.AbilityManaPart;
import forge.game.spellability.SpellAbility;
import forge.util.Localizer;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class ManaReflectedEffect
extends SpellAbilityEffect {
    @Override
    public void resolve(SpellAbility sa) {
        Set<String> colors = CardUtil.getReflectableManaColors(sa);
        AbilityManaPart ma = sa.getManaPart();
        sa.setUndoable(sa.isAbility() && sa.isUndoable() && sa.getSubAbility() == null);
        StringBuilder producedMana = new StringBuilder();
        for (Player player : ManaReflectedEffect.getTargetPlayers(sa)) {
            String generated = ManaReflectedEffect.generatedReflectedMana(sa, colors, player);
            producedMana.append(ma.produceMana(generated, player, sa));
        }
        ma.tapsForMana(sa.getRootAbility(), producedMana.toString());
    }

    private static String generatedReflectedMana(SpellAbility sa, Collection<String> colors, Player player) {
        String baseMana;
        int amount = sa.hasParam("Amount") ? AbilityUtils.calculateAmount(sa.getHostCard(), sa.getParam("Amount"), sa) : 1;
        StringBuilder sb = new StringBuilder();
        if (sa.getManaPart().isComboMana()) {
            Map<Byte, Integer> choices = player.getController().specifyManaCombo(sa, ColorSet.fromNames(colors), amount, false);
            for (Map.Entry<Byte, Integer> e : choices.entrySet()) {
                Byte chosenColor = e.getKey();
                String choice = MagicColor.toShortString(chosenColor);
                Integer count = e.getValue();
                while (count > 0) {
                    if (sb.length() > 0) {
                        sb.append(" ");
                    }
                    sb.append(choice);
                    count = count - 1;
                }
            }
            return sb.toString();
        }
        String expressChoiceColors = sa.getManaPart().getExpressChoice();
        ColorSet colorMenu = null;
        byte mask = 0;
        for (int nChar = 0; nChar < expressChoiceColors.length(); ++nChar) {
            mask = (byte)(mask | MagicColor.fromName(expressChoiceColors.charAt(nChar)));
        }
        if (mask == 0 && !expressChoiceColors.isEmpty() && colors.contains("colorless")) {
            baseMana = MagicColor.toShortString(player.getController().chooseColorAllowColorless(Localizer.getInstance().getMessage("lblSelectManaProduce", new Object[0]), sa.getHostCard(), ColorSet.fromMask(mask)));
        } else if (mask == 0) {
            if (colors.isEmpty()) {
                return "0";
            }
            baseMana = colors.size() == 1 ? MagicColor.toShortString(colors.iterator().next()) : (colors.contains("colorless") ? MagicColor.toShortString(player.getController().chooseColorAllowColorless(Localizer.getInstance().getMessage("lblSelectManaProduce", new Object[0]), sa.getHostCard(), ColorSet.fromNames(colors))) : MagicColor.toShortString(player.getController().chooseColor(Localizer.getInstance().getMessage("lblSelectManaProduce", new Object[0]), sa, ColorSet.fromNames(colors))));
        } else {
            colorMenu = ColorSet.fromMask(mask);
            byte color = sa.getActivatingPlayer().getController().chooseColor(Localizer.getInstance().getMessage("lblSelectManaProduce", new Object[0]), sa, colorMenu);
            if (color == 0) {
                System.err.println("Unexpected behavior in ManaReflectedEffect: " + sa.getActivatingPlayer() + " - color mana choice is empty for " + sa.getHostCard().getName());
            }
            baseMana = MagicColor.toShortString(color);
        }
        if (amount == 0) {
            sb.append("0");
        } else if (StringUtils.isNumeric(baseMana)) {
            int base = Integer.parseInt(baseMana);
            sb.append(base * amount);
        } else {
            for (int i = 0; i < amount; ++i) {
                if (i != 0) {
                    sb.append(" ");
                }
                sb.append(baseMana);
            }
        }
        return sb.toString();
    }
}

