/*
 * Decompiled with CFR 0.152.
 */
package forge.game.ability.effects;

import forge.card.ColorSet;
import forge.card.MagicColor;
import forge.card.mana.ManaAtom;
import forge.card.mana.ManaCostShard;
import forge.game.CardTraitBase;
import forge.game.Game;
import forge.game.GameActionUtil;
import forge.game.ability.AbilityUtils;
import forge.game.ability.SpellAbilityEffect;
import forge.game.card.Card;
import forge.game.card.CardCollection;
import forge.game.card.CardLists;
import forge.game.player.Player;
import forge.game.player.PlayerCollection;
import forge.game.spellability.AbilityManaPart;
import forge.game.spellability.SpellAbility;
import forge.game.zone.ZoneType;
import forge.util.Lang;
import forge.util.Localizer;
import forge.util.TextUtil;
import io.sentry.Breadcrumb;
import io.sentry.Sentry;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class ManaEffect
extends SpellAbilityEffect {
    @Override
    public void resolve(SpellAbility sa) {
        Card card = sa.getHostCard();
        AbilityManaPart abMana = sa.getManaPart();
        PlayerCollection tgtPlayers = ManaEffect.getDefinedPlayersOrTargeted(sa);
        Player activator = sa.getActivatingPlayer();
        sa.setUndoable(sa.isAbility() && sa.isUndoable() && tgtPlayers.size() < 2 && !sa.hasParam("ActivationLimit"));
        boolean optional = sa.hasParam("Optional");
        Game game = activator.getGame();
        if (optional && !activator.getController().confirmAction(sa, null, Localizer.getInstance().getMessage("lblDoYouWantAddMana", new Object[0]), null)) {
            return;
        }
        StringBuilder producedMana = new StringBuilder();
        for (Player p : tgtPlayers) {
            if (!p.isInGame()) continue;
            if (abMana.isComboMana()) {
                int amount;
                int n = amount = sa.hasParam("Amount") ? AbilityUtils.calculateAmount(card, sa.getParam("Amount"), sa) : 1;
                if (amount <= 0) continue;
                String express = abMana.getExpressChoice();
                String[] colorsProduced = abMana.getComboColors(sa).split(" ");
                StringBuilder choiceString = new StringBuilder();
                StringBuilder choiceSymbols = new StringBuilder();
                ColorSet colorOptions = ColorSet.fromNames(colorsProduced);
                String[] colorsNeeded = express.isEmpty() ? null : express.split(" ");
                boolean differentChoice = abMana.getOrigProduced().contains("Different");
                ColorSet fullOptions = colorOptions;
                if (colorsNeeded == null && amount > 1 && !sa.hasParam("TwoEach")) {
                    Map<Byte, Integer> choices = p.getController().specifyManaCombo(sa, colorOptions, amount, differentChoice);
                    for (Map.Entry<Byte, Integer> e : choices.entrySet()) {
                        Byte chosenColor = e.getKey();
                        String choice = MagicColor.toShortString(chosenColor);
                        String symbol = MagicColor.toSymbol(chosenColor);
                        Integer count = e.getValue();
                        while (count > 0) {
                            if (choiceString.length() > 0) {
                                choiceString.append(" ");
                            }
                            choiceString.append(choice);
                            choiceSymbols.append(symbol);
                            count = count - 1;
                        }
                    }
                } else {
                    for (int nMana = 0; nMana < amount; ++nMana) {
                        String choice = "";
                        if (colorsNeeded != null && colorsNeeded.length > nMana) {
                            colorOptions = ColorSet.fromMask(fullOptions.getColor() & ManaAtom.fromName(colorsNeeded[nMana]));
                        }
                        if (colorOptions.isColorless() && colorsProduced.length > 0) {
                            choice = colorsProduced[differentChoice ? nMana : 0];
                        } else {
                            byte chosenColor = p.getController().chooseColor(Localizer.getInstance().getMessage("lblSelectManaProduce", new Object[0]), sa, differentChoice && (colorsNeeded == null || colorsNeeded.length <= nMana) ? fullOptions : colorOptions);
                            if (chosenColor == 0) {
                                throw new RuntimeException("ManaEffect::resolve() /*combo mana*/ - " + p + " color mana choice is empty for " + card.getName());
                            }
                            if (differentChoice) {
                                fullOptions = ColorSet.fromMask(fullOptions.getColor() - chosenColor);
                            }
                            choice = MagicColor.toShortString(chosenColor);
                        }
                        if (nMana > 0) {
                            choiceString.append(" ");
                        }
                        choiceString.append(choice);
                        choiceSymbols.append(MagicColor.toSymbol(choice));
                        if (!sa.hasParam("TwoEach")) continue;
                        choiceString.append(" ").append(choice);
                        choiceSymbols.append(MagicColor.toSymbol(choice));
                    }
                }
                if (choiceString.toString().isEmpty() && "Combo ColorIdentity".equals(abMana.getOrigProduced())) continue;
                game.getAction().notifyOfValue(sa, p, choiceSymbols.toString(), p);
                abMana.setExpressChoice(choiceString.toString());
            } else if (abMana.isAnyMana()) {
                String colorsNeeded = abMana.getExpressChoice();
                ColorSet colorMenu = null;
                int mask = 0;
                for (int nChar = 0; nChar < colorsNeeded.length(); ++nChar) {
                    mask = (byte)(mask | MagicColor.fromName(colorsNeeded.charAt(nChar)));
                }
                colorMenu = mask == 0 ? ColorSet.ALL_COLORS : ColorSet.fromMask(mask);
                byte val = p.getController().chooseColor(Localizer.getInstance().getMessage("lblSelectManaProduce", new Object[0]), sa, colorMenu);
                if (0 == val) {
                    throw new RuntimeException("ManaEffect::resolve() /*any mana*/ - " + p + " color mana choice is empty for " + card.getName());
                }
                game.getAction().notifyOfValue(sa, card, MagicColor.toSymbol(val), p);
                abMana.setExpressChoice(MagicColor.toShortString(val));
            } else if (abMana.isSpecialMana()) {
                String res;
                StringBuilder sb;
                String type = abMana.getOrigProduced().split("Special ")[1];
                if (type.equals("EnchantedManaCost")) {
                    Card enchanted = card.getEnchantingCard();
                    if (enchanted == null) continue;
                    StringBuilder sb2 = new StringBuilder();
                    int generic = enchanted.getManaCost().getGenericCost();
                    for (ManaCostShard s2 : enchanted.getManaCost()) {
                        byte chosenColor;
                        ColorSet cs = ColorSet.fromMask(s2.getColorMask());
                        if (cs.isColorless()) continue;
                        if (s2.isOr2Generic()) {
                            chosenColor = p.getController().chooseColorAllowColorless(Localizer.getInstance().getMessage("lblChooseSingleColorFromTarget", s2.toString()), card, cs);
                            if (chosenColor == 0) {
                                generic += 2;
                                continue;
                            }
                        } else {
                            chosenColor = cs.isMonoColor() ? s2.getColorMask() : p.getController().chooseColor(Localizer.getInstance().getMessage("lblChooseSingleColorFromTarget", s2.toString()), sa, cs);
                        }
                        sb2.append(MagicColor.toShortString(chosenColor));
                        sb2.append(' ');
                    }
                    if (generic > 0) {
                        sb2.append(generic);
                    }
                    abMana.setExpressChoice(sb2.toString().trim());
                } else if (type.equals("LastNotedType")) {
                    sb = new StringBuilder();
                    int nMana = 0;
                    for (Object o : card.getRemembered()) {
                        if (!(o instanceof String)) continue;
                        sb.append(o);
                        ++nMana;
                    }
                    if (nMana == 0) {
                        return;
                    }
                    abMana.setExpressChoice(sb.toString());
                } else if (type.startsWith("EachColorAmong")) {
                    res = type.split("_")[1];
                    boolean defined = type.startsWith("EachColorAmongDefined");
                    ZoneType zone = defined || type.startsWith("EachColorAmong_") ? ZoneType.Battlefield : ZoneType.smartValueOf(type.split("_")[0].substring(14));
                    CardCollection list = defined ? AbilityUtils.getDefinedCards(card, res, sa) : CardLists.getValidCards((Iterable<Card>)card.getGame().getCardsIn(zone), res, activator, card, (CardTraitBase)sa);
                    int colors = 0;
                    for (Card c : list) {
                        colors = (byte)(colors | c.getColor().getColor());
                    }
                    if (colors == 0) {
                        return;
                    }
                    abMana.setExpressChoice(ColorSet.fromMask(colors));
                } else if (type.startsWith("EachColoredManaSymbol")) {
                    res = type.split("_")[1];
                    StringBuilder sb3 = new StringBuilder();
                    for (Card c : AbilityUtils.getDefinedCards(card, res, sa)) {
                        for (ManaCostShard s3 : c.getManaCost()) {
                            ColorSet cs = ColorSet.fromMask(s3.getColorMask());
                            if (cs.isColorless()) continue;
                            sb3.append(' ');
                            if (cs.isMonoColor()) {
                                sb3.append(MagicColor.toShortString(s3.getColorMask()));
                                continue;
                            }
                            byte chosenColor = p.getController().chooseColor(Localizer.getInstance().getMessage("lblChooseSingleColorFromTarget", s3.toString()), sa, cs);
                            sb3.append(MagicColor.toShortString(chosenColor));
                        }
                    }
                    abMana.setExpressChoice(sb3.toString().trim());
                } else if (type.startsWith("DoubleManaInPool")) {
                    sb = new StringBuilder();
                    for (byte color : ManaAtom.MANATYPES) {
                        sb.append(StringUtils.repeat(MagicColor.toShortString(color) + " ", p.getManaPool().getAmountOfColor(color)));
                    }
                    abMana.setExpressChoice(sb.toString().trim());
                }
            }
            String mana = GameActionUtil.generatedMana(sa);
            if (mana.isEmpty()) {
                String msg = "AbilityFactoryMana::manaResolve() - special mana effect is empty for";
                Breadcrumb bread = new Breadcrumb(msg);
                bread.setData("Card", card.getName());
                bread.setData("SA", sa.toString());
                Sentry.addBreadcrumb(bread);
                continue;
            }
            producedMana.append(abMana.produceMana(mana, p, sa));
        }
        abMana.tapsForMana(sa.getRootAbility(), producedMana.toString());
        abMana.clearExpressChoice();
    }

    @Override
    protected String getStackDescription(SpellAbility sa) {
        StringBuilder sb = new StringBuilder();
        PlayerCollection tgtPlayers = ManaEffect.getDefinedPlayersOrTargeted(sa);
        String mana = !sa.hasParam("Amount") || StringUtils.isNumeric(sa.getParam("Amount")) ? GameActionUtil.generatedMana(sa) : "mana";
        String manaDesc = "";
        if (mana.equals("mana") && sa.hasParam("Produced") && sa.hasParam("AmountDesc")) {
            mana = sa.getParam("Produced");
            manaDesc = sa.getParam("AmountDesc");
        }
        sb.append(Lang.joinHomogenous(tgtPlayers)).append(tgtPlayers.size() == 1 ? " adds " : " add ");
        sb.append(TextUtil.toManaString(mana)).append(manaDesc).append(".");
        if (sa.hasParam("RestrictValid")) {
            sb.append(" ");
            String desc = sa.getDescription();
            if (desc.contains("Spend this") && desc.contains(".")) {
                int i = desc.indexOf("Spend this");
                sb.append(desc, i, desc.indexOf(".", i) + 1);
            } else if (desc.contains("This mana can't") && desc.contains(".")) {
                int i = desc.indexOf("This mana can't");
                sb.append(desc, i, desc.indexOf(".", i) + 1);
            } else {
                sb.append("[failed to add RestrictValid to StackDesc]");
            }
        }
        return sb.toString();
    }
}

