/*
 * Decompiled with CFR 0.152.
 */
package forge.game.ability.effects;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import forge.StaticData;
import forge.card.ICardFace;
import forge.game.CardTraitBase;
import forge.game.Game;
import forge.game.GameEntityCounterTable;
import forge.game.ability.AbilityKey;
import forge.game.ability.AbilityUtils;
import forge.game.ability.SpellAbilityEffect;
import forge.game.card.Card;
import forge.game.card.CardCollection;
import forge.game.card.CardCollectionView;
import forge.game.card.CardLists;
import forge.game.card.CardZoneTable;
import forge.game.card.CounterType;
import forge.game.player.Player;
import forge.game.player.PlayerCollection;
import forge.game.spellability.SpellAbility;
import forge.game.trigger.TriggerType;
import forge.game.zone.ZoneType;
import forge.item.BoosterPack;
import forge.item.IPaperCard;
import forge.item.PaperCard;
import forge.item.SealedTemplate;
import forge.util.Aggregates;
import forge.util.CardTranslation;
import forge.util.Localizer;
import forge.util.collect.FCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class MakeCardEffect
extends SpellAbilityEffect {
    @Override
    public void resolve(SpellAbility sa) {
        EnumMap<AbilityKey, Object> moveParams = AbilityKey.newMap();
        moveParams.put(AbilityKey.LastStateBattlefield, sa.getLastStateBattlefield());
        moveParams.put(AbilityKey.LastStateGraveyard, sa.getLastStateGraveyard());
        Card source = sa.getHostCard();
        PlayerCollection players = AbilityUtils.getDefinedPlayers(source, sa.getParam("Defined"), sa);
        for (Player player : players) {
            boolean attach;
            ZoneType zone;
            Game game = player.getGame();
            ArrayList<ICardFace> faces = new ArrayList<ICardFace>();
            List<PaperCard> pack = null;
            ArrayList<String> names = Lists.newArrayList();
            String desc = sa.getParamOrDefault("OptionPrompt", "");
            if (sa.hasParam("Optional") && sa.hasParam("OptionPrompt") && !player.getController().confirmAction(sa, null, Localizer.getInstance().getMessage(desc, new Object[0]), null)) {
                return;
            }
            if (sa.hasParam("Name")) {
                String n = sa.getParam("Name");
                if (n.equals("ChosenName")) {
                    if (source.hasNamedCard()) {
                        names.addAll(source.getNamedCards());
                    } else {
                        System.err.println("Malformed MakeCard entry! - " + source.toString());
                    }
                } else {
                    names.add(n);
                }
            } else if (sa.hasParam("Names")) {
                List<String> nameList = Arrays.asList(sa.getParam("Names").split(","));
                for (String s2 : nameList) {
                    s2 = s2.replace(";", ",");
                    names.add(s2);
                }
            } else if (sa.hasParam("DefinedName")) {
                String def = sa.getParam("DefinedName");
                Object cards = new CardCollection();
                cards = def.equals("ChosenMap") ? source.getChosenMap().get(player) : AbilityUtils.getDefinedCards(source, def, sa);
                Iterator s2 = ((FCollection)cards).iterator();
                while (s2.hasNext()) {
                    Card c = (Card)s2.next();
                    names.add(c.getName());
                }
            } else if (sa.hasParam("Spellbook")) {
                faces.addAll(this.parseFaces(sa, "Spellbook"));
            } else if (sa.hasParam("Choices")) {
                faces.addAll(this.parseFaces(sa, "Choices"));
            } else if (sa.hasParam("Booster")) {
                SealedTemplate booster = Aggregates.random(StaticData.instance().getBoosters());
                pack = new BoosterPack(booster.getEdition(), booster).getCards();
                for (PaperCard pc : pack) {
                    ICardFace face = pc.getRules().getMainPart();
                    if (face != null) {
                        faces.add(face);
                        continue;
                    }
                    throw new RuntimeException("MakeCardEffect didn't find card face by name: " + pc);
                }
            }
            if (!faces.isEmpty()) {
                int i;
                if (sa.hasParam("Filter")) {
                    ArrayList<ICardFace> filtered = new ArrayList<ICardFace>();
                    for (ICardFace face : faces) {
                        PaperCard pc = StaticData.instance().getCommonCards().getUniqueByName(face.getName());
                        if (!Card.fromPaperCard(pc, player).isValid(sa.getParam("Filter"), player, source, (CardTraitBase)sa)) continue;
                        filtered.add(face);
                    }
                    faces = filtered;
                    if (faces.isEmpty()) continue;
                }
                int n = i = sa.hasParam("SpellbookAmount") ? AbilityUtils.calculateAmount(source, sa.getParam("SpellbookAmount"), sa) : 1;
                while (i > 0) {
                    String chosen;
                    if (sa.hasParam("AtRandom")) {
                        chosen = ((ICardFace)Aggregates.random(faces)).getName();
                    } else {
                        String sbName = sa.hasParam("SpellbookName") ? sa.getParam("SpellbookName") : CardTranslation.getTranslatedName(source.getName());
                        String message = sa.hasParam("Choices") ? Localizer.getInstance().getMessage("lblChooseaCard", new Object[0]) : Localizer.getInstance().getMessage("lblChooseFromSpellbook", sbName);
                        chosen = player.getController().chooseCardName(sa, faces, message);
                    }
                    names.add(chosen);
                    faces.remove(StaticData.instance().getCommonCards().getFaceByName(chosen));
                    --i;
                }
            }
            ZoneType zoneType = zone = (attach = sa.hasParam("AttachedTo")) ? ZoneType.Battlefield : ZoneType.smartValueOf(sa.getParamOrDefault("Zone", "Library"));
            if (zone == null) {
                return;
            }
            int amount = sa.hasParam("Amount") ? AbilityUtils.calculateAmount(source, sa.getParam("Amount"), sa) : 1;
            CardCollection cards = new CardCollection();
            CardZoneTable triggerList = CardZoneTable.getSimultaneousInstance(sa);
            GameEntityCounterTable counterTable = new GameEntityCounterTable();
            CardCollectionView lastStateBattlefield = triggerList.getLastStateBattlefield();
            CardCollection attachList = new CardCollection();
            if (attach) {
                attachList = AbilityUtils.getDefinedCards(source, sa.getParam("AttachedTo"), sa);
                if (attachList.isEmpty()) {
                    attachList = CardLists.getValidCards((Iterable<Card>)lastStateBattlefield, sa.getParam("AttachedTo"), source.getController(), source, (CardTraitBase)sa);
                }
                if (attachList.isEmpty()) {
                    return;
                }
            }
            for (String name : names) {
                if (name.isEmpty()) continue;
                for (int toMake = amount; toMake > 0; --toMake) {
                    PaperCard pc = pack != null ? Iterables.getLast(Iterables.filter(pack, IPaperCard.Predicates.name(name))) : StaticData.instance().getCommonCards().getUniqueByName(name);
                    Card card = Card.fromPaperCard(pc, player);
                    if (sa.hasParam("TokenCard")) {
                        card.setTokenCard(true);
                    }
                    game.getAction().moveTo(ZoneType.None, card, sa, moveParams);
                    cards.add(card);
                    if (!sa.hasParam("Tapped")) continue;
                    card.setTapped(true);
                }
            }
            CardCollection madeCards = new CardCollection();
            boolean wCounter = sa.hasParam("WithCounter");
            boolean battlefield = zone.equals((Object)ZoneType.Battlefield);
            for (Card c : cards) {
                if (wCounter && battlefield) {
                    int numCtr = AbilityUtils.calculateAmount(source, sa.getParamOrDefault("WithCounterNum", "1"), sa);
                    GameEntityCounterTable table = new GameEntityCounterTable();
                    table.put(player, c, CounterType.getType(sa.getParam("WithCounter")), numCtr);
                    moveParams.put(AbilityKey.CounterTable, (Object)table);
                }
                if (attach) {
                    for (Card a : attachList) {
                        Card cc;
                        if (c.getZone().getZoneType().equals((Object)ZoneType.None)) {
                            cc = c;
                        } else {
                            PaperCard next = StaticData.instance().getCommonCards().getUniqueByName(c.getName());
                            cc = Card.fromPaperCard(next, player);
                            game.getAction().moveTo(ZoneType.None, cc, sa, moveParams);
                        }
                        cc.attachToEntity(game.getCardState(a), sa, true);
                        game.getAction().moveTo(zone, cc, sa, moveParams);
                        triggerList.put(ZoneType.None, cc.getZone().getZoneType(), cc);
                        madeCards.add(this.finishMaking(sa, cc, source));
                    }
                    continue;
                }
                int libraryPos = sa.hasParam("LibraryPosition") ? AbilityUtils.calculateAmount(source, sa.getParam("LibraryPosition"), sa) : 0;
                Card made = game.getAction().moveTo(zone, c, libraryPos, sa, moveParams);
                if (wCounter && !battlefield) {
                    made.addCounter(CounterType.getType(sa.getParam("WithCounter")), AbilityUtils.calculateAmount(source, sa.getParamOrDefault("WithCounterNum", "1"), sa), player, counterTable);
                }
                triggerList.put(ZoneType.None, made.getZone().getZoneType(), made);
                madeCards.add(this.finishMaking(sa, made, source));
            }
            triggerList.triggerChangesZoneAll(game, sa);
            counterTable.replaceCounterEffect(game, sa, true);
            if (sa.hasParam("Reveal")) {
                game.getAction().reveal(cards, player, true);
            }
            if (sa.hasParam("Conjure")) {
                Map<AbilityKey, Object> runParams = AbilityKey.mapFromPlayer(player);
                runParams.put(AbilityKey.Cards, madeCards);
                runParams.put(AbilityKey.Cause, sa);
                game.getTriggerHandler().runTrigger(TriggerType.ConjureAll, runParams, false);
            }
            if (!zone.equals((Object)ZoneType.Library) || sa.hasParam("LibraryPosition")) continue;
            player.shuffle(sa);
        }
    }

    private List<ICardFace> parseFaces(SpellAbility sa, String param) {
        ArrayList<ICardFace> parsedFaces = new ArrayList<ICardFace>();
        for (String s2 : sa.getParam(param).split(",")) {
            s2 = s2.replace(";", ",");
            ICardFace face = StaticData.instance().getCommonCards().getFaceByName(s2);
            if (face == null) {
                throw new RuntimeException("MakeCardEffect didn't find card face by name: " + s2);
            }
            parsedFaces.add(face);
        }
        return parsedFaces;
    }

    private Card finishMaking(SpellAbility sa, Card made, Card source) {
        if (sa.hasParam("FaceDown")) {
            made.turnFaceDown(true);
        }
        if (sa.hasParam("RememberMade")) {
            source.addRemembered(made);
        }
        if (sa.hasParam("ImprintMade")) {
            source.addImprintedCard(made);
        }
        return made;
    }
}

