/*
 * Decompiled with CFR 0.152.
 */
package forge.game.ability.effects;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import forge.game.ability.AbilityKey;
import forge.game.ability.AbilityUtils;
import forge.game.ability.SpellAbilityEffect;
import forge.game.card.Card;
import forge.game.player.Player;
import forge.game.player.PlayerCollection;
import forge.game.player.PlayerController;
import forge.game.spellability.SpellAbility;
import forge.game.trigger.TriggerType;
import forge.util.Lang;
import forge.util.Localizer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class LifeSetEffect
extends SpellAbilityEffect {
    @Override
    public void resolve(SpellAbility sa) {
        Card source = sa.getHostCard();
        boolean redistribute = sa.hasParam("Redistribute");
        int lifeAmount = redistribute ? 0 : AbilityUtils.calculateAmount(source, sa.getParam("LifeAmount"), sa);
        ArrayList<Integer> lifetotals = new ArrayList<Integer>();
        PlayerController pc = sa.getActivatingPlayer().getController();
        PlayerCollection players = new PlayerCollection();
        if (sa.hasParam("PlayerChoices")) {
            PlayerCollection choices = AbilityUtils.getDefinedPlayers(source, sa.getParam("PlayerChoices"), sa);
            int n = 1;
            int min2 = 1;
            if (sa.hasParam("ChoiceAmount")) {
                if (sa.getParam("ChoiceAmount").equals("Any")) {
                    n = choices.size();
                    min2 = 0;
                } else {
                    min2 = n = AbilityUtils.calculateAmount(source, sa.getParam("ChoiceAmount"), sa);
                }
            }
            String prompt = sa.hasParam("ChoicePrompt") ? sa.getParam("ChoicePrompt") : Localizer.getInstance().getMessage("lblChoosePlayer", new Object[0]);
            List chosen = pc.chooseEntitiesForEffect(choices, min2, n, null, sa, prompt, null, null);
            players.addAll(chosen);
        } else {
            players = LifeSetEffect.getTargetPlayers(sa);
        }
        if (players.isEmpty()) {
            return;
        }
        if (redistribute) {
            for (Player p : players) {
                if (!p.isInGame()) continue;
                lifetotals.add(p.getLife());
            }
        }
        HashMap<Player, Integer> lossMap = Maps.newHashMap();
        for (Player p : players.threadSafeIterable()) {
            int diff;
            if (!p.isInGame()) continue;
            int preLife = p.getLife();
            if (!redistribute) {
                p.setLife(lifeAmount, sa);
            } else {
                List<Integer> validChoices = LifeSetEffect.getDistribution(players, true, lifetotals);
                int life = pc.chooseNumber(sa, Localizer.getInstance().getMessage("lblLifeTotal", new Object[0]) + ": " + p, validChoices, p);
                p.setLife(life, sa);
                lifetotals.remove((Object)life);
                players.remove(p);
            }
            if ((diff = preLife - p.getLife()) <= 0) continue;
            lossMap.put(p, diff);
        }
        if (!lossMap.isEmpty()) {
            Map<AbilityKey, Object> runParams = AbilityKey.mapFromPIMap(lossMap);
            source.getGame().getTriggerHandler().runTrigger(TriggerType.LifeLostAll, runParams, false);
        }
    }

    private static List<Integer> getDistribution(List<Player> players, boolean top, List<Integer> remainingChoices) {
        if (players.isEmpty()) {
            remainingChoices.add(1);
            return remainingChoices;
        }
        ArrayList<Integer> validChoices = Lists.newArrayList(remainingChoices);
        for (Player p : players) {
            for (Integer choice : remainingChoices) {
                if (p.getLife() < choice && !p.canGainLife() || p.getLife() > choice && !p.canLoseLife()) {
                    if (!top) continue;
                    validChoices.remove(choice);
                    continue;
                }
                PlayerCollection nextPlayers = new PlayerCollection((Iterable<Player>)players);
                nextPlayers.remove(p);
                List<Integer> nextChoices = new ArrayList<Integer>(remainingChoices);
                nextChoices.remove(choice);
                nextChoices = LifeSetEffect.getDistribution(nextPlayers, false, nextChoices);
                if (nextChoices.isEmpty()) {
                    if (!top) continue;
                    validChoices.remove(choice);
                    continue;
                }
                if (top) continue;
                return nextChoices;
            }
            if (!top) continue;
            return validChoices;
        }
        return new ArrayList<Integer>();
    }

    @Override
    protected String getStackDescription(SpellAbility sa) {
        if (sa.hasParam("Redistribute")) {
            if (sa.hasParam("SpellDescription")) {
                return sa.getParam("SpellDescription");
            }
            return "Please add StackDescription or SpellDescription for Redistribute in LifeSetEffect.";
        }
        StringBuilder sb = new StringBuilder();
        int amount = AbilityUtils.calculateAmount(sa.getHostCard(), sa.getParam("LifeAmount"), sa);
        sb.append(Lang.joinHomogenous(LifeSetEffect.getTargetPlayers(sa)));
        sb.append(" life total becomes ").append(amount).append(".");
        return sb.toString();
    }
}

