/*
 * Decompiled with CFR 0.152.
 */
package forge.game.ability.effects;

import com.google.common.collect.Maps;
import forge.game.Game;
import forge.game.ability.AbilityKey;
import forge.game.ability.SpellAbilityEffect;
import forge.game.card.Card;
import forge.game.event.GameEventCardStatsChanged;
import forge.game.player.Player;
import forge.game.player.PlayerCollection;
import forge.game.spellability.SpellAbility;
import forge.game.trigger.TriggerType;
import java.util.HashMap;
import java.util.Map;

public class LifeExchangeVariantEffect
extends SpellAbilityEffect {
    @Override
    protected String getStackDescription(SpellAbility sa) {
        StringBuilder sb = new StringBuilder();
        Player activatingPlayer = sa.getActivatingPlayer();
        String mode = sa.getParam("Mode");
        sb.append(activatingPlayer).append(" exchanges life totals with ");
        sb.append(sa.getHostCard());
        sb.append("'s ");
        sb.append(mode.toLowerCase());
        return sb.toString();
    }

    @Override
    public void resolve(SpellAbility sa) {
        Card source = sa.getHostCard();
        String mode = sa.getParam("Mode");
        PlayerCollection tgtPlayers = LifeExchangeVariantEffect.getTargetPlayers(sa);
        if (tgtPlayers.isEmpty()) {
            return;
        }
        Player p = (Player)tgtPlayers.get(0);
        Integer power = null;
        Integer toughness = null;
        Game game = p.getGame();
        long timestamp = game.getNextTimestamp();
        int pLife = p.getLife();
        int num = 0;
        if ("Power".equals(mode)) {
            num = source.getNetPower();
            power = pLife;
        } else if ("Toughness".equals(mode)) {
            num = source.getNetToughness();
            toughness = pLife;
        } else {
            return;
        }
        if (!source.isInPlay()) {
            return;
        }
        if (pLife > num && p.canLoseLife()) {
            int diff = pLife - num;
            int lost = p.loseLife(diff, false, false);
            source.addNewPT(power, toughness, timestamp, 0L);
            game.fireEvent(new GameEventCardStatsChanged(source));
            if (lost > 0) {
                HashMap<Player, Integer> lossMap = Maps.newHashMap();
                lossMap.put(p, lost);
                Map<AbilityKey, Object> runParams = AbilityKey.mapFromPIMap(lossMap);
                source.getGame().getTriggerHandler().runTrigger(TriggerType.LifeLostAll, runParams, false);
            }
        } else if (num > pLife && p.canGainLife()) {
            int diff = num - pLife;
            p.gainLife(diff, source, sa);
            source.addNewPT(power, toughness, timestamp, 0L);
            game.fireEvent(new GameEventCardStatsChanged(source));
        }
    }
}

