/*
 * Decompiled with CFR 0.152.
 */
package forge.game.ability.effects;

import forge.game.Game;
import forge.game.ability.AbilityKey;
import forge.game.ability.SpellAbilityEffect;
import forge.game.card.Card;
import forge.game.card.CardZoneTable;
import forge.game.player.Player;
import forge.game.spellability.SpellAbility;
import java.util.EnumMap;

public class LearnEffect
extends SpellAbilityEffect {
    @Override
    protected String getStackDescription(SpellAbility sa) {
        return "Learn. (You may reveal a Lesson card you own from outside the game and put it into your hand, or discard a card to draw a card.)";
    }

    @Override
    public void resolve(SpellAbility sa) {
        Card source = sa.getHostCard();
        Game game = source.getGame();
        EnumMap<AbilityKey, Object> moveParams = AbilityKey.newMap();
        CardZoneTable table = AbilityKey.addCardZoneTableParams(moveParams, sa);
        for (Player p : LearnEffect.getTargetPlayers(sa)) {
            p.learnLesson(sa, moveParams);
        }
        table.triggerChangesZoneAll(game, sa);
    }
}

