/*
 * Decompiled with CFR 0.152.
 */
package forge.game.ability.effects;

import forge.game.Game;
import forge.game.ability.AbilityUtils;
import forge.game.ability.effects.TokenEffectBase;
import forge.game.card.Card;
import forge.game.card.CardZoneTable;
import forge.game.event.GameEventCombatChanged;
import forge.game.event.GameEventTokenCreated;
import forge.game.player.Player;
import forge.game.spellability.SpellAbility;
import forge.util.Lang;
import forge.util.Localizer;
import org.apache.commons.lang3.mutable.MutableBoolean;

public class InvestigateEffect
extends TokenEffectBase {
    @Override
    protected String getStackDescription(SpellAbility sa) {
        Card card = sa.getHostCard();
        int amount = AbilityUtils.calculateAmount(card, sa.getParamOrDefault("Num", "1"), sa);
        StringBuilder sb = new StringBuilder("Investigate");
        if (amount > 1) {
            sb.append(" ").append(Lang.getNumeral(amount)).append(" times");
        }
        sb.append(". (Create a colorless Clue artifact token with \"{2}, Sacrifice this artifact: Draw a card.\")");
        return sb.toString();
    }

    @Override
    public void resolve(SpellAbility sa) {
        Card card = sa.getHostCard();
        Game game = card.getGame();
        int amount = AbilityUtils.calculateAmount(card, sa.getParamOrDefault("Num", "1"), sa);
        for (int i = 0; i < amount; ++i) {
            CardZoneTable triggerList = new CardZoneTable();
            MutableBoolean combatChanged = new MutableBoolean(false);
            for (Player p : InvestigateEffect.getTargetPlayers(sa)) {
                if (sa.hasParam("Optional") && !p.getController().confirmAction(sa, null, Localizer.getInstance().getMessage("lblWouldYouLikeInvestigate", new Object[0]), null)) continue;
                this.makeTokenTable(this.makeTokenTableInternal(p, "c_a_clue_draw", 1, sa), false, triggerList, combatChanged, sa);
                p.addInvestigatedThisTurn();
                if (sa.hasParam("RememberInvestigatingPlayers")) {
                    card.addRemembered(p);
                }
                game.fireEvent(new GameEventTokenCreated());
            }
            triggerList.triggerChangesZoneAll(game, sa);
            if (!combatChanged.isTrue()) continue;
            game.updateCombatForView();
            game.fireEvent(new GameEventCombatChanged());
        }
    }
}

