/*
 * Decompiled with CFR 0.152.
 */
package forge.game.ability.effects;

import com.google.common.base.Predicates;
import com.google.common.collect.Maps;
import forge.game.Game;
import forge.game.ability.AbilityKey;
import forge.game.ability.SpellAbilityEffect;
import forge.game.card.CardCollection;
import forge.game.card.CardLists;
import forge.game.card.CardPredicates;
import forge.game.card.CardZoneTable;
import forge.game.card.CounterEnumType;
import forge.game.player.Player;
import forge.game.player.PlayerCollection;
import forge.game.spellability.SpellAbility;
import forge.game.staticability.StaticAbilityGainLifeRadiation;
import forge.game.trigger.TriggerType;
import forge.game.zone.ZoneType;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;

public class InternalRadiationEffect
extends SpellAbilityEffect {
    @Override
    public void resolve(SpellAbility sa) {
        Player p = sa.getActivatingPlayer();
        Game game = p.getGame();
        int numRad = p.getCounters(CounterEnumType.RAD);
        EnumMap<AbilityKey, Object> moveParams = AbilityKey.newMap();
        CardZoneTable table = AbilityKey.addCardZoneTableParams(moveParams, sa);
        CardCollection milled = game.getAction().mill(new PlayerCollection(p), numRad, ZoneType.Graveyard, sa, moveParams);
        table.triggerChangesZoneAll(game, sa);
        int n = CardLists.count(milled, Predicates.not(CardPredicates.Presets.LANDS));
        if (StaticAbilityGainLifeRadiation.gainLifeRadiation(p)) {
            p.gainLife(n, sa.getHostCard(), sa);
        } else {
            HashMap<Player, Integer> lossMap = Maps.newHashMap();
            int lost = p.loseLife(n, false, false);
            if (lost > 0) {
                lossMap.put(p, lost);
            }
            if (!lossMap.isEmpty()) {
                Map<AbilityKey, Object> runParams = AbilityKey.mapFromPIMap(lossMap);
                game.getTriggerHandler().runTrigger(TriggerType.LifeLostAll, runParams, false);
            }
        }
        p.removeRadCounters(n);
    }
}

