/*
 * Decompiled with CFR 0.152.
 */
package forge.game.ability.effects;

import com.google.common.collect.Maps;
import forge.game.CardTraitBase;
import forge.game.Game;
import forge.game.GameEntity;
import forge.game.ability.AbilityUtils;
import forge.game.ability.SpellAbilityEffect;
import forge.game.card.Card;
import forge.game.spellability.AbilitySub;
import forge.game.spellability.SpellAbility;
import forge.game.trigger.Trigger;
import forge.game.trigger.TriggerHandler;
import forge.game.trigger.TriggerType;
import java.util.HashMap;

public class ImmediateTriggerEffect
extends SpellAbilityEffect {
    @Override
    protected String getStackDescription(SpellAbility sa) {
        if (sa.hasParam("TriggerDescription")) {
            return sa.getParam("TriggerDescription");
        }
        if (sa.hasParam("SpellDescription")) {
            return sa.getParam("SpellDescription");
        }
        return "";
    }

    @Override
    public void resolve(SpellAbility sa) {
        Card host = sa.getHostCard();
        Game game = host.getGame();
        int amt = AbilityUtils.calculateAmount(host, sa.getParamOrDefault("TriggerAmount", "1"), sa);
        if (amt <= 0) {
            return;
        }
        HashMap<String, String> mapParams = Maps.newHashMap(sa.getMapParams());
        if (mapParams.containsKey("SpellDescription") && !mapParams.containsKey("TriggerDescription")) {
            mapParams.put("TriggerDescription", (String)mapParams.get("SpellDescription"));
        }
        mapParams.remove("SpellDescription");
        mapParams.remove("Cost");
        mapParams.put("Mode", TriggerType.Immediate.name());
        Trigger immediateTrig = TriggerHandler.parseTrigger(mapParams, host, sa.isIntrinsic(), null);
        immediateTrig.setSpawningAbility(sa.copy(host, true));
        if (sa.hasParam("RememberObjects")) {
            for (String rem : sa.getParam("RememberObjects").split(",")) {
                for (GameEntity o : AbilityUtils.getDefinedEntities(host, rem, (CardTraitBase)sa)) {
                    immediateTrig.addRemembered(o);
                }
            }
        }
        if (sa.hasParam("RememberSVarAmount")) {
            immediateTrig.addRemembered(AbilityUtils.calculateAmount(host, sa.getSVar(sa.getParam("RememberSVarAmount")), sa));
        }
        if (sa.hasAdditionalAbility("Execute")) {
            SpellAbility overridingSA = sa.getAdditionalAbility("Execute").copy(host, sa.getActivatingPlayer(), false);
            if (overridingSA instanceof AbilitySub) {
                ((AbilitySub)overridingSA).setParent(null);
            }
            immediateTrig.setOverridingAbility(overridingSA);
        }
        for (int i = 0; i < amt; ++i) {
            game.getTriggerHandler().registerDelayedTrigger(immediateTrig);
        }
    }
}

