/*
 * Decompiled with CFR 0.152.
 */
package forge.game.ability.effects;

import forge.game.Game;
import forge.game.ability.AbilityKey;
import forge.game.ability.SpellAbilityEffect;
import forge.game.card.CardCollection;
import forge.game.card.CardZoneTable;
import forge.game.spellability.SpellAbility;
import java.util.EnumMap;

public class EndCombatPhaseEffect
extends SpellAbilityEffect {
    @Override
    public void resolve(SpellAbility sa) {
        Game game = sa.getActivatingPlayer().getGame();
        if (game.getCombat() == null) {
            return;
        }
        game.getTriggerHandler().clearWaitingTriggers();
        EnumMap<AbilityKey, Object> moveParams = AbilityKey.newMap();
        CardZoneTable zoneMovements = AbilityKey.addCardZoneTableParams(moveParams, sa);
        game.getAction().exile(new CardCollection(game.getStackZone().getCards()), sa, moveParams);
        zoneMovements.triggerChangesZoneAll(game, sa);
        game.getStack().clear();
        game.getStack().clearSimultaneousStack();
        game.getAction().checkStateEffects(true);
        game.getPhaseHandler().endCombatPhaseByEffect();
    }

    @Override
    protected String getStackDescription(SpellAbility sa) {
        return "End the combat phase.";
    }
}

