/*
 * Decompiled with CFR 0.152.
 */
package forge.game.ability.effects;

import forge.game.Game;
import forge.game.ability.AbilityKey;
import forge.game.ability.AbilityUtils;
import forge.game.ability.SpellAbilityEffect;
import forge.game.card.Card;
import forge.game.card.CardCollection;
import forge.game.card.CardLists;
import forge.game.card.CardZoneTable;
import forge.game.cost.CostDiscard;
import forge.game.cost.CostPart;
import forge.game.cost.CostReveal;
import forge.game.player.Player;
import forge.game.player.PlayerCollection;
import forge.game.spellability.SpellAbility;
import forge.game.trigger.TriggerType;
import forge.game.zone.PlayerZone;
import forge.game.zone.Zone;
import forge.game.zone.ZoneType;
import forge.util.CardTranslation;
import forge.util.Lang;
import forge.util.Localizer;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class DiscoverEffect
extends SpellAbilityEffect {
    @Override
    protected String getStackDescription(SpellAbility sa) {
        PlayerCollection players = DiscoverEffect.getDefinedPlayersOrTargeted(sa);
        String verb = players.size() == 1 ? " discovers " : " discover ";
        return Lang.joinHomogenous(players) + verb + sa.getParamOrDefault("Num", "1") + ".";
    }

    @Override
    public void resolve(SpellAbility sa) {
        Card host = sa.getHostCard();
        Game game = host.getGame();
        PlayerCollection players = DiscoverEffect.getDefinedPlayersOrTargeted(sa);
        int num = AbilityUtils.calculateAmount(host, sa.getParamOrDefault("Num", "1"), sa);
        for (Player p : players) {
            if (p == null || !p.isInGame()) {
                return;
            }
            Card found = null;
            CardCollection exiled = new CardCollection();
            CardCollection rest = new CardCollection();
            PlayerZone library = p.getZone(ZoneType.Library);
            for (Card c : library) {
                exiled.add(c);
                if (!c.isLand() && c.getCMC() <= num) {
                    found = c;
                    if (!sa.hasParam("RememberDiscovered")) break;
                    host.addRemembered(c);
                    break;
                }
                rest.add(c);
            }
            game.getAction().reveal(exiled, p, false);
            this.changeZone(exiled, ZoneType.Exile, game, sa);
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("Card", found);
            if (found != null) {
                String prompt = Localizer.getInstance().getMessage("lblDiscoverChoice", CardTranslation.getTranslatedName(found.getName()));
                Zone origin = found.getZone();
                List<String> options = Arrays.asList(StringUtils.capitalize(Localizer.getInstance().getMessage("lblCast", new Object[0])), StringUtils.capitalize(Localizer.getInstance().getMessage("lblHandZone", new Object[0])));
                boolean play = p.getController().confirmAction(sa, null, prompt, options, found, params);
                boolean cancel = false;
                if (play) {
                    List<SpellAbility> sas = AbilityUtils.getBasicSpellsFromPlayEffect(found, p);
                    sas.removeIf(sp -> sp.isLandAbility());
                    sas.removeIf(sp -> sp.getPayCosts().getTotalMana().getCMC() > num);
                    if (sas.isEmpty()) {
                        System.err.println("DiscoverEffect Error: " + host + " found " + found + " but couldn't play sa");
                    } else {
                        SpellAbility tgtSA = p.getController().getAbilityToPlay(found, sas);
                        if (tgtSA == null) {
                            cancel = true;
                        } else {
                            Card played;
                            Zone zone;
                            tgtSA = tgtSA.copyWithNoManaCost();
                            boolean optional = false;
                            for (CostPart cost : tgtSA.getPayCosts().getCostParts()) {
                                if (!(cost instanceof CostDiscard) && !(cost instanceof CostReveal) || cost.getType().equals("Card") || cost.getType().equals("Random")) continue;
                                optional = true;
                                break;
                            }
                            if (!optional) {
                                tgtSA.getPayCosts().setMandatory(true);
                            }
                            if (tgtSA.usesTargeting() && !optional) {
                                tgtSA.getTargetRestrictions().setMandatory(true);
                            }
                            if (p.getController().playSaFromPlayEffect(tgtSA) && !origin.equals(zone = game.getCardState(played = tgtSA.getHostCard()).getZone())) {
                                CardZoneTable trigList = new CardZoneTable();
                                trigList.put(origin.getZoneType(), zone.getZoneType(), game.getCardState(found));
                                trigList.triggerChangesZoneAll(game, sa);
                            }
                        }
                    }
                }
                if (!play || cancel) {
                    this.changeZone(new CardCollection(found), ZoneType.Hand, game, sa);
                }
            }
            this.changeZone(rest, ZoneType.Library, game, sa);
            Map<AbilityKey, Object> runParams = AbilityKey.mapFromPlayer(p);
            runParams.put(AbilityKey.Amount, num);
            game.getTriggerHandler().runTrigger(TriggerType.Discover, runParams, false);
        }
    }

    private void changeZone(CardCollection cards, ZoneType zone, Game game, SpellAbility sa) {
        CardZoneTable table = new CardZoneTable();
        EnumMap<AbilityKey, Object> moveParams = AbilityKey.newMap();
        moveParams.put(AbilityKey.LastStateBattlefield, game.copyLastStateBattlefield());
        moveParams.put(AbilityKey.LastStateGraveyard, game.copyLastStateGraveyard());
        int pos = 0;
        boolean exileSeq = ZoneType.Exile.equals((Object)zone);
        if (ZoneType.Library.equals((Object)zone)) {
            pos = -1;
            CardLists.shuffle(cards);
        }
        for (Card c : cards) {
            ZoneType origin = c.getZone().getZoneType();
            Card m4 = game.getAction().moveTo(zone, c, pos, sa, moveParams);
            if (m4 == null || origin.equals((Object)m4.getZone().getZoneType())) continue;
            table.put(origin, m4.getZone().getZoneType(), m4);
            if (!exileSeq) continue;
            table.triggerChangesZoneAll(game, sa);
            table.clear();
        }
        if (!exileSeq) {
            table.triggerChangesZoneAll(game, sa);
        }
    }
}

