/*
 * Decompiled with CFR 0.152.
 */
package forge.game.ability.effects;

import com.google.common.collect.Maps;
import forge.game.CardTraitBase;
import forge.game.Game;
import forge.game.ability.AbilityKey;
import forge.game.ability.AbilityUtils;
import forge.game.ability.SpellAbilityEffect;
import forge.game.card.Card;
import forge.game.card.CardCollection;
import forge.game.card.CardCollectionView;
import forge.game.card.CardLists;
import forge.game.card.CardZoneTable;
import forge.game.player.Player;
import forge.game.spellability.SpellAbility;
import forge.game.zone.PlayerZone;
import forge.game.zone.ZoneType;
import forge.util.Localizer;
import java.util.Collections;
import java.util.HashMap;

public class DigMultipleEffect
extends SpellAbilityEffect {
    @Override
    public void resolve(SpellAbility sa) {
        Card host = sa.getHostCard();
        Player player = sa.getActivatingPlayer();
        Game game = player.getGame();
        int digNum = AbilityUtils.calculateAmount(host, sa.getParam("DigNum"), sa);
        ZoneType srcZone = sa.hasParam("SourceZone") ? ZoneType.smartValueOf(sa.getParam("SourceZone")) : ZoneType.Library;
        ZoneType destZone1 = sa.hasParam("DestinationZone") ? ZoneType.smartValueOf(sa.getParam("DestinationZone")) : ZoneType.Hand;
        ZoneType destZone2 = sa.hasParam("DestinationZone2") ? ZoneType.smartValueOf(sa.getParam("DestinationZone2")) : ZoneType.Library;
        int libraryPosition = sa.hasParam("LibraryPosition") ? Integer.parseInt(sa.getParam("LibraryPosition")) : -1;
        int libraryPosition2 = sa.hasParam("LibraryPosition2") ? Integer.parseInt(sa.getParam("LibraryPosition2")) : -1;
        String changeValid = sa.getParamOrDefault("ChangeValid", "");
        boolean chooseOptional = sa.hasParam("Optional");
        CardZoneTable table = new CardZoneTable();
        for (Player chooser : DigMultipleEffect.getDefinedPlayersOrTargeted(sa)) {
            ZoneType origin;
            if (!chooser.isInGame()) continue;
            CardCollection top = new CardCollection();
            CardCollection rest = new CardCollection();
            PlayerZone sourceZone = chooser.getZone(srcZone);
            int numToDig = Math.min(digNum, sourceZone.size());
            for (int i = 0; i < numToDig; ++i) {
                top.add(sourceZone.get(i));
            }
            if (top.isEmpty()) continue;
            rest.addAll(top);
            if (sa.hasParam("Reveal")) {
                game.getAction().reveal(top, chooser, false);
            } else {
                game.getAction().revealTo((CardCollectionView)top, chooser);
            }
            HashMap<String, CardCollection> validMap = Maps.newHashMap();
            for (String valid : changeValid.split(",")) {
                CardCollection list = CardLists.getValidCards((Iterable<Card>)top, valid, host.getController(), host, (CardTraitBase)sa);
                if (list.isEmpty()) continue;
                validMap.put(valid, list);
            }
            if (validMap.isEmpty()) {
                chooser.getController().notifyOfValue(sa, null, Localizer.getInstance().getMessage("lblNoValidCards", new Object[0]));
            } else {
                CardCollection chosen;
                while (true) {
                    if (!(chosen = chooser.getController().chooseCardsForEffectMultiple(validMap, sa, Localizer.getInstance().getMessage("lblChooseCards", new Object[0]), chooseOptional)).isEmpty()) {
                        game.getAction().reveal(chosen, chooser, true, Localizer.getInstance().getMessage("lblPlayerPickedCardFrom", chooser.getName()));
                        break;
                    }
                    if (chooseOptional) break;
                    chooser.getController().notifyOfValue(sa, null, Localizer.getInstance().getMessage("lblMustChoose", new Object[0]));
                }
                if (sa.hasParam("ChooseAmount") || sa.hasParam("ChosenZone")) {
                    int amount = AbilityUtils.calculateAmount(host, sa.getParamOrDefault("ChooseAmount", "1"), sa);
                    ZoneType chosenZone = sa.hasParam("ChosenZone") ? ZoneType.smartValueOf(sa.getParam("ChosenZone")) : ZoneType.Battlefield;
                    CardCollectionView extraChosen = chooser.getController().chooseCardsForEffect(chosen, sa, Localizer.getInstance().getMessage("lblChooseCards", new Object[0]), amount, amount, false, null);
                    if (!extraChosen.isEmpty()) {
                        game.getAction().reveal(extraChosen, chooser, true, Localizer.getInstance().getMessage("lblPlayerPickedCardFrom", chooser.getName()));
                    }
                    for (Card c : extraChosen) {
                        ZoneType origin2 = c.getZone().getZoneType();
                        PlayerZone zone = c.getOwner().getZone(chosenZone);
                        chosen.remove(c);
                        rest.remove(c);
                        c = game.getAction().moveTo(zone, c, sa);
                        if (origin2.equals((Object)c.getZone().getZoneType())) continue;
                        table.put(origin2, c.getZone().getZoneType(), c);
                    }
                }
                for (Card c : chosen) {
                    origin = c.getZone().getZoneType();
                    PlayerZone zone = c.getOwner().getZone(destZone1);
                    if (!sa.hasParam("ChangeLater")) {
                        if (zone.getZoneType().isDeck()) {
                            c = game.getAction().moveTo(destZone1, c, libraryPosition, sa, AbilityKey.newMap());
                        } else {
                            if (destZone1.equals((Object)ZoneType.Battlefield) && sa.hasParam("Tapped")) {
                                c.setTapped(true);
                            }
                            c = game.getAction().moveTo(zone, c, sa);
                        }
                        if (!origin.equals((Object)c.getZone().getZoneType())) {
                            table.put(origin, c.getZone().getZoneType(), c);
                        }
                    }
                    if (sa.hasParam("ExileFaceDown")) {
                        c.turnFaceDown(true);
                    }
                    if (sa.hasParam("Imprint")) {
                        host.addImprintedCard(c);
                    }
                    if (sa.hasParam("ForgetOtherRemembered")) {
                        host.clearRemembered();
                    }
                    if (sa.hasParam("RememberChanged")) {
                        host.addRemembered(c);
                    }
                    rest.remove(c);
                }
            }
            if (!sa.hasParam("ChangeLater")) {
                if (destZone2.isDeck() || destZone2 == ZoneType.Graveyard) {
                    CardCollection afterOrder = rest;
                    if (sa.hasParam("RestRandomOrder")) {
                        CardLists.shuffle(afterOrder);
                    }
                    if (libraryPosition2 != -1) {
                        Collections.reverse(afterOrder);
                    }
                    for (Card c : afterOrder) {
                        origin = c.getZone().getZoneType();
                        Card m4 = game.getAction().moveTo(destZone2, c, libraryPosition2, sa, AbilityKey.newMap());
                        if (m4 == null || origin.equals((Object)m4.getZone().getZoneType())) continue;
                        table.put(origin, m4.getZone().getZoneType(), m4);
                    }
                } else {
                    for (Card c : rest) {
                        ZoneType origin3 = c.getZone().getZoneType();
                        PlayerZone toZone = c.getOwner().getZone(destZone2);
                        c = game.getAction().moveTo(toZone, c, sa);
                        if (origin3.equals((Object)c.getZone().getZoneType())) continue;
                        table.put(origin3, c.getZone().getZoneType(), c);
                    }
                }
            }
            if (!sa.hasParam("ImprintRest")) continue;
            host.addImprintedCards(rest);
        }
        table.triggerChangesZoneAll(game, sa);
    }
}

