/*
 * Decompiled with CFR 0.152.
 */
package forge.game.ability.effects;

import forge.card.GamePieceType;
import forge.game.Game;
import forge.game.card.Card;
import forge.game.player.Player;

public class DetachedCardEffect
extends Card {
    private Card card;

    public DetachedCardEffect(Card card0, String name0) {
        super(card0.getOwner().getGame().nextCardId(), card0.getPaperCard(), card0.getOwner().getGame());
        this.card = card0;
        this.setName(name0);
        this.setOwner(card0.getOwner());
        this.setGamePieceType(GamePieceType.EFFECT);
        this.setEffectSource(card0);
    }

    public DetachedCardEffect(Player owner, String name) {
        super(owner.getGame().nextCardId(), null, owner.getGame());
        this.card = null;
        this.setName(name);
        this.setOwner(owner);
        this.setGamePieceType(GamePieceType.EFFECT);
    }

    public DetachedCardEffect(DetachedCardEffect from, boolean assignNewId) {
        this(from, from.getGame(), assignNewId);
    }

    public DetachedCardEffect(DetachedCardEffect from, Game game, boolean assignNewId) {
        super(assignNewId ? game.nextCardId() : from.id, from.getPaperCard(), game);
        this.setName(from.getName());
        this.setGamePieceType(GamePieceType.EFFECT);
        if (from.getGame() == game) {
            this.setOwner(from.getOwner());
            this.setEffectSource(from.getEffectSource());
        }
    }

    @Override
    public Card getCardForUi() {
        return this.card;
    }
}

