/*
 * Decompiled with CFR 0.152.
 */
package forge.game.ability.effects;

import forge.game.CardTraitBase;
import forge.game.Game;
import forge.game.GameActionUtil;
import forge.game.ability.AbilityKey;
import forge.game.ability.AbilityUtils;
import forge.game.ability.SpellAbilityEffect;
import forge.game.card.Card;
import forge.game.card.CardCollectionView;
import forge.game.card.CardLists;
import forge.game.card.CardPredicates;
import forge.game.card.CardZoneTable;
import forge.game.player.Player;
import forge.game.spellability.SpellAbility;
import forge.game.zone.ZoneType;
import forge.util.Localizer;
import forge.util.TextUtil;
import java.util.EnumMap;

public class DestroyAllEffect
extends SpellAbilityEffect {
    @Override
    protected String getStackDescription(SpellAbility sa) {
        if (sa.hasParam("SpellDescription")) {
            return sa.getParam("SpellDescription");
        }
        StringBuilder sb = new StringBuilder();
        boolean noRegen = sa.hasParam("NoRegen");
        sb.append(sa.getHostCard().getName()).append(" - Destroy permanents.");
        if (noRegen) {
            sb.append(" They can't be regenerated");
        }
        return sb.toString();
    }

    @Override
    public void resolve(SpellAbility sa) {
        boolean noRegen = sa.hasParam("NoRegen");
        Card card = sa.getHostCard();
        boolean isOptional = sa.hasParam("Optional");
        Game game = sa.getActivatingPlayer().getGame();
        String desc = sa.getParamOrDefault("ValidDescription", "");
        Player targetPlayer = sa.getTargets().getFirstTargetedPlayer();
        String valid = sa.getParamOrDefault("ValidCards", "");
        if (valid.contains("X")) {
            valid = TextUtil.fastReplace(valid, "X", Integer.toString(AbilityUtils.calculateAmount(card, "X", sa)));
        }
        CardCollectionView list = game.getCardsIn(ZoneType.Battlefield);
        if (targetPlayer != null) {
            list = CardLists.filterControlledBy((Iterable<Card>)list, targetPlayer);
        }
        list = AbilityUtils.filterListByType(list, valid, sa);
        boolean remDestroyed = sa.hasParam("RememberDestroyed");
        if (remDestroyed) {
            card.clearRemembered();
        }
        if (sa.hasParam("RememberAllObjects")) {
            card.addRemembered(list);
        }
        if (list.isEmpty() && isOptional) {
            return;
        }
        if (isOptional && !sa.getActivatingPlayer().getController().confirmAction(sa, null, Localizer.getInstance().getMessage("lblWouldYouLikeDestroy", desc), null)) {
            return;
        }
        list = CardLists.filter((Iterable<Card>)list, CardPredicates.Presets.CAN_BE_DESTROYED);
        list = GameActionUtil.orderCardsByTheirOwners(game, list, ZoneType.Graveyard, sa);
        EnumMap<AbilityKey, Object> params = AbilityKey.newMap();
        CardZoneTable zoneMovements = AbilityKey.addCardZoneTableParams(params, sa);
        for (Card c : list) {
            if (sa.hasParam("NoRegenValid")) {
                noRegen = c.isValid(sa.getParam("NoRegenValid"), sa.getActivatingPlayer(), card, (CardTraitBase)sa);
            }
            if (!game.getAction().destroy(c, sa, !noRegen, params) || !remDestroyed) continue;
            card.addRemembered(zoneMovements.getLastStateBattlefield().get(c));
        }
        zoneMovements.triggerChangesZoneAll(game, sa);
    }
}

