/*
 * Decompiled with CFR 0.152.
 */
package forge.game.ability.effects;

import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import forge.GameCommand;
import forge.game.CardTraitBase;
import forge.game.Game;
import forge.game.GameEntity;
import forge.game.ability.AbilityUtils;
import forge.game.ability.ApiType;
import forge.game.ability.SpellAbilityEffect;
import forge.game.card.Card;
import forge.game.player.Player;
import forge.game.spellability.AbilitySub;
import forge.game.spellability.SpellAbility;
import forge.game.trigger.Trigger;
import forge.game.trigger.TriggerHandler;
import java.util.HashMap;

public class DelayedTriggerEffect
extends SpellAbilityEffect {
    @Override
    protected String getStackDescription(SpellAbility sa) {
        if (sa.hasParam("TriggerDescription")) {
            return sa.getParam("TriggerDescription");
        }
        if (sa.hasParam("SpellDescription")) {
            return sa.getParam("SpellDescription");
        }
        return "";
    }

    @Override
    public void resolve(SpellAbility sa) {
        Card host = sa.getHostCard();
        Game game = host.getGame();
        HashMap<String, String> mapParams = Maps.newHashMap(sa.getMapParams());
        if (mapParams.containsKey("SpellDescription") && !mapParams.containsKey("TriggerDescription")) {
            mapParams.put("TriggerDescription", (String)mapParams.get("SpellDescription"));
        }
        mapParams.remove("SpellDescription");
        mapParams.remove("Cost");
        final Trigger delTrig = TriggerHandler.parseTrigger(mapParams, host, sa.isIntrinsic(), null);
        delTrig.setSpawningAbility(sa.copy(host, true));
        delTrig.setActiveZone(null);
        if (sa.hasParam("RememberObjects")) {
            for (String rem : sa.getParam("RememberObjects").split(",")) {
                for (GameEntity o : AbilityUtils.getDefinedEntities(host, rem, (CardTraitBase)sa)) {
                    delTrig.addRemembered(o);
                }
            }
        }
        if (sa.hasParam("RememberNumber")) {
            for (Object e : host.getRemembered()) {
                if (!(e instanceof Integer)) continue;
                delTrig.addRemembered(e);
            }
        }
        if (sa.hasParam("RememberSVarAmount")) {
            delTrig.addRemembered(AbilityUtils.calculateAmount(host, sa.getSVar(sa.getParam("RememberSVarAmount")), sa));
        }
        if (sa.hasAdditionalAbility("Execute")) {
            SpellAbility overridingSA = sa.getAdditionalAbility("Execute").copy(host, sa.getActivatingPlayer(), false);
            if (overridingSA instanceof AbilitySub) {
                ((AbilitySub)overridingSA).setParent(null);
            }
            if (ApiType.SetState == overridingSA.getApi()) {
                overridingSA.setSVar("StoredTransform", String.valueOf(host.getTransformedTimestamp()));
            }
            delTrig.setOverridingAbility(overridingSA);
        }
        final TriggerHandler trigHandler = game.getTriggerHandler();
        if (mapParams.containsKey("DelayedTriggerDefinedPlayer")) {
            Player player = Iterables.getFirst(AbilityUtils.getDefinedPlayers(host, (String)mapParams.get("DelayedTriggerDefinedPlayer"), sa), null);
            trigHandler.registerPlayerDefinedDelayedTrigger(player, delTrig);
        } else if (mapParams.containsKey("ThisTurn")) {
            trigHandler.registerThisTurnDelayedTrigger(delTrig);
        } else if (mapParams.containsKey("NextTurn")) {
            GameCommand gameCommand = new GameCommand(){
                private static final long serialVersionUID = -5861518814760561373L;

                @Override
                public void run() {
                    trigHandler.registerThisTurnDelayedTrigger(delTrig);
                }
            };
            game.getCleanup().addUntil(gameCommand);
        } else if (mapParams.containsKey("UpcomingTurn")) {
            GameCommand gameCommand = new GameCommand(){
                private static final long serialVersionUID = -5860518814760461373L;

                @Override
                public void run() {
                    trigHandler.registerDelayedTrigger(delTrig);
                }
            };
            game.getCleanup().addUntil(gameCommand);
        } else {
            trigHandler.registerDelayedTrigger(delTrig);
        }
    }
}

