/*
 * Decompiled with CFR 0.152.
 */
package forge.game.ability.effects;

import com.google.common.collect.Lists;
import forge.GameCommand;
import forge.game.CardTraitBase;
import forge.game.Game;
import forge.game.GameEntity;
import forge.game.ability.AbilityFactory;
import forge.game.ability.AbilityUtils;
import forge.game.ability.SpellAbilityEffect;
import forge.game.card.Card;
import forge.game.card.CardCollection;
import forge.game.card.CardLists;
import forge.game.card.CardUtil;
import forge.game.event.GameEventPlayerStatsChanged;
import forge.game.player.Player;
import forge.game.replacement.ReplacementEffect;
import forge.game.replacement.ReplacementHandler;
import forge.game.spellability.AbilitySub;
import forge.game.spellability.SpellAbility;
import forge.game.zone.ZoneType;
import forge.util.Aggregates;
import forge.util.TextUtil;
import forge.util.collect.FCollection;
import java.util.List;

public class DamagePreventEffect
extends SpellAbilityEffect {
    @Override
    protected String getStackDescription(SpellAbility sa) {
        StringBuilder sb = new StringBuilder();
        List<GameEntity> tgts = DamagePreventEffect.getTargetEntities(sa);
        sb.append("Prevent the next ");
        sb.append(sa.getParam("Amount"));
        sb.append(" damage that would be dealt ");
        if (sa.isDividedAsYouChoose()) {
            sb.append("between ");
        } else {
            sb.append("to ");
        }
        for (int i = 0; i < tgts.size(); ++i) {
            GameEntity o;
            if (i != 0) {
                sb.append(" ");
            }
            if ((o = tgts.get(i)) instanceof Card) {
                Card tgtC = (Card)o;
                if (tgtC.isFaceDown()) {
                    sb.append("Morph");
                    continue;
                }
                sb.append(tgtC);
                continue;
            }
            if (!(o instanceof Player)) continue;
            sb.append(((Object)o).toString());
        }
        if (sa.hasParam("Radiance") && sa.usesTargeting()) {
            sb.append(" and each other ").append(sa.getParam("ValidTgts")).append(" that shares a color with ");
            if (tgts.size() > 1) {
                sb.append("them");
            } else {
                sb.append("it");
            }
        }
        sb.append(" this turn.");
        return sb.toString();
    }

    @Override
    public void resolve(SpellAbility sa) {
        Card host = sa.getHostCard();
        int numDam = AbilityUtils.calculateAmount(host, sa.getParam("Amount"), sa);
        List<Object> tgts = Lists.newArrayList();
        if (sa.hasParam("CardChoices") || sa.hasParam("PlayerChoices")) {
            FCollection<GameEntity> choices = new FCollection<GameEntity>();
            if (sa.hasParam("CardChoices")) {
                choices.addAll(CardLists.getValidCards((Iterable<Card>)host.getGame().getCardsIn(ZoneType.Battlefield), sa.getParam("CardChoices"), sa.getActivatingPlayer(), host, (CardTraitBase)sa));
            }
            if (sa.hasParam("PlayerChoices")) {
                choices.addAll(AbilityUtils.getDefinedPlayers(host, sa.getParam("PlayerChoices"), sa));
            }
            if (sa.hasParam("Random")) {
                GameEntity random = (GameEntity)Aggregates.random(choices);
                tgts.add(random);
                host.addRemembered(random);
            }
        } else {
            tgts = DamagePreventEffect.getTargetEntities(sa);
        }
        CardCollection untargetedCards = CardUtil.getRadiance(sa);
        for (GameEntity gameEntity : tgts) {
            int n = numDam = sa.usesTargeting() && sa.isDividedAsYouChoose() ? sa.getDividedValue(gameEntity) : numDam;
            if (gameEntity instanceof Card) {
                Card c = (Card)gameEntity;
                if (!c.isInPlay()) continue;
                DamagePreventEffect.addPreventNextDamage(sa, gameEntity, numDam);
                continue;
            }
            if (!(gameEntity instanceof Player)) continue;
            DamagePreventEffect.addPreventNextDamage(sa, gameEntity, numDam);
        }
        for (Card card : untargetedCards) {
            if (!card.isInPlay()) continue;
            DamagePreventEffect.addPreventNextDamage(sa, card, numDam);
        }
    }

    private static void addPreventNextDamage(SpellAbility sa, final GameEntity o, int numDam) {
        Card hostCard = sa.getHostCard();
        final Game game = hostCard.getGame();
        Player player = hostCard.getController();
        String name = hostCard + "'s Effect";
        String image = hostCard.getImageKey();
        StringBuilder sb = new StringBuilder("Event$ DamageDone | ActiveZones$ Command | ValidTarget$ ");
        sb.append(o instanceof Card ? "Card.IsRemembered" : "Player.IsRemembered");
        sb.append(" | PreventionEffect$ NextN | Description$ Prevent the next ").append(numDam).append(" damage.");
        String effect = "DB$ ReplaceDamage | Amount$ ShieldAmount";
        final Card eff = DamagePreventEffect.createEffect(sa, player, name, image);
        eff.setSVar("ShieldAmount", "Number$" + numDam);
        eff.setSVar("PreventedDamage", "Number$0");
        eff.addRemembered(o);
        SpellAbility replaceDamage = AbilityFactory.getAbility(effect, eff);
        if (sa.hasParam("PreventionSubAbility")) {
            String subAbString = sa.getSVar(sa.getParam("PreventionSubAbility"));
            if (sa.hasParam("ShieldEffectTarget")) {
                FCollection<GameEntity> effTgts = AbilityUtils.getDefinedEntities(hostCard, sa.getParam("ShieldEffectTarget"), (CardTraitBase)sa);
                String effTgtString = "";
                for (GameEntity effTgt : effTgts) {
                    if (effTgt instanceof Card) {
                        effTgtString = "CardUID_" + String.valueOf(((Card)effTgt).getId());
                        continue;
                    }
                    if (!(effTgt instanceof Player)) continue;
                    effTgtString = "PlayerNamed_" + ((Player)effTgt).getName();
                }
                subAbString = TextUtil.fastReplace(subAbString, "ShieldEffectTarget", effTgtString);
            }
            AbilitySub subSA = (AbilitySub)AbilityFactory.getAbility(subAbString, eff);
            replaceDamage.setSubAbility(subSA);
            sb.append(" ").append(subSA.getParam("SpellDescription"));
        }
        String repeffstr = sb.toString();
        ReplacementEffect re = ReplacementHandler.parseReplacement(repeffstr, eff, true);
        re.setOverridingAbility(replaceDamage);
        eff.addReplacementEffect(re);
        if (o instanceof Card) {
            DamagePreventEffect.addForgetOnMovedTrigger(eff, "Battlefield");
        }
        game.getAction().moveToCommand(eff, sa);
        o.getView().updatePreventNextDamage(o);
        if (o instanceof Player) {
            game.fireEvent(new GameEventPlayerStatsChanged((Player)o, false));
        }
        game.getEndOfTurn().addUntil(new GameCommand(){
            private static final long serialVersionUID = 1L;

            @Override
            public void run() {
                game.getAction().exileEffect(eff);
                o.getView().updatePreventNextDamage(o);
                if (o instanceof Player) {
                    game.fireEvent(new GameEventPlayerStatsChanged((Player)o, false));
                }
            }
        });
    }
}

