/*
 * Decompiled with CFR 0.152.
 */
package forge.game.ability.effects;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import forge.game.Game;
import forge.game.GameEntityCounterTable;
import forge.game.ability.AbilityUtils;
import forge.game.ability.SpellAbilityEffect;
import forge.game.card.Card;
import forge.game.card.CounterType;
import forge.game.player.Player;
import forge.game.player.PlayerController;
import forge.game.spellability.SpellAbility;
import forge.util.CardTranslation;
import forge.util.Expressions;
import forge.util.Lang;
import forge.util.Localizer;
import java.util.ArrayList;
import java.util.HashMap;

public class CountersPutOrRemoveEffect
extends SpellAbilityEffect {
    @Override
    protected String getStackDescription(SpellAbility sa) {
        if (sa.hasParam("AddConditionSVar")) {
            return "Add StackDescription for AddOrRemoveCounter line with condition!";
        }
        StringBuilder sb = new StringBuilder();
        Player pl = sa.hasParam("DefinedPlayer") ? (Player)AbilityUtils.getDefinedPlayers(sa.getHostCard(), sa.getParam("DefinedPlayer"), sa).getFirst() : sa.getActivatingPlayer();
        sb.append(pl.getName());
        if (sa.hasParam("CounterType")) {
            CounterType ctype = CounterType.getType(sa.getParam("CounterType"));
            sb.append(" puts a ").append(ctype.getName());
            sb.append(" counter on or removes a ").append(ctype.getName()).append(" counter from ");
        } else {
            sb.append(" removes a counter from or puts another of those counters on ");
        }
        sb.append(Lang.joinHomogenous(CountersPutOrRemoveEffect.getDefinedCardsOrTargeted(sa))).append(".");
        return sb.toString();
    }

    @Override
    public void resolve(SpellAbility sa) {
        Card source = sa.getHostCard();
        Game game = source.getGame();
        int counterAmount = AbilityUtils.calculateAmount(source, sa.getParamOrDefault("CounterNum", "1"), sa);
        if (counterAmount <= 0) {
            return;
        }
        CounterType ctype = null;
        if (sa.hasParam("CounterType")) {
            ctype = CounterType.getType(sa.getParam("CounterType"));
        }
        Player pl = !sa.hasParam("DefinedPlayer") ? sa.getActivatingPlayer() : (Player)AbilityUtils.getDefinedPlayers(source, sa.getParam("DefinedPlayer"), sa).getFirst();
        boolean eachExisting = sa.hasParam("EachExistingCounter");
        GameEntityCounterTable table = new GameEntityCounterTable();
        for (Card tgtCard : CountersPutOrRemoveEffect.getDefinedCardsOrTargeted(sa)) {
            Card gameCard = game.getCardState(tgtCard, null);
            if (gameCard == null || !tgtCard.equalsWithGameTimestamp(gameCard) || !eachExisting && sa.hasParam("Optional") && !pl.getController().confirmAction(sa, null, Localizer.getInstance().getMessage("lblWouldYouLikePutRemoveCounters", ctype.getName(), CardTranslation.getTranslatedName(gameCard.getName())), null)) continue;
            if (gameCard.hasCounters()) {
                if (eachExisting) {
                    for (CounterType listType : Lists.newArrayList(gameCard.getCounters().keySet())) {
                        this.addOrRemoveCounter(sa, gameCard, listType, counterAmount, table, pl);
                    }
                    continue;
                }
                this.addOrRemoveCounter(sa, gameCard, ctype, counterAmount, table, pl);
                continue;
            }
            if (eachExisting || ctype == null) continue;
            gameCard.addCounter(ctype, counterAmount, pl, table);
        }
        table.replaceCounterEffect(game, sa, true);
    }

    private void addOrRemoveCounter(SpellAbility sa, Card tgtCard, CounterType ctype, int counterAmount, GameEntityCounterTable table, Player pl) {
        boolean putCounter;
        PlayerController pc = pl.getController();
        HashMap<String, Object> params = Maps.newHashMap();
        params.put("Target", tgtCard);
        ArrayList<CounterType> list = Lists.newArrayList(tgtCard.getCounters().keySet());
        if (ctype != null) {
            list = Lists.newArrayList(ctype);
        }
        String prompt = Localizer.getInstance().getMessage("lblSelectCounterTypeToAddOrRemove", new Object[0]);
        CounterType chosenType = pc.chooseCounterType(list, sa, prompt, params);
        params.put("CounterType", chosenType);
        prompt = Localizer.getInstance().getMessage("lblWhatToDoWithTargetCounter", chosenType.getName(), CardTranslation.getTranslatedName(tgtCard.getName())) + " ";
        if (sa.hasParam("RemoveConditionSVar")) {
            String operand;
            int operandValue;
            String compare;
            String operator;
            Card host = sa.getHostCard();
            int value = AbilityUtils.calculateAmount(host, sa.getParam("RemoveConditionSVar"), sa);
            putCounter = !Expressions.compare(value, operator = (compare = sa.getParamOrDefault("RemoveConditionSVarCompare", "GE1")).substring(0, 2), operandValue = AbilityUtils.calculateAmount(host, operand = compare.substring(2), sa));
        } else {
            boolean canReceive = tgtCard.canReceiveCounters(ctype);
            boolean canRemove = tgtCard.canRemoveCounters(ctype);
            if (!canReceive && !canRemove) {
                return;
            }
            putCounter = canReceive && !canRemove ? true : (!canReceive && canRemove ? false : pc.chooseBinary(sa, prompt, PlayerController.BinaryChoiceType.AddOrRemove, params));
        }
        if (putCounter) {
            tgtCard.addCounter(chosenType, counterAmount, pl, table);
        } else {
            tgtCard.subtractCounter(chosenType, counterAmount, pl);
            if (sa.hasParam("RememberRemovedCards")) {
                sa.getHostCard().addRemembered(tgtCard);
            }
        }
    }
}

