/*
 * Decompiled with CFR 0.152.
 */
package forge.game.ability.effects;

import com.google.common.collect.Lists;
import forge.game.CardTraitBase;
import forge.game.Game;
import forge.game.GameLogEntryType;
import forge.game.ability.AbilityKey;
import forge.game.ability.ApiType;
import forge.game.ability.SpellAbilityEffect;
import forge.game.card.Card;
import forge.game.card.CardCollection;
import forge.game.card.CardCollectionView;
import forge.game.card.CardCopyService;
import forge.game.card.CardLists;
import forge.game.card.CardZoneTable;
import forge.game.replacement.ReplacementResult;
import forge.game.replacement.ReplacementType;
import forge.game.spellability.SpellAbility;
import forge.game.spellability.SpellAbilityStackInstance;
import forge.game.spellability.SpellPermanent;
import forge.game.trigger.TriggerType;
import forge.game.zone.ZoneType;
import forge.util.Localizer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;

public class CounterEffect
extends SpellAbilityEffect {
    @Override
    protected String getStackDescription(SpellAbility sa) {
        StringBuilder sb = new StringBuilder();
        sb.append("Counter");
        boolean isAbility = false;
        for (SpellAbility tgtSA : CounterEffect.getTargetSpells(sa)) {
            sb.append(" ");
            sb.append(tgtSA.getHostCard());
            isAbility = tgtSA.isAbility();
            if (!isAbility) continue;
            sb.append("'s ability");
        }
        if (isAbility && sa.hasParam("DestroyPermanent")) {
            sb.append(" and destroy it");
        }
        if (sa.hasParam("UnlessCost")) {
            sb.append(" unless its controller pays {" + sa.getParam("UnlessCost") + "}");
        }
        sb.append(".");
        return sb.toString();
    }

    @Override
    public void resolve(SpellAbility sa) {
        Game game = sa.getActivatingPlayer().getGame();
        EnumMap<AbilityKey, Object> params = AbilityKey.newMap();
        CardZoneTable zoneMovements = AbilityKey.addCardZoneTableParams(params, sa);
        for (SpellAbility tgtSA : CounterEffect.getTargetSpells(sa)) {
            SpellAbilityStackInstance si;
            Card tgtSACard = tgtSA.getHostCard();
            if (sa.hasParam("RememberCounteredCMC")) {
                sa.getHostCard().addRemembered(tgtSACard.getCMC());
            }
            if (sa.hasParam("RememberForCounter")) {
                sa.getHostCard().addRemembered(tgtSACard);
            }
            if (tgtSA.isSpell() && !tgtSA.isCounterableBy(sa) || (si = game.getStack().getInstanceMatchingSpellAbilityID(tgtSA)) == null || sa.hasParam("CounterNoManaSpell") && tgtSA.isSpell() && tgtSA.getTotalManaSpent() != 0 || sa.hasParam("ConditionWouldDestroy") && !CounterEffect.checkForConditionWouldDestroy(sa, tgtSA)) continue;
            if (sa.hasParam("RememberSplicedOntoCounteredSpell") && tgtSA.getSplicedCards() != null) {
                sa.getHostCard().addRemembered(tgtSA.getSplicedCards());
            }
            if (!CounterEffect.removeFromStack(tgtSA, sa, si, params)) continue;
            if (tgtSA.isAbility() && sa.hasParam("DestroyPermanent")) {
                game.getAction().destroy(tgtSACard, sa, true, params);
            }
            if (!sa.hasParam("RememberCountered")) continue;
            sa.getHostCard().addRemembered(tgtSACard);
        }
        zoneMovements.triggerChangesZoneAll(game, sa);
    }

    public static boolean checkForConditionWouldDestroy(SpellAbility sa, SpellAbility tgtSA) {
        ArrayList<SpellAbility> testChain = Lists.newArrayList();
        for (SpellAbility currentTgtSA = tgtSA; currentTgtSA != null; currentTgtSA = currentTgtSA.getSubAbility()) {
            testChain.add(currentTgtSA);
        }
        for (SpellAbility viableTgtSA : testChain) {
            if (!CounterEffect.checkSingleSAForConditionWouldDestroy(sa, viableTgtSA)) continue;
            return true;
        }
        return false;
    }

    private static boolean checkSingleSAForConditionWouldDestroy(SpellAbility sa, SpellAbility tgtSA) {
        Game game = sa.getHostCard().getGame();
        if (tgtSA.getApi() != ApiType.Destroy && tgtSA.getApi() != ApiType.DestroyAll) {
            return false;
        }
        String wouldDestroy = sa.getParam("ConditionWouldDestroy");
        CardCollectionView cardsOTB = game.getCardsIn(ZoneType.Battlefield);
        CardCollection conditionCandidates = CardLists.getValidCards((Iterable<Card>)cardsOTB, wouldDestroy, sa.getActivatingPlayer(), sa.getHostCard(), (CardTraitBase)sa);
        CardCollection affected = new CardCollection();
        if (tgtSA.hasParam("ValidTgts") || tgtSA.hasParam("Defined")) {
            affected.addAll(CounterEffect.getDefinedCardsOrTargeted(tgtSA));
        } else if (tgtSA.hasParam("ValidCards")) {
            affected.addAll(CardLists.getValidCards((Iterable<Card>)cardsOTB, tgtSA.getParam("ValidCards"), tgtSA.getActivatingPlayer(), tgtSA.getHostCard(), (CardTraitBase)tgtSA));
        }
        CardCollection validAffected = new CardCollection();
        for (Card cand : conditionCandidates) {
            if (!affected.contains(cand)) continue;
            validAffected.add(cand);
        }
        boolean isRandomDestruction = false;
        if (validAffected.isEmpty() && tgtSA.getRootAbility().getApi() == ApiType.Pump && tgtSA.getRootAbility().hasParam("TargetMax") && tgtSA.getRootAbility().getSubAbility() != null && tgtSA.getRootAbility().getSubAbility().getApi() == ApiType.ChooseCard && tgtSA.getRootAbility().getSubAbility().hasParam("AtRandom") && "ChosenCard".equals(tgtSA.getParam("Defined"))) {
            isRandomDestruction = true;
            boolean allValid = true;
            affected.addAll(CounterEffect.getDefinedCardsOrTargeted(tgtSA.getRootAbility()));
            for (Object cand : conditionCandidates) {
                if (!affected.contains(cand)) continue;
                validAffected.add(cand);
            }
            CardCollectionView rootTgts = tgtSA.getRootAbility().getTargets().getTargetCards();
            for (Card rootTgt : rootTgts) {
                if (validAffected.contains(rootTgt)) continue;
                allValid = false;
                break;
            }
            if (!allValid) {
                return false;
            }
        }
        if (validAffected.isEmpty()) {
            return false;
        }
        if (tgtSA.hasParam("Sacrifice")) {
            return false;
        }
        boolean willDestroyCondition = false;
        boolean noRegen = tgtSA.hasParam("NoRegen");
        EnumMap<AbilityKey, Object> testParams = AbilityKey.newMap();
        testParams.put(AbilityKey.LastStateBattlefield, game.copyLastStateBattlefield());
        boolean willDestroyAll = true;
        for (Card aff : validAffected) {
            if (tgtSA.usesTargeting() && !aff.canBeTargetedBy(tgtSA)) {
                willDestroyAll = false;
                continue;
            }
            Card toBeDestroyed = new CardCopyService(aff).copyCard(true);
            game.getTriggerHandler().setSuppressAllTriggers(true);
            boolean destroyed = game.getAction().destroy(toBeDestroyed, tgtSA, !noRegen, testParams);
            game.getTriggerHandler().setSuppressAllTriggers(false);
            if (destroyed) {
                willDestroyCondition = true;
                if (isRandomDestruction) continue;
                break;
            }
            willDestroyAll = false;
        }
        return isRandomDestruction ? willDestroyAll : willDestroyCondition;
    }

    private static boolean removeFromStack(SpellAbility tgtSA, SpellAbility srcSA, SpellAbilityStackInstance si, Map<AbilityKey, Object> params) {
        String destination;
        Game game = tgtSA.getActivatingPlayer().getGame();
        Card movedCard = null;
        Card c = tgtSA.getHostCard();
        Map<AbilityKey, Object> repParams = AbilityKey.mapFromAffected(tgtSA.getHostCard());
        repParams.put(AbilityKey.Cause, srcSA);
        repParams.put(AbilityKey.SpellAbility, tgtSA);
        if (game.getReplacementHandler().run(ReplacementType.Counter, repParams) != ReplacementResult.NotReplaced) {
            return false;
        }
        game.getStack().remove(si);
        c.unanimateBestow();
        params.put(AbilityKey.StackSa, tgtSA);
        String string = srcSA.hasParam("Destination") ? srcSA.getParam("Destination") : (destination = tgtSA.isAftermath() ? "Exile" : "Graveyard");
        if (srcSA.hasParam("DestinationChoice")) {
            List<String> pos = Arrays.asList(srcSA.getParam("DestinationChoice").split(","));
            destination = srcSA.getActivatingPlayer().getController().chooseSomeType(Localizer.getInstance().getMessage("lblRemoveDestination", new Object[0]), tgtSA, pos, null);
        }
        if (!tgtSA.isAbility()) {
            if (destination.equals("Graveyard")) {
                movedCard = game.getAction().moveToGraveyard(c, srcSA, params);
            } else if (destination.equals("Exile")) {
                if (!c.canExiledBy(srcSA, true)) {
                    return false;
                }
                movedCard = game.getAction().exile(c, srcSA, params);
            } else if (destination.equals("Hand")) {
                movedCard = game.getAction().moveToHand(c, srcSA, params);
            } else if (destination.equals("Battlefield")) {
                c.setCastSA(null);
                c.setCastFrom(null);
                c.forceTurnFaceUp();
                if (tgtSA instanceof SpellPermanent) {
                    c.setController(srcSA.getActivatingPlayer(), 0L);
                    movedCard = game.getAction().moveToPlay(c, srcSA.getActivatingPlayer(), srcSA, params);
                } else {
                    movedCard = game.getAction().moveToPlay(c, srcSA.getActivatingPlayer(), srcSA, params);
                    movedCard.setController(srcSA.getActivatingPlayer(), 0L);
                }
            } else if (destination.equals("TopOfLibrary")) {
                movedCard = game.getAction().moveToLibrary(c, srcSA, params);
            } else if (destination.equals("BottomOfLibrary")) {
                movedCard = game.getAction().moveToBottomOfLibrary(c, srcSA, params);
            } else if (destination.equals("ShuffleIntoLibrary")) {
                movedCard = game.getAction().moveToBottomOfLibrary(c, srcSA, params);
                c.getController().shuffle(srcSA);
            } else {
                throw new IllegalArgumentException("AbilityFactory_CounterMagic: Invalid Destination argument for card " + srcSA.getHostCard().getName());
            }
        }
        Map<AbilityKey, Object> runParams = AbilityKey.mapFromCard(c);
        runParams.put(AbilityKey.Cause, srcSA);
        runParams.put(AbilityKey.CounteredSA, tgtSA);
        game.getTriggerHandler().runTrigger(TriggerType.Countered, runParams, false);
        if (!tgtSA.isAbility()) {
            game.getGameLog().add(GameLogEntryType.ZONE_CHANGE, "Send countered spell to " + destination);
        }
        return true;
    }
}

