/*
 * Decompiled with CFR 0.152.
 */
package forge.game.ability.effects;

import forge.game.ability.AbilityUtils;
import forge.game.ability.SpellAbilityEffect;
import forge.game.card.Card;
import forge.game.card.CardCollectionView;
import forge.game.player.Player;
import forge.game.player.PlayerCollection;
import forge.game.spellability.SpellAbility;
import forge.game.zone.ZoneType;
import forge.util.Localizer;
import org.apache.commons.lang3.StringUtils;

public class ControlExchangeVariantEffect
extends SpellAbilityEffect {
    @Override
    protected String getStackDescription(SpellAbility sa) {
        return "Exchange cards controlled by " + StringUtils.join(ControlExchangeVariantEffect.getTargetPlayers(sa), ",");
    }

    @Override
    public void resolve(SpellAbility sa) {
        Player activator = sa.getActivatingPlayer();
        PlayerCollection players = ControlExchangeVariantEffect.getTargetPlayers(sa);
        if (players.size() != 2) {
            return;
        }
        Player player1 = (Player)players.get(0);
        Player player2 = (Player)players.get(1);
        ZoneType zone = ZoneType.smartValueOf(sa.getParamOrDefault("Zone", "Battlefield"));
        String type = sa.getParamOrDefault("Type", "Card");
        CardCollectionView list1 = AbilityUtils.filterListByType(player1.getCardsIn(zone), type, sa);
        CardCollectionView list2 = AbilityUtils.filterListByType(player2.getCardsIn(zone), type, sa);
        int max = Math.min(list1.size(), list2.size());
        CardCollectionView chosen1 = activator.getController().chooseCardsForEffect(list1, sa, Localizer.getInstance().getMessage("lblChooseCards", new Object[0]) + ":" + player1, 0, max, true, null);
        int num = chosen1.size();
        CardCollectionView chosen2 = activator.getController().chooseCardsForEffect(list2, sa, Localizer.getInstance().getMessage("lblChooseCards", new Object[0]) + ":" + player2, num, num, true, null);
        for (Card c : chosen1) {
            if (c.canBeControlledBy(player2)) continue;
            return;
        }
        for (Card c : chosen2) {
            if (c.canBeControlledBy(player1)) continue;
            return;
        }
        long tStamp = sa.getActivatingPlayer().getGame().getNextTimestamp();
        for (Card c : chosen1) {
            c.addTempController(player2, tStamp);
        }
        for (Card c : chosen2) {
            c.addTempController(player1, tStamp);
        }
    }
}

