/*
 * Decompiled with CFR 0.152.
 */
package forge.game.ability.effects;

import com.google.common.collect.Maps;
import forge.game.Game;
import forge.game.GameActionUtil;
import forge.game.GameEntityCounterTable;
import forge.game.ability.AbilityKey;
import forge.game.ability.AbilityUtils;
import forge.game.ability.SpellAbilityEffect;
import forge.game.card.Card;
import forge.game.card.CardCollection;
import forge.game.card.CardCollectionView;
import forge.game.card.CardLists;
import forge.game.card.CardPredicates;
import forge.game.card.CardZoneTable;
import forge.game.card.CounterEnumType;
import forge.game.player.Player;
import forge.game.spellability.SpellAbility;
import forge.game.zone.ZoneType;
import forge.util.Lang;
import forge.util.Localizer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;

public class ConniveEffect
extends SpellAbilityEffect {
    @Override
    protected String getStackDescription(SpellAbility sa) {
        CardCollection tgt = ConniveEffect.getTargetCards(sa);
        if (tgt.size() <= 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(Lang.joinHomogenous(tgt)).append(tgt.size() > 1 ? " connive." : " connives.");
        return sb.toString();
    }

    @Override
    public void resolve(SpellAbility sa) {
        Card host = sa.getHostCard();
        Game game = host.getGame();
        int num = AbilityUtils.calculateAmount(host, sa.getParamOrDefault("ConniveNum", "1"), sa);
        CardCollection toConnive = ConniveEffect.getTargetCards(sa);
        if (toConnive.isEmpty()) {
            return;
        }
        ArrayList<Player> controllers = new ArrayList<Player>();
        for (Card c : toConnive) {
            Player controller = c.getController();
            if (controllers.contains(controller)) continue;
            controllers.add(controller);
        }
        int indexAP = controllers.indexOf(game.getPhaseHandler().getPlayerTurn());
        if (indexAP != -1) {
            Collections.rotate(controllers, -indexAP);
        }
        for (Player p : controllers) {
            CardCollection connivers = CardLists.filterControlledBy((Iterable<Card>)toConnive, p);
            while (!connivers.isEmpty()) {
                HashMap<Player, CardCollectionView> discardedMap = Maps.newHashMap();
                EnumMap<AbilityKey, Object> moveParams = AbilityKey.newMap();
                CardZoneTable zoneMovements = AbilityKey.addCardZoneTableParams(moveParams, sa);
                GameEntityCounterTable counterPlacements = new GameEntityCounterTable();
                Card conniver = connivers.size() > 1 ? p.getController().chooseSingleEntityForEffect(connivers, sa, Localizer.getInstance().getMessage("lblChooseConniver", new Object[0]), null) : (Card)connivers.get(false);
                connivers.remove(conniver);
                p.drawCards(num, sa, moveParams);
                CardCollection validDiscards = CardLists.filter((Iterable<Card>)p.getCardsIn(ZoneType.Hand), CardPredicates.Presets.NON_TOKEN);
                if (validDiscards.isEmpty() || !p.canDiscardBy(sa, true)) continue;
                int amt = Math.min(validDiscards.size(), num);
                CardCollectionView toBeDiscarded = amt == 0 ? CardCollection.EMPTY : p.getController().chooseCardsToDiscardFrom(p, sa, validDiscards, amt, amt);
                toBeDiscarded = GameActionUtil.orderCardsByTheirOwners(game, toBeDiscarded, ZoneType.Graveyard, sa);
                int numCntrs = CardLists.getValidCardCount(toBeDiscarded, "Card.nonLand", p, host, sa);
                Card gamec = game.getCardState(conniver);
                if (game.getZoneOf(gamec).is(ZoneType.Battlefield) && gamec.equalsWithGameTimestamp(conniver)) {
                    conniver.addCounter(CounterEnumType.P1P1, numCntrs, p, counterPlacements);
                }
                discardedMap.put(p, CardCollection.getView(toBeDiscarded));
                ConniveEffect.discard(sa, true, discardedMap, moveParams);
                counterPlacements.replaceCounterEffect(game, sa, true);
                zoneMovements.triggerChangesZoneAll(game, sa);
            }
        }
    }
}

