/*
 * Decompiled with CFR 0.152.
 */
package forge.game.ability.effects;

import forge.game.Game;
import forge.game.ability.AbilityKey;
import forge.game.ability.SpellAbilityEffect;
import forge.game.card.Card;
import forge.game.spellability.SpellAbility;
import forge.game.trigger.TriggerType;
import java.util.Map;

public class ClassLevelUpEffect
extends SpellAbilityEffect {
    @Override
    public void resolve(SpellAbility sa) {
        Card host = sa.getHostCard();
        Game game = host.getGame();
        int level = host.getClassLevel() + 1;
        host.setClassLevel(level);
        game.getAction().checkStaticAbilities();
        game.getTriggerHandler().clearActiveTriggers(host, null);
        game.getTriggerHandler().registerActiveTrigger(host, false);
        Map<AbilityKey, Object> runParams = AbilityKey.mapFromCard(host);
        runParams.put(AbilityKey.ClassLevel, level);
        game.getTriggerHandler().runTrigger(TriggerType.ClassLevelGained, runParams, false);
    }
}

