/*
 * Decompiled with CFR 0.152.
 */
package forge.game.ability.effects;

import forge.game.CardTraitBase;
import forge.game.Game;
import forge.game.ability.AbilityUtils;
import forge.game.ability.SpellAbilityEffect;
import forge.game.card.Card;
import forge.game.card.CardCollection;
import forge.game.card.CardCollectionView;
import forge.game.card.CardLists;
import forge.game.player.Player;
import forge.game.player.PlayerCollection;
import forge.game.spellability.SpellAbility;
import forge.game.spellability.SpellAbilityStackInstance;
import forge.game.zone.ZoneType;
import forge.util.Lang;
import forge.util.Localizer;

public class ChooseSourceEffect
extends SpellAbilityEffect {
    @Override
    protected String getStackDescription(SpellAbility sa) {
        StringBuilder sb = new StringBuilder();
        sb.append(Lang.joinHomogenous(ChooseSourceEffect.getTargetPlayers(sa)));
        sb.append("chooses a source.");
        return sb.toString();
    }

    @Override
    public void resolve(SpellAbility sa) {
        Card host = sa.getHostCard();
        Game game = sa.getActivatingPlayer().getGame();
        PlayerCollection tgtPlayers = ChooseSourceEffect.getTargetPlayers(sa);
        CardCollection stackSources = new CardCollection();
        CardCollection referencedSources = new CardCollection();
        CardCollection commandZoneSources = new CardCollection();
        CardCollection sourcesToChooseFrom = new CardCollection();
        CardCollectionView permanentSources = game.getCardsIn(ZoneType.Battlefield);
        for (Card c : game.getCardsIn(ZoneType.Command)) {
            if (c.isFaceDown()) continue;
            commandZoneSources.add(c);
        }
        for (SpellAbilityStackInstance stackinst : game.getStack()) {
            stackSources.add(stackinst.getSourceCard());
            SpellAbility siSpellAbility = stackinst.getSpellAbility();
            for (Object c : siSpellAbility.getTriggeringObjects().values()) {
                if (!(c instanceof Card) || stackSources.contains(c)) continue;
                referencedSources.add((Card)c);
            }
            if (siSpellAbility.getTargetCard() != null) {
                referencedSources.add(siSpellAbility.getTargetCard());
            }
            for (Object c : siSpellAbility.getReplacingObjects().values()) {
                if (!(c instanceof Card) || stackSources.contains(c)) continue;
                referencedSources.add((Card)c);
            }
        }
        if (sa.hasParam("Choices")) {
            permanentSources = CardLists.getValidCards((Iterable<Card>)permanentSources, sa.getParam("Choices"), host.getController(), host, (CardTraitBase)sa);
            stackSources = CardLists.getValidCards((Iterable<Card>)stackSources, sa.getParam("Choices"), host.getController(), host, (CardTraitBase)sa);
            referencedSources = CardLists.getValidCards((Iterable<Card>)referencedSources, sa.getParam("Choices"), host.getController(), host, (CardTraitBase)sa);
            commandZoneSources = CardLists.getValidCards((Iterable<Card>)commandZoneSources, sa.getParam("Choices"), host.getController(), host, (CardTraitBase)sa);
        }
        if (sa.hasParam("TargetControls")) {
            permanentSources = CardLists.filterControlledBy((Iterable<Card>)permanentSources, (Player)tgtPlayers.get(0));
            stackSources = CardLists.filterControlledBy((Iterable<Card>)stackSources, (Player)tgtPlayers.get(0));
            referencedSources = CardLists.filterControlledBy((Iterable<Card>)referencedSources, (Player)tgtPlayers.get(0));
            commandZoneSources = CardLists.filterControlledBy((Iterable<Card>)commandZoneSources, (Player)tgtPlayers.get(0));
        }
        Card divPermanentSources = new Card(-1, game);
        divPermanentSources.setName("--PERMANENTS:--");
        Card divStackSources = new Card(-2, game);
        divStackSources.setName("--SPELLS ON THE STACK:--");
        Card divReferencedSources = new Card(-3, game);
        divReferencedSources.setName("--OBJECTS REFERRED TO ON THE STACK:--");
        Card divCommandZoneSources = new Card(-4, game);
        divCommandZoneSources.setName("--CARDS IN THE COMMAND ZONE:--");
        if (!permanentSources.isEmpty()) {
            sourcesToChooseFrom.add(divPermanentSources);
            sourcesToChooseFrom.addAll(permanentSources);
        }
        if (!stackSources.isEmpty()) {
            sourcesToChooseFrom.add(divStackSources);
            sourcesToChooseFrom.addAll(stackSources);
        }
        if (!referencedSources.isEmpty()) {
            sourcesToChooseFrom.add(divReferencedSources);
            sourcesToChooseFrom.addAll(referencedSources);
        }
        if (!commandZoneSources.isEmpty()) {
            sourcesToChooseFrom.add(divCommandZoneSources);
            sourcesToChooseFrom.addAll(commandZoneSources);
        }
        if (sourcesToChooseFrom.isEmpty()) {
            return;
        }
        int validAmount = AbilityUtils.calculateAmount(host, sa.getParamOrDefault("Amount", "1"), sa);
        for (Player p : tgtPlayers) {
            if (!p.isInGame()) continue;
            CardCollection chosen = new CardCollection();
            for (int i = 0; i < validAmount; ++i) {
                String choiceTitle = sa.hasParam("ChoiceTitle") ? sa.getParam("ChoiceTitle") : Localizer.getInstance().getMessage("lblChooseSource", new Object[0]) + " ";
                Card o = null;
                while ((o = p.getController().chooseSingleEntityForEffect(sourcesToChooseFrom, sa, choiceTitle, null)) == null || o.getName().startsWith("--")) {
                }
                chosen.add(o);
                sourcesToChooseFrom.remove(o);
            }
            host.setChosenCards(chosen);
            if (!sa.hasParam("RememberChosen")) continue;
            host.addRemembered(chosen);
        }
    }
}

