/*
 * Decompiled with CFR 0.152.
 */
package forge.game.ability.effects;

import forge.game.EvenOdd;
import forge.game.ability.SpellAbilityEffect;
import forge.game.card.Card;
import forge.game.player.Player;
import forge.game.player.PlayerController;
import forge.game.spellability.SpellAbility;
import forge.util.Lang;
import forge.util.Localizer;

public class ChooseEvenOddEffect
extends SpellAbilityEffect {
    @Override
    protected String getStackDescription(SpellAbility sa) {
        StringBuilder sb = new StringBuilder();
        sb.append(Lang.joinHomogenous(ChooseEvenOddEffect.getTargetPlayers(sa)));
        sb.append("chooses even or odd.");
        return sb.toString();
    }

    @Override
    public void resolve(SpellAbility sa) {
        Card card = sa.getHostCard();
        for (Player p : ChooseEvenOddEffect.getTargetPlayers(sa)) {
            if (!p.isInGame()) continue;
            EvenOdd chosen = p.getController().chooseBinary(sa, "odd or even", PlayerController.BinaryChoiceType.OddsOrEvens) ? EvenOdd.Odd : EvenOdd.Even;
            card.setChosenEvenOdd(chosen);
            if (!sa.hasParam("Notify")) continue;
            p.getGame().getAction().notifyOfValue(sa, card, Localizer.getInstance().getMessage("lblPlayerPickedChosen", new Object[]{p.getName(), chosen}), p);
        }
        card.updateStateForView();
    }
}

