/*
 * Decompiled with CFR 0.152.
 */
package forge.game.ability.effects;

import com.google.common.collect.Lists;
import forge.game.Direction;
import forge.game.Game;
import forge.game.ability.SpellAbilityEffect;
import forge.game.card.Card;
import forge.game.player.Player;
import forge.game.player.PlayerController;
import forge.game.spellability.SpellAbility;
import forge.util.Localizer;
import forge.util.collect.FCollection;

public class ChooseDirectionEffect
extends SpellAbilityEffect {
    @Override
    public void resolve(SpellAbility sa) {
        Card source = sa.getHostCard();
        Game game = source.getGame();
        FCollection<Player> left = new FCollection<Player>(game.getPlayers());
        String info = Localizer.getInstance().getMessage("lblLeftClockwise", new Object[0]) + ": " + left + "\r\n" + Localizer.getInstance().getMessage("lblRightAntiClockwise", new Object[0]) + ":" + Lists.reverse(left);
        sa.getActivatingPlayer().getController().notifyOfValue(sa, source, info);
        boolean chosen = sa.getActivatingPlayer().getController().chooseBinary(sa, Localizer.getInstance().getMessage("lblChooseDirection", new Object[0]), PlayerController.BinaryChoiceType.LeftOrRight);
        source.setChosenDirection(chosen ? Direction.Left : Direction.Right);
    }
}

