/*
 * Decompiled with CFR 0.152.
 */
package forge.game.ability.effects;

import com.google.common.collect.Lists;
import forge.game.ability.AbilityUtils;
import forge.game.ability.SpellAbilityEffect;
import forge.game.card.Card;
import forge.game.cost.Cost;
import forge.game.player.Player;
import forge.game.player.PlayerCollection;
import forge.game.spellability.AbilitySub;
import forge.game.spellability.SpellAbility;
import forge.util.Aggregates;
import forge.util.CardTranslation;
import forge.util.Lang;
import forge.util.Localizer;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class CharmEffect
extends SpellAbilityEffect {
    public static List<AbilitySub> makePossibleOptions(SpellAbility sa) {
        Card source = sa.getHostCard();
        List<String> restriction = null;
        if (sa.hasParam("ChoiceRestriction")) {
            restriction = source.getChosenModes(sa, sa.getParam("ChoiceRestriction"));
        }
        ArrayList<AbilitySub> choices = Lists.newArrayList(sa.getAdditionalAbilityList("Choices"));
        if (source.getZone() != null) {
            ArrayList<AbilitySub> toRemove = Lists.newArrayList();
            for (AbilitySub ch : choices) {
                if ((!ch.usesTargeting() || ch.getMinTargets() <= 0 || ch.getTargetRestrictions().getNumCandidates(ch, true) != 0) && (restriction == null || !restriction.contains(ch.getDescription()))) continue;
                toRemove.add(ch);
            }
            choices.removeAll(toRemove);
        }
        int indx = 0;
        for (AbilitySub sub : choices) {
            sub.setSVar("CharmOrder", Integer.toString(indx));
            ++indx;
        }
        return choices;
    }

    public static String makeFormatedDescription(SpellAbility sa) {
        return CharmEffect.makeFormatedDescription(sa, true);
    }

    public static String makeFormatedDescription(SpellAbility sa, boolean includeChosen) {
        Card source = sa.getHostCard();
        List<AbilitySub> list = CharmEffect.makePossibleOptions(sa);
        String numParam = sa.getParamOrDefault("CharmNum", "1");
        boolean isX = numParam.equals("X");
        boolean repeat = sa.hasParam("CanRepeatModes");
        int num = 0;
        boolean additionalDesc = sa.hasParam("AdditionalDescription");
        boolean optional = sa.hasParam("Optional");
        if (source.getController() == null && !StringUtils.isNumeric(numParam) && additionalDesc && !optional) {
            num = Integer.MAX_VALUE;
        } else {
            if (sa.getActivatingPlayer() == null) {
                sa.setActivatingPlayer(source.getController(), true);
            }
            if (!isX) {
                num = AbilityUtils.calculateAmount(source, numParam, sa);
                if (!repeat) {
                    num = Math.min(num, list.size());
                }
            }
        }
        int min2 = sa.hasParam("MinCharmNum") ? AbilityUtils.calculateAmount(source, sa.getParam("MinCharmNum"), sa) : num;
        boolean random = sa.hasParam("Random");
        boolean limit = sa.hasParam("ActivationLimit");
        boolean gameLimit = sa.hasParam("GameActivationLimit");
        boolean oppChooses = "Opponent".equals(sa.getParam("Chooser"));
        boolean spree = sa.hasParam("Spree");
        StringBuilder sb = new StringBuilder();
        sb.append(sa.getCostDescription());
        if (!spree) {
            sb.append(oppChooses ? "An opponent chooses " : "Choose ");
            if (isX) {
                sb.append(sa.hasParam("MinCharmNum") && min2 == 0 ? "up to " : "").append("X");
            } else if (num == min2 || num == Integer.MAX_VALUE) {
                sb.append(num == 0 ? "up to that many" : Lang.getNumeral(min2));
            } else if (min2 == 0 && num == sa.getParam("Choices").split(",").length) {
                sb.append("any number ");
            } else if (min2 == 0) {
                sb.append("up to ").append(Lang.getNumeral(num));
            } else {
                sb.append(Lang.getNumeral(min2)).append(" or ").append(list.size() == 2 ? "both" : "more");
            }
        }
        if (sa.hasParam("Pawprint")) {
            sb.append("{P} worth of modes");
        }
        if (sa.hasParam("ChoiceRestriction")) {
            String rest = sa.getParam("ChoiceRestriction");
            if (rest.equals("ThisGame")) {
                sb.append(" that hasn't been chosen");
            } else if (rest.equals("ThisTurn")) {
                sb.append(" that hasn't been chosen this turn");
            } else if (rest.equals("YourLastCombat")) {
                sb.append(" that wasn't chosen during your last combat");
            }
        }
        if (random) {
            sb.append(" at random.");
        }
        if (repeat) {
            sb.append(". You may choose the same mode more than once.");
        }
        if (limit) {
            int limitNum = AbilityUtils.calculateAmount(source, sa.getParam("ActivationLimit"), sa);
            if (limitNum == 1) {
                sb.append(". Activate only once each turn.");
            } else {
                sb.append(". Additional code needed in CharmEffect.");
            }
        }
        if (gameLimit) {
            int limitNum = AbilityUtils.calculateAmount(source, sa.getParam("GameActivationLimit"), sa);
            if (limitNum == 1) {
                sb.append(". Activate only once.");
            } else {
                sb.append(". Additional code needed in CharmEffect.");
            }
        }
        if (additionalDesc) {
            String addDescS = sa.getParam("AdditionalDescription");
            if (optional) {
                sb.append(". ").append(addDescS.trim());
            } else if (addDescS.startsWith(".")) {
                sb.append(addDescS.trim());
            } else if (addDescS.startsWith("where X")) {
                sb.append(", ").append(addDescS.trim()).append(" \u2014");
            } else {
                sb.append(" ").append(addDescS.trim());
            }
        }
        if (!includeChosen) {
            sb.append(num == 1 ? " mode." : " modes.");
        } else if (!list.isEmpty()) {
            if (!spree) {
                if (!(repeat || additionalDesc || limit || gameLimit)) {
                    sb.append(" \u2014");
                }
                sb.append("\r\n");
            }
            for (AbilitySub sub : list) {
                if (spree) {
                    sb.append("+ " + new Cost(sub.getParam("SpreeCost"), false).toSimpleString() + " \u2014 ");
                } else if (sub.hasParam("Pawprint")) {
                    sb.append(StringUtils.repeat("{P}", Integer.parseInt(sub.getParam("Pawprint"))) + " \u2014 ");
                } else {
                    sb.append("\u2022 ");
                }
                sb.append(sub.getParam("SpellDescription"));
                sb.append("\r\n");
            }
            sb.append("\r\n");
        }
        return sb.toString();
    }

    @Override
    public void resolve(SpellAbility sa) {
    }

    @Override
    protected String getStackDescription(SpellAbility sa) {
        return "";
    }

    public static boolean makeChoices(SpellAbility sa) {
        boolean isOptional;
        int min2;
        if (sa.isCopied()) {
            return true;
        }
        sa.setSubAbility(null);
        List<AbilitySub> choices = CharmEffect.makePossibleOptions(sa);
        if (sa.isEntwine()) {
            CharmEffect.chainAbilities(sa, choices);
            return true;
        }
        Card source = sa.getHostCard();
        Player activator = sa.getActivatingPlayer();
        boolean canRepeat = sa.hasParam("CanRepeatModes");
        int num = AbilityUtils.calculateAmount(source, sa.getParamOrDefault("CharmNum", "1"), sa);
        int n = min2 = sa.hasParam("MinCharmNum") ? AbilityUtils.calculateAmount(source, sa.getParam("MinCharmNum"), sa) : num;
        if (!canRepeat) {
            if (min2 > choices.size()) {
                return false;
            }
            num = Math.min(num, choices.size());
        }
        if ((isOptional = sa.hasParam("Optional")) && !activator.getController().confirmAction(sa, null, Localizer.getInstance().getMessage("lblWouldYouLikeCharm", CardTranslation.getTranslatedName(source.getName())), null)) {
            return false;
        }
        if (sa.hasParam("Random")) {
            CharmEffect.chainAbilities(sa, Aggregates.random(choices, num));
            return true;
        }
        Player chooser = sa.getActivatingPlayer();
        if (sa.hasParam("Chooser")) {
            PlayerCollection opponents = activator.getOpponents();
            chooser = activator.getController().chooseSingleEntityForEffect(opponents, sa, "Choose an opponent", null);
            sa.setChoosingPlayer(chooser);
        }
        List<AbilitySub> chosen = chooser.getController().chooseModeForAbility(sa, choices, min2, num, canRepeat);
        CharmEffect.chainAbilities(sa, chosen);
        if (sa.isTrigger()) {
            return chosen != null && !chosen.isEmpty();
        }
        return true;
    }

    public static void chainAbilities(SpellAbility sa, List<AbilitySub> chosen) {
        if (chosen == null) {
            return;
        }
        chosen.sort(Comparator.comparingInt(o -> o.getSVarInt("CharmOrder")));
        for (AbilitySub sub : chosen) {
            AbilitySub clone = (AbilitySub)sub.copy(sa.getActivatingPlayer());
            if (!clone.hasParam("StackDescription")) {
                clone.putParam("StackDescription", "SpellDescription");
            }
            sa.appendSubAbility(clone);
        }
    }
}

