/*
 * Decompiled with CFR 0.152.
 */
package forge.game.ability.effects;

import forge.game.Game;
import forge.game.GameEntity;
import forge.game.ability.AbilityKey;
import forge.game.ability.SpellAbilityEffect;
import forge.game.card.Card;
import forge.game.event.GameEventCombatChanged;
import forge.game.player.Player;
import forge.game.spellability.SpellAbility;
import forge.game.spellability.SpellAbilityStackInstance;
import forge.util.CardTranslation;
import forge.util.Lang;
import forge.util.Localizer;

public class ChangeCombatantsEffect
extends SpellAbilityEffect {
    @Override
    protected String getStackDescription(SpellAbility sa) {
        StringBuilder sb = new StringBuilder();
        sb.append("Reselect the defender of ");
        sb.append(Lang.joinHomogenous(ChangeCombatantsEffect.getTargetCards(sa)));
        return sb.toString();
    }

    @Override
    public void resolve(SpellAbility sa) {
        boolean isCombatChanged = false;
        boolean isOptional = sa.hasParam("Optional");
        Player activator = sa.getActivatingPlayer();
        Game game = activator.getGame();
        for (Card c : ChangeCombatantsEffect.getTargetCards(sa)) {
            String cardString = CardTranslation.getTranslatedName(c.getName()) + " (" + c.getId() + ")";
            if (isOptional && !activator.getController().confirmAction(sa, null, Localizer.getInstance().getMessage("lblChangeCombatantOption", cardString), null)) continue;
            GameEntity originalDefender = game.getCombat().getDefenderByAttacker(c);
            if (!ChangeCombatantsEffect.addToCombat(c, sa, "Attacking", "Blocking")) continue;
            isCombatChanged = true;
            GameEntity defender = game.getCombat().getDefenderByAttacker(c);
            for (SpellAbilityStackInstance si : game.getStack()) {
                if (!si.isTrigger() || !c.equals(si.getSourceCard()) || si.getTriggeringObject(AbilityKey.Attacker) == null) continue;
                si.addTriggeringObject(AbilityKey.OriginalDefender, originalDefender);
                if (defender instanceof Player) {
                    si.updateTriggeringObject(AbilityKey.DefendingPlayer, defender);
                    continue;
                }
                if (!(defender instanceof Card)) continue;
                si.updateTriggeringObject(AbilityKey.DefendingPlayer, ((Card)defender).getController());
            }
        }
        if (isCombatChanged) {
            game.updateCombatForView();
            game.fireEvent(new GameEventCombatChanged());
        }
    }
}

