/*
 * Decompiled with CFR 0.152.
 */
package forge.game.ability.effects;

import com.google.common.collect.Iterables;
import forge.game.ability.AbilityUtils;
import forge.game.ability.SpellAbilityEffect;
import forge.game.card.Card;
import forge.game.player.Player;
import forge.game.player.PlayerActionConfirmMode;
import forge.game.spellability.SpellAbility;
import forge.util.Localizer;
import forge.util.collect.FCollection;

public class BidLifeEffect
extends SpellAbilityEffect {
    @Override
    protected String getStackDescription(SpellAbility sa) {
        return "Bid Life";
    }

    @Override
    public void resolve(SpellAbility sa) {
        String start;
        Card host = sa.getHostCard();
        Player activator = sa.getActivatingPlayer();
        FCollection<Player> bidPlayers = new FCollection<Player>();
        int startBidding = sa.hasParam("StartBidding") ? ("Any".equals(start = sa.getParam("StartBidding")) ? activator.getController().announceRequirements(sa, Localizer.getInstance().getMessage("lblChooseStartingBid", new Object[0])) : AbilityUtils.calculateAmount(host, start, sa)) : 0;
        if (sa.hasParam("OtherBidder")) {
            bidPlayers.add(activator);
            bidPlayers.addAll(AbilityUtils.getDefinedPlayers(host, sa.getParam("OtherBidder"), sa));
        } else {
            bidPlayers.addAll(activator.getGame().getPlayersInTurnOrder());
            int pSize = bidPlayers.size();
            while (bidPlayers.contains(activator) && !activator.equals(Iterables.getFirst(bidPlayers, null))) {
                bidPlayers.add(pSize - 1, (Player)bidPlayers.remove(0));
            }
        }
        boolean willBid = true;
        Player winner = activator;
        int bid = startBidding;
        while (willBid) {
            willBid = false;
            for (Player p : bidPlayers) {
                boolean result = p.getController().confirmBidAction(sa, PlayerActionConfirmMode.BidLife, Localizer.getInstance().getMessage("lblDoYouWantTopBid", new Object[0]) + bid, bid, winner);
                willBid |= result;
                if (!result) continue;
                winner = p;
                host.getGame().getAction().notifyOfValue(sa, p, Localizer.getInstance().getMessage("lblTopBidWithValueLife", String.valueOf(bid += p.getController().chooseNumber(sa, Localizer.getInstance().getMessage("lblBidLife", new Object[0]) + ":", 1, 9))), p);
            }
        }
        host.setChosenNumber(bid);
        host.addRemembered(winner);
        SpellAbility action = sa.getAdditionalAbility("BidSubAbility");
        if (action != null) {
            AbilityUtils.resolve(action);
        }
        host.clearRemembered();
    }
}

