/*
 * Decompiled with CFR 0.152.
 */
package forge.game.ability.effects;

import com.google.common.collect.Lists;
import forge.game.Game;
import forge.game.ability.AbilityKey;
import forge.game.ability.SpellAbilityEffect;
import forge.game.card.Card;
import forge.game.event.GameEventCombatChanged;
import forge.game.spellability.SpellAbility;
import forge.game.trigger.TriggerType;
import forge.util.Lang;
import java.util.ArrayList;
import java.util.EnumMap;

public class BecomesBlockedEffect
extends SpellAbilityEffect {
    @Override
    protected String getStackDescription(SpellAbility sa) {
        StringBuilder sb = new StringBuilder();
        sb.append(Lang.joinHomogenous(BecomesBlockedEffect.getTargetCards(sa)));
        sb.append(" becomes blocked.");
        return sb.toString();
    }

    @Override
    public void resolve(SpellAbility sa) {
        Game game = sa.getActivatingPlayer().getGame();
        ArrayList<Card> blocked = Lists.newArrayList();
        for (Card c : BecomesBlockedEffect.getTargetCards(sa)) {
            game.getCombat().setBlocked(c, true);
            if (c.getDamageHistory().getCreatureGotBlockedThisCombat()) continue;
            blocked.add(c);
            EnumMap<AbilityKey, Object> runParams = AbilityKey.newMap();
            runParams.put(AbilityKey.Attacker, c);
            runParams.put(AbilityKey.Blockers, Lists.newArrayList());
            runParams.put(AbilityKey.Defender, game.getCombat().getDefenderByAttacker(c));
            runParams.put(AbilityKey.DefendingPlayer, game.getCombat().getDefenderPlayerByAttacker(c));
            game.getTriggerHandler().runTrigger(TriggerType.AttackerBlocked, runParams, false);
        }
        if (!blocked.isEmpty()) {
            EnumMap<AbilityKey, Object> runParams = AbilityKey.newMap();
            runParams.put(AbilityKey.Attackers, blocked);
            game.getTriggerHandler().runTrigger(TriggerType.AttackerBlockedOnce, runParams, false);
            game.fireEvent(new GameEventCombatChanged());
        }
    }
}

