/*
 * Decompiled with CFR 0.152.
 */
package forge.game.ability.effects;

import forge.game.ability.SpellAbilityEffect;
import forge.game.player.Player;
import forge.game.player.PlayerCollection;
import forge.game.spellability.SpellAbility;
import forge.util.Lang;

public class BecomeMonarchEffect
extends SpellAbilityEffect {
    @Override
    protected String getStackDescription(SpellAbility sa) {
        StringBuilder sb = new StringBuilder();
        PlayerCollection tgtPlayers = BecomeMonarchEffect.getTargetPlayers(sa);
        sb.append(Lang.joinHomogenous(tgtPlayers)).append(tgtPlayers.size() == 1 ? " becomes" : " become");
        sb.append(" the monarch.");
        return sb.toString();
    }

    @Override
    public void resolve(SpellAbility sa) {
        String set = sa.getHostCard().getSetCode();
        for (Player p : BecomeMonarchEffect.getTargetPlayers(sa)) {
            if (!p.isInGame() || !p.canBecomeMonarch()) continue;
            p.getGame().getAction().becomeMonarch(p, set);
        }
    }
}

