/*
 * Decompiled with CFR 0.152.
 */
package forge.game.ability.effects;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import forge.game.Game;
import forge.game.GameObject;
import forge.game.ability.AbilityUtils;
import forge.game.ability.SpellAbilityEffect;
import forge.game.card.Card;
import forge.game.player.Player;
import forge.game.spellability.SpellAbility;
import forge.util.Localizer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;

public class AssignGroupEffect
extends SpellAbilityEffect {
    @Override
    protected String getStackDescription(SpellAbility sa) {
        return sa.getDescription();
    }

    @Override
    public void resolve(SpellAbility sa) {
        Card host = sa.getHostCard();
        Game game = host.getGame();
        List<GameObject> defined = AssignGroupEffect.getDefinedOrTargeted(sa, "Defined");
        ArrayList<SpellAbility> abilities = Lists.newArrayList(sa.getAdditionalAbilityList("Choices"));
        Player chooser = sa.getActivatingPlayer();
        if (sa.hasParam("Chooser")) {
            String choose = sa.getParam("Chooser");
            chooser = (Player)AbilityUtils.getDefinedPlayers(host, choose, sa).get(false);
        }
        ArrayListMultimap<SpellAbility, GameObject> result = ArrayListMultimap.create();
        for (GameObject g2 : defined) {
            String title = Localizer.getInstance().getMessage("lblChooseAbilityForObject", g2.toString());
            HashMap<String, Object> params = Maps.newHashMap();
            params.put("Affected", g2);
            result.put(chooser.getController().chooseSingleSpellForEffect(abilities, sa, title, params), g2);
        }
        for (SpellAbility s2 : abilities) {
            Collection l = result.get(s2);
            if (l.isEmpty()) continue;
            host.addRemembered(l);
            AbilityUtils.resolve(s2);
            host.removeRemembered(l);
            game.getAction().checkStaticAbilities();
            game.getTriggerHandler().resetActiveTriggers();
        }
    }
}

