/*
 * Decompiled with CFR 0.152.
 */
package forge.game.ability;

import com.google.common.base.Functions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.math.IntMath;
import forge.card.CardStateName;
import forge.card.CardType;
import forge.card.ColorSet;
import forge.card.MagicColor;
import forge.card.mana.ManaAtom;
import forge.card.mana.ManaCost;
import forge.card.mana.ManaCostParser;
import forge.card.mana.ManaCostShard;
import forge.game.CardTraitBase;
import forge.game.Direction;
import forge.game.Game;
import forge.game.GameActionUtil;
import forge.game.GameEntity;
import forge.game.GameObject;
import forge.game.ability.AbilityFactory;
import forge.game.ability.AbilityKey;
import forge.game.ability.ApiType;
import forge.game.card.Card;
import forge.game.card.CardCollection;
import forge.game.card.CardCollectionView;
import forge.game.card.CardFactoryUtil;
import forge.game.card.CardLists;
import forge.game.card.CardPredicates;
import forge.game.card.CardState;
import forge.game.card.CardUtil;
import forge.game.card.CounterType;
import forge.game.cost.Cost;
import forge.game.keyword.Keyword;
import forge.game.keyword.KeywordInterface;
import forge.game.mana.Mana;
import forge.game.mana.ManaConversionMatrix;
import forge.game.mana.ManaCostBeingPaid;
import forge.game.phase.PhaseHandler;
import forge.game.phase.PhaseType;
import forge.game.player.Player;
import forge.game.player.PlayerCollection;
import forge.game.player.PlayerPredicates;
import forge.game.spellability.AbilityManaPart;
import forge.game.spellability.AbilitySub;
import forge.game.spellability.OptionalCost;
import forge.game.spellability.Spell;
import forge.game.spellability.SpellAbility;
import forge.game.spellability.SpellAbilityRestriction;
import forge.game.spellability.SpellAbilityStackInstance;
import forge.game.spellability.SpellPermanent;
import forge.game.spellability.TargetChoices;
import forge.game.trigger.Trigger;
import forge.game.trigger.TriggerType;
import forge.game.zone.ZoneType;
import forge.util.Aggregates;
import forge.util.Expressions;
import forge.util.Localizer;
import forge.util.MyRandom;
import forge.util.TextUtil;
import forge.util.collect.FCollection;
import forge.util.collect.FCollectionView;
import io.sentry.Breadcrumb;
import io.sentry.Sentry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class AbilityUtils {
    private static final ImmutableList<String> cmpList = ImmutableList.of("LT", "LE", "EQ", "GE", "GT", "NE");

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CardCollection getDefinedCards(Card hostCard, String def, CardTraitBase sa) {
        Iterator o;
        Iterator<Object> newCard;
        SpellAbility root;
        String v;
        CardCollection cards = new CardCollection();
        String changedDef = def == null ? "Self" : AbilityUtils.applyAbilityTextChangeEffects(def, sa);
        String[] incR = changedDef.split("\\.", 2);
        sa = AbilityUtils.adjustTriggerContext(incR, sa);
        String defined = incR[0];
        Game game = hostCard.getGame();
        Card c = null;
        Player player = null;
        if (sa instanceof SpellAbility) {
            player = ((SpellAbility)sa).getActivatingPlayer();
        }
        if (player == null) {
            player = hostCard.getController();
        }
        if (defined.contains("AndSelf")) {
            cards.add(hostCard);
            defined = defined.replace("AndSelf", "");
        }
        if (defined.equals("Self")) {
            c = hostCard;
        } else if (defined.equals("CorrectedSelf")) {
            c = game.getCardState(hostCard);
        } else if (defined.equals("OriginalHost")) {
            c = sa instanceof SpellAbility ? ((SpellAbility)sa).getRootAbility().getOriginalHost() : sa.getOriginalHost();
        } else if (defined.equals("EffectSource")) {
            if (hostCard.isImmutable()) {
                c = AbilityUtils.findEffectRoot(hostCard);
            }
        } else if (defined.equals("Equipped")) {
            c = hostCard.getEquipping();
        } else if (defined.startsWith("AttachedTo ")) {
            v = defined.split(" ")[1];
            for (GameEntity gameEntity : AbilityUtils.getDefinedEntities(hostCard, v, sa)) {
                for (Card att : gameEntity.getAttachedCards()) {
                    if (gameEntity instanceof Card && ((Card)gameEntity).isLKI()) {
                        att = game.getCardState(att);
                    }
                    cards.add(att);
                }
            }
        } else if (defined.startsWith("AttachedBy ")) {
            v = defined.split(" ")[1];
            for (Card card : AbilityUtils.getDefinedCards(hostCard, v, sa)) {
                Card attached = card.getAttachedTo();
                if (attached == null) continue;
                cards.add(attached);
            }
        } else if (defined.equals("Enchanted")) {
            CardCollection sacrificed;
            c = hostCard.getEnchantingCard();
            if (c == null && sa instanceof SpellAbility && (sacrificed = (root = ((SpellAbility)sa).getRootAbility()).getPaidList("Sacrificed", true)) != null && !sacrificed.isEmpty()) {
                c = ((Card)sacrificed.getFirst()).getEnchantingCard();
            }
        } else if (defined.equals("TopOfGraveyard")) {
            CardCollectionView grave = player.getCardsIn(ZoneType.Graveyard);
            if (grave.size() <= 0) return cards;
            c = (Card)grave.getLast();
        } else if (defined.endsWith("OfLibrary")) {
            CardCollectionView lib = player.getCardsIn(ZoneType.Library);
            int libSize = lib.size();
            if (libSize <= 0) return cards;
            if (defined.startsWith("TopThird")) {
                int n = defined.contains("RoundedDown") ? (int)Math.floor((double)libSize / 3.0) : (int)Math.ceil((double)libSize / 3.0);
                cards = player.getTopXCardsFromLibrary(n);
            } else if (defined.startsWith("Top_")) {
                String[] stringArray = defined.split("_");
                cards = player.getTopXCardsFromLibrary(AbilityUtils.calculateAmount(hostCard, stringArray[1], sa));
            } else {
                c = (Card)lib.get((defined.startsWith("Top") ? 0 : libSize - 1) != 0);
            }
        } else if ((defined.equals("Targeted") || defined.equals("TargetedCard")) && sa instanceof SpellAbility) {
            for (TargetChoices tc : ((SpellAbility)sa).getAllTargetChoices()) {
                for (Card tgt : tc.getTargetCards()) {
                    cards.add(game.getChangeZoneLKIInfo(tgt));
                }
            }
        } else if (defined.equals("TargetedSource") && sa instanceof SpellAbility) {
            for (TargetChoices tc : ((SpellAbility)sa).getAllTargetChoices()) {
                for (SpellAbility s2 : tc.getTargetSpells()) {
                    cards.add(s2.getHostCard());
                }
            }
        } else if (defined.equals("ThisTargetedCard") && sa instanceof SpellAbility) {
            if (((SpellAbility)sa).getTargets() != null) {
                Iterables.addAll(cards, ((SpellAbility)sa).getTargets().getTargetCards());
            }
        } else if (defined.equals("ParentTarget") && sa instanceof SpellAbility) {
            SpellAbility parent = ((SpellAbility)sa).getParentTargetingCard();
            if (parent != null) {
                Iterables.addAll(cards, parent.getTargets().getTargetCards());
            }
        } else if (defined.startsWith("Triggered") && sa instanceof SpellAbility) {
            root = ((SpellAbility)sa).getRootAbility();
            if (defined.contains("LKICopy")) {
                int lkiPosition = defined.indexOf("LKICopy");
                AbilityKey abilityKey = AbilityKey.fromString(defined.substring(9, lkiPosition));
                Object crd = root.getTriggeringObject(abilityKey);
                if (crd instanceof Card) {
                    c = (Card)crd;
                } else if (crd instanceof Iterable) {
                    cards.addAll(Iterables.filter((Iterable)crd, Card.class));
                }
            } else if (defined.contains("HostCard")) {
                int hcPosition = defined.indexOf("HostCard");
                AbilityKey abilityKey = AbilityKey.fromString(defined.substring(9, hcPosition));
                Object o2 = root.getTriggeringObject(abilityKey);
                if (o2 instanceof SpellAbility) {
                    c = ((SpellAbility)o2).getHostCard();
                }
            } else {
                AbilityKey type = AbilityKey.fromString(defined.substring(9));
                Object object = root.getTriggeringObject(type);
                if (object instanceof Card) {
                    c = game.getCardState((Card)object);
                } else if (object instanceof Iterable) {
                    cards.addAll(Iterables.filter((Iterable)object, Card.class));
                }
            }
        } else if (defined.startsWith("Replaced") && sa instanceof SpellAbility) {
            AbilityKey type;
            root = ((SpellAbility)sa).getRootAbility();
            Object object = root.getReplacingObject(type = AbilityKey.fromString(defined.substring(8)));
            if (object instanceof Card) {
                c = (Card)object;
            } else if (object instanceof Iterable) {
                cards.addAll(Iterables.filter((Iterable)object, Card.class));
            }
        } else if (defined.equals("Remembered") || defined.equals("RememberedCard")) {
            if (!hostCard.hasRemembered()) {
                newCard = game.getCardState(hostCard);
                for (Object object : ((Card)((Object)newCard)).getRemembered()) {
                    if (!(object instanceof Card)) continue;
                    cards.add(game.getCardState((Card)object));
                }
            }
            for (Object o3 : hostCard.getRemembered()) {
                if (!(o3 instanceof Card)) continue;
                cards.addAll(AbilityUtils.addRememberedFromCardState(game, (Card)o3));
            }
        } else if (defined.equals("RememberedLKI")) {
            for (Object o4 : hostCard.getRemembered()) {
                if (!(o4 instanceof Card)) continue;
                cards.add((Card)o4);
            }
        } else if (defined.equals("DirectRemembered")) {
            if (!hostCard.hasRemembered()) {
                newCard = game.getCardState(hostCard);
                for (Object e : ((Card)((Object)newCard)).getRemembered()) {
                    if (!(e instanceof Card)) continue;
                    cards.add((Card)e);
                }
            }
            for (Object o4 : hostCard.getRemembered()) {
                if (!(o4 instanceof Card)) continue;
                cards.add((Card)o4);
            }
        } else if (defined.equals("DelayTriggerRememberedLKI") && sa instanceof SpellAbility) {
            root = ((SpellAbility)sa).getRootAbility();
            if (root != null) {
                for (Object object : root.getTriggerRemembered()) {
                    if (!(object instanceof Card)) continue;
                    cards.add((Card)object);
                }
            } else {
                System.err.println("Warning: couldn't find trigger SA in the chain of SpellAbility " + sa);
            }
        } else if (defined.equals("DelayTriggerRemembered") && sa instanceof SpellAbility) {
            root = ((SpellAbility)sa).getRootAbility();
            if (root != null) {
                for (Object object : root.getTriggerRemembered()) {
                    if (!(object instanceof Card)) continue;
                    cards.addAll(AbilityUtils.addRememberedFromCardState(game, (Card)object));
                }
            } else {
                System.err.println("Warning: couldn't find trigger SA in the chain of SpellAbility " + sa);
            }
        } else if (defined.equals("RememberedFirst")) {
            o = hostCard.getFirstRemembered();
            if (o instanceof Card) {
                cards.add(game.getCardState((Card)((Object)o)));
            }
        } else if (defined.equals("RememberedLast")) {
            o = Iterables.getLast(hostCard.getRemembered(), null);
            if (o instanceof Card) {
                cards.add(game.getCardState((Card)((Object)o)));
            }
        } else if (defined.equals("ImprintedLKI")) {
            for (Card imprint : hostCard.getImprintedCards()) {
                cards.add(imprint);
            }
        } else if (defined.equals("Imprinted")) {
            for (Card imprint : hostCard.getImprintedCards()) {
                cards.add(game.getCardState(imprint));
            }
        } else if (defined.startsWith("ThisTurnEntered")) {
            void var12_51;
            Object validFilter;
            String[] workingCopy = defined.split("_");
            ZoneType destination = ZoneType.smartValueOf(workingCopy[1]);
            if (((String)workingCopy[2]).equals("from")) {
                ZoneType zoneType = ZoneType.smartValueOf((String)workingCopy[3]);
                validFilter = workingCopy[4];
            } else {
                Object var12_50 = null;
                validFilter = workingCopy[2];
            }
            for (Card cl : CardUtil.getThisTurnEntered(destination, (ZoneType)var12_51, (String)validFilter, hostCard, sa, player)) {
                Card gameState = game.getCardState(cl, null);
                if (gameState == null || !gameState.equalsWithGameTimestamp(cl)) continue;
                cards.add(gameState);
            }
        } else if (defined.equals("ChosenCard")) {
            for (Card chosen : hostCard.getChosenCards()) {
                cards.add(game.getCardState(chosen));
            }
        } else if (defined.startsWith("CardUID_")) {
            String idString = defined.substring(8);
            for (Card card : game.getCardsInGame()) {
                if (card.getId() != Integer.parseInt(idString)) continue;
                cards.add(game.getCardState(card));
            }
        } else {
            if (defined.startsWith("Valid")) {
                String validDefined;
                CardCollectionView candidates;
                if (defined.startsWith("Valid ")) {
                    candidates = game.getCardsIn(ZoneType.Battlefield);
                    validDefined = changedDef.substring("Valid ".length());
                } else if (defined.startsWith("ValidAll ")) {
                    candidates = game.getCardsInGame();
                    validDefined = changedDef.substring("ValidAll ".length());
                } else {
                    String[] stringArray = changedDef.split(" ", 2);
                    String zone = stringArray[0].substring("Valid".length());
                    candidates = game.getCardsIn(ZoneType.smartValueOf(zone));
                    validDefined = stringArray[1];
                }
                cards.addAll(CardLists.getValidCards((Iterable<Card>)candidates, validDefined, player, hostCard, sa));
                return cards;
            }
            if (defined.startsWith("ExiledWith")) {
                cards.addAll(hostCard.getExiledCards());
            } else if (defined.equals("Convoked")) {
                cards.addAll(hostCard.getConvoked());
            } else {
                CardCollection list = AbilityUtils.getPaidCards(sa, incR[0]);
                if (list != null) {
                    cards.addAll(list);
                }
            }
        }
        if (c != null) {
            cards.add(c);
        }
        if (incR.length <= 1) return cards;
        if (cards.isEmpty()) return cards;
        String[] valids = incR[1].split(",");
        int i = 0;
        while (i < valids.length) {
            valids[i] = "Card." + valids[i];
            ++i;
        }
        return CardLists.getValidCards((Iterable<Card>)cards, valids, player, hostCard, sa);
    }

    private static CardCollection addRememberedFromCardState(Game game, Card c) {
        CardCollection coll = new CardCollection();
        Card newState = game.getCardState(c);
        if (c.getMeldedWith() != null) {
            coll.add(game.getCardState(c.getMeldedWith()));
        }
        coll.add(newState);
        return coll;
    }

    private static Card findEffectRoot(Card startCard) {
        Card cc = startCard.getEffectSource();
        if (cc != null) {
            if (cc.isImmutable()) {
                return AbilityUtils.findEffectRoot(cc);
            }
            return cc;
        }
        return null;
    }

    public static int calculateAmount(Card card, String amount, CardTraitBase ability) {
        return AbilityUtils.calculateAmount(card, amount, ability, false);
    }

    public static int calculateAmount(Card card, String amount, CardTraitBase ability, boolean maxto) {
        int multiplier;
        boolean startsWithMinus;
        if (StringUtils.isBlank(amount)) {
            return 0;
        }
        if (card == null) {
            return 0;
        }
        Player player = null;
        if (ability instanceof SpellAbility) {
            player = ((SpellAbility)ability).getActivatingPlayer();
        }
        if (player == null) {
            player = card.getController();
        }
        Game game = card.getGame();
        boolean startsWithPlus = amount.charAt(0) == '+';
        boolean bl = startsWithMinus = amount.charAt(0) == '-';
        if (startsWithPlus || startsWithMinus) {
            amount = amount.substring(1);
        }
        int n = multiplier = startsWithMinus ? -1 : 1;
        if (StringUtils.isNumeric(amount)) {
            int val = Integer.parseInt(amount);
            if (maxto) {
                val = Math.max(val, 0);
            }
            return val * multiplier;
        }
        String svarval = null;
        if (amount.indexOf(36) > 0) {
            svarval = amount;
        } else if (ability != null) {
            svarval = ability.getSVar(amount);
        }
        if (StringUtils.isBlank(svarval)) {
            if (ability != null && ability instanceof SpellAbility && !(ability instanceof SpellPermanent)) {
                System.err.printf("SVar '%s' not found in ability, fallback to Card (%s). Ability is (%s)%n", amount, card.getName(), ability);
            }
            svarval = card.getSVar(amount);
        }
        if (StringUtils.isBlank(svarval)) {
            if (amount.startsWith("Cost")) {
                return 0;
            }
            System.err.printf("SVar '%s' not defined in Card (%s)%n", amount, card.getName());
            return 0;
        }
        if (StringUtils.isNumeric(svarval)) {
            int val = Integer.parseInt(svarval);
            if (maxto) {
                val = Math.max(val, 0);
            }
            return val * multiplier;
        }
        String[] calcX = svarval.split("\\$", 2);
        if (calcX.length == 1 || calcX[1].equals("none")) {
            return 0;
        }
        calcX[1] = AbilityUtils.applyAbilityTextChangeEffects(calcX[1], ability);
        ability = AbilityUtils.adjustTriggerContext(calcX, ability);
        Integer val = null;
        if (calcX[0].startsWith("Count")) {
            val = AbilityUtils.xCount(card, calcX[1], ability);
        } else if (calcX[0].startsWith("Number")) {
            val = AbilityUtils.xCount(card, svarval, ability);
        } else if (calcX[0].startsWith("SVar")) {
            String[] l = calcX[1].split("/");
            String m4 = CardFactoryUtil.extractOperators(calcX[1]);
            val = AbilityUtils.doXMath(AbilityUtils.calculateAmount(card, l[0], ability), m4, card, ability);
        } else if (calcX[0].startsWith("PlayerCount")) {
            String hType = calcX[0].substring(11);
            FCollection<Player> players = new FCollection<Player>();
            if (hType.equals("Players") || hType.isEmpty()) {
                players.addAll(game.getPlayers());
                val = AbilityUtils.playerXCount(players, calcX[1], card, ability);
            } else if (hType.equals("YourTeam")) {
                players.addAll(player.getYourTeam());
                val = AbilityUtils.playerXCount(players, calcX[1], card, ability);
            } else if (hType.equals("Opponents")) {
                players.addAll(player.getOpponents());
                val = AbilityUtils.playerXCount(players, calcX[1], card, ability);
            } else if (hType.equals("RegisteredOpponents")) {
                players.addAll(Iterables.filter(game.getRegisteredPlayers(), PlayerPredicates.isOpponentOf(player)));
                val = AbilityUtils.playerXCount(players, calcX[1], card, ability);
            } else if (hType.equals("Other")) {
                players.addAll(player.getAllOtherPlayers());
                val = AbilityUtils.playerXCount(players, calcX[1], card, ability);
            } else if (hType.startsWith("Remembered")) {
                AbilityUtils.addPlayer(card.getRemembered(), hType, players);
                val = AbilityUtils.playerXCount(players, calcX[1], card, ability);
            } else if (hType.equals("NonActive")) {
                players.addAll(game.getPlayers());
                players.remove(game.getPhaseHandler().getPlayerTurn());
                val = AbilityUtils.playerXCount(players, calcX[1], card, ability);
            } else if (hType.equals("HasLost")) {
                players.addAll(game.getLostPlayers());
                val = AbilityUtils.playerXCount(players, calcX[1], card, ability);
            } else if (hType.startsWith("PropertyYou")) {
                players.add(player);
                val = AbilityUtils.playerXCount(players, calcX[1], card, ability);
            } else if (hType.startsWith("Property")) {
                String defined = hType.split("Property")[1];
                for (Player p : game.getPlayersInTurnOrder()) {
                    if (!p.hasProperty(defined, player, ability.getHostCard(), ability)) continue;
                    players.add(p);
                }
                val = AbilityUtils.playerXCount(players, calcX[1], card, ability);
            } else if (hType.startsWith("Defined")) {
                String defined = hType.split("Defined")[1];
                val = AbilityUtils.playerXCount(AbilityUtils.getDefinedPlayers(card, defined, ability), calcX[1], card, ability);
            } else {
                val = 0;
            }
        } else if (calcX[0].equals("OriginalHost")) {
            val = AbilityUtils.xCount(ability.getOriginalHost(), calcX[1], ability);
        } else if (calcX[0].startsWith("ExiledWith")) {
            val = AbilityUtils.handlePaid(card.getExiledCards(), calcX[1], card, ability);
        } else if (calcX[0].startsWith("Convoked")) {
            val = AbilityUtils.handlePaid(card.getConvoked(), calcX[1], card, ability);
        } else if (calcX[0].startsWith("Emerged")) {
            val = AbilityUtils.handlePaid(card.getEmerged(), calcX[1], card, ability);
        } else if (calcX[0].startsWith("Remembered")) {
            CardCollection list = new CardCollection();
            Card newCard = card;
            if (!card.hasRemembered()) {
                newCard = game.getCardState(card);
            }
            if (calcX[0].endsWith("LKI")) {
                for (Object o : newCard.getRemembered()) {
                    if (!(o instanceof Card)) continue;
                    list.add((Card)o);
                }
            } else {
                for (Object o : newCard.getRemembered()) {
                    if (!(o instanceof Card)) continue;
                    list.add(game.getCardState((Card)o));
                }
            }
            val = AbilityUtils.handlePaid(list, calcX[1], card, ability);
        } else if (calcX[0].startsWith("Imprinted")) {
            CardCollection list = new CardCollection();
            Card newCard = card;
            if (card.getImprintedCards().isEmpty()) {
                newCard = game.getCardState(card);
            }
            if (calcX[0].endsWith("LKI")) {
                list.addAll(newCard.getImprintedCards());
            } else {
                for (Card c : newCard.getImprintedCards()) {
                    list.add(game.getCardState(c));
                }
            }
            val = AbilityUtils.handlePaid(list, calcX[1], card, ability);
        } else if (calcX[0].matches("Enchanted") || calcX[0].matches("Equipped")) {
            GameEntity o;
            CardCollection list = new CardCollection();
            if (card.isEnchanting() && (o = card.getEntityAttachedTo()) instanceof Card) {
                list.add(game.getCardState((Card)o));
            }
            val = AbilityUtils.handlePaid(list, calcX[1], card, ability);
        } else if (ability instanceof SpellAbility) {
            SpellAbility sa = (SpellAbility)ability;
            if (calcX[0].startsWith("TargetedPlayer")) {
                ArrayList<Player> players = new ArrayList<Player>();
                SpellAbility saTargeting = sa.getSATargetingPlayer();
                if (null != saTargeting) {
                    Iterables.addAll(players, saTargeting.getTargets().getTargetPlayers());
                }
                val = AbilityUtils.playerXCount(players, calcX[1], card, ability);
            } else if (calcX[0].startsWith("ThisTargetedPlayer")) {
                ArrayList<Player> players = new ArrayList<Player>();
                Iterables.addAll(players, sa.getTargets().getTargetPlayers());
                val = AbilityUtils.playerXCount(players, calcX[1], card, ability);
            } else if (calcX[0].startsWith("TargetedObjects")) {
                ArrayList objects = new ArrayList();
                for (SpellAbility loopSA = sa.getRootAbility(); loopSA != null; loopSA = loopSA.getSubAbility()) {
                    if (!loopSA.usesTargeting()) continue;
                    Iterables.addAll(objects, loopSA.getTargets());
                }
                if (calcX[0].endsWith("Distinct")) {
                    objects = new ArrayList(new HashSet(objects));
                }
                val = AbilityUtils.objectXCount(objects, calcX[1], card, ability);
            } else if (calcX[0].startsWith("TargetedController")) {
                PlayerCollection players = new PlayerCollection();
                CardCollection list = AbilityUtils.getDefinedCards(card, "Targeted", sa);
                FCollection<SpellAbility> sas = AbilityUtils.getDefinedSpellAbilities(card, "Targeted", sa);
                for (Card c : list) {
                    players.add(c.getController());
                }
                for (SpellAbility s2 : sas) {
                    players.add(s2.getHostCard().getController());
                }
                val = AbilityUtils.playerXCount(players, calcX[1], card, ability);
            } else if (calcX[0].startsWith("TargetedByTarget")) {
                CardCollection tgtList = new CardCollection();
                FCollection<SpellAbility> saList = AbilityUtils.getDefinedSpellAbilities(card, "Targeted", sa);
                for (SpellAbility s3 : saList) {
                    tgtList.addAll(AbilityUtils.getDefinedCards(s3.getHostCard(), "Targeted", s3));
                }
                val = AbilityUtils.handlePaid(tgtList, calcX[1], card, ability);
            } else if (calcX[0].startsWith("TriggeredPlayers") || calcX[0].equals("TriggeredCardController")) {
                String key = calcX[0];
                if (calcX[0].startsWith("TriggeredPlayers")) {
                    key = "Triggered" + key.substring(16);
                }
                val = AbilityUtils.playerXCount(AbilityUtils.getDefinedPlayers(card, key, sa), calcX[1], card, ability);
            } else if (calcX[0].startsWith("TriggeredPlayer") || calcX[0].startsWith("TriggeredTarget") || calcX[0].startsWith("TriggeredDefendingPlayer")) {
                SpellAbility root = sa.getRootAbility();
                Object o = root.getTriggeringObject(AbilityKey.fromString(calcX[0].substring(9)));
                val = o instanceof Player ? AbilityUtils.playerXProperty((Player)o, calcX[1], card, ability) : 0;
            } else if (calcX[0].equals("TriggeredSpellAbility") || calcX[0].equals("TriggeredStackInstance") || calcX[0].equals("SpellTargeted")) {
                SpellAbility sat = Iterables.getFirst(AbilityUtils.getDefinedSpellAbilities(card, calcX[0], sa), null);
                val = sat == null ? 0 : AbilityUtils.xCount(sat.getHostCard(), calcX[1], sat);
            } else if (calcX[0].startsWith("TriggerCount")) {
                SpellAbility root = sa.getRootAbility();
                String[] l = calcX[1].split("/");
                String m5 = CardFactoryUtil.extractOperators(calcX[1]);
                Object to = root.getTriggeringObject(AbilityKey.fromString(l[0]));
                Integer count = null;
                if (to instanceof Iterable) {
                    Iterable numbers = (Iterable)to;
                    count = calcX[0].endsWith("Max") ? Aggregates.max(numbers, Functions.identity()) : Integer.valueOf(Aggregates.sum(numbers, Functions.identity()));
                } else {
                    count = (Integer)to;
                }
                val = AbilityUtils.doXMath(ObjectUtils.firstNonNull(count, 0), m5, card, ability);
            } else if (calcX[0].startsWith("ReplaceCount")) {
                SpellAbility root = sa.getRootAbility();
                String[] l = calcX[1].split("/");
                String m6 = CardFactoryUtil.extractOperators(calcX[1]);
                Integer count = (Integer)root.getReplacingObject(AbilityKey.fromString(l[0]));
                val = AbilityUtils.doXMath(ObjectUtils.firstNonNull(count, 0), m6, card, ability);
            } else {
                Iterable<Card> list = null;
                if (calcX[0].startsWith("Targeted")) {
                    list = sa.findTargetedCards();
                } else if (calcX[0].startsWith("AllTargeted")) {
                    CardCollection all = new CardCollection();
                    for (SpellAbility loopSA = sa.getRootAbility(); loopSA != null; loopSA = loopSA.getSubAbility()) {
                        if (!loopSA.usesTargeting()) continue;
                        all.addAll(loopSA.findTargetedCards());
                    }
                    list = all;
                } else if (calcX[0].startsWith("ParentTargeted")) {
                    SpellAbility parent = sa.getParentTargetingCard();
                    if (parent != null) {
                        list = parent.findTargetedCards();
                    }
                } else if (calcX[0].startsWith("TriggerRemembered")) {
                    SpellAbility root = sa.getRootAbility();
                    list = Iterables.filter(root.getTriggerRemembered(), Card.class);
                } else if (calcX[0].startsWith("TriggerObjects")) {
                    SpellAbility root = sa.getRootAbility();
                    list = Iterables.filter((Iterable)root.getTriggeringObjects().getOrDefault((Object)AbilityKey.fromString(calcX[0].substring(14)), new CardCollection()), Card.class);
                } else if (calcX[0].startsWith("Triggered") || calcX[0].startsWith("CardTriggered")) {
                    SpellAbility root = sa.getRootAbility();
                    int s4 = calcX[0].startsWith("Triggered") ? 9 : 13;
                    list = new CardCollection((Card)root.getTriggeringObject(AbilityKey.fromString(calcX[0].substring(s4))));
                } else if (calcX[0].startsWith("Replaced")) {
                    SpellAbility root = sa.getRootAbility();
                    list = new CardCollection((Card)root.getReplacingObject(AbilityKey.fromString(calcX[0].substring(8))));
                } else {
                    list = AbilityUtils.getPaidCards(sa, calcX[0]);
                }
                if (list != null) {
                    list = Iterables.filter(list, Card.class);
                    val = AbilityUtils.handlePaid(list, calcX[1], card, ability);
                }
            }
        }
        if (val != null) {
            if (maxto) {
                val = Math.max(val, 0);
            }
            return val * multiplier;
        }
        return 0;
    }

    public static FCollection<GameObject> getDefinedObjects(Card card, String def, CardTraitBase sa) {
        FCollection<GameObject> objects = new FCollection<GameObject>();
        String defined = def == null ? "Self" : def;
        objects.addAll(AbilityUtils.getDefinedPlayers(card, defined, sa));
        objects.addAll(AbilityUtils.getDefinedCards(card, defined, sa));
        objects.addAll((Collection<GameObject>)AbilityUtils.getDefinedSpellAbilities(card, defined, sa));
        return objects;
    }

    public static FCollection<GameEntity> getDefinedEntities(Card card, String def, CardTraitBase sa) {
        FCollection<GameEntity> objects = new FCollection<GameEntity>();
        String defined = def == null ? "Self" : def;
        objects.addAll(AbilityUtils.getDefinedPlayers(card, defined, sa));
        objects.addAll(AbilityUtils.getDefinedCards(card, defined, sa));
        return objects;
    }

    public static List<GameEntity> getDefinedEntities(Card card, String[] def, CardTraitBase sa) {
        ArrayList<GameEntity> objects = new ArrayList<GameEntity>();
        for (String d : def) {
            objects.addAll(AbilityUtils.getDefinedEntities(card, d, sa));
        }
        return objects;
    }

    public static CardCollectionView filterListByType(CardCollectionView list, String type, SpellAbility sa) {
        if (type == null) {
            return list;
        }
        Card source = sa.getHostCard();
        if (type.startsWith("Triggered")) {
            Object o = type.contains("Card") ? sa.getTriggeringObject(AbilityKey.Card) : (type.contains("Object") ? sa.getTriggeringObject(AbilityKey.Object) : (type.contains("Attacker") ? sa.getTriggeringObject(AbilityKey.Attacker) : (type.contains("Blocker") ? sa.getTriggeringObject(AbilityKey.Blocker) : sa.getTriggeringObject(AbilityKey.Card))));
            if (!(o instanceof Card)) {
                return new CardCollection();
            }
            if (type.equals("Triggered") || type.equals("TriggeredCard") || type.equals("TriggeredObject") || type.equals("TriggeredAttacker") || type.equals("TriggeredBlocker")) {
                type = "Card.Self";
            }
            source = (Card)o;
            type = type.contains("TriggeredCard") ? TextUtil.fastReplace(type, "TriggeredCard", "Card") : (type.contains("TriggeredObject") ? TextUtil.fastReplace(type, "TriggeredObject", "Card") : (type.contains("TriggeredAttacker") ? TextUtil.fastReplace(type, "TriggeredAttacker", "Card") : (type.contains("TriggeredBlocker") ? TextUtil.fastReplace(type, "TriggeredBlocker", "Card") : TextUtil.fastReplace(type, "Triggered", "Card"))));
        } else if (type.startsWith("Targeted")) {
            source = null;
            CardCollectionView tgts = sa.findTargetedCards();
            if (!tgts.isEmpty()) {
                source = (Card)tgts.get(false);
            }
            if (source == null) {
                return new CardCollection();
            }
            type = type.startsWith("TargetedCard") ? TextUtil.fastReplace(type, "TargetedCard", "Card") : TextUtil.fastReplace(type, "Targeted", "Card");
        } else if (type.startsWith("Remembered")) {
            boolean hasRememberedCard = false;
            for (Object object : source.getRemembered()) {
                if (!(object instanceof Card)) continue;
                hasRememberedCard = true;
                source = (Card)object;
                type = TextUtil.fastReplace(type, "Remembered", "Card");
                break;
            }
            if (!hasRememberedCard) {
                return new CardCollection();
            }
        } else if (type.startsWith("Imprinted")) {
            type = TextUtil.fastReplace(type, "Imprinted", "Card");
        } else if (type.equals("Card.AttachedBy")) {
            source = source.getEnchantingCard();
            type = TextUtil.fastReplace(type, "Card.AttachedBy", "Card.Self");
        }
        String valid = type;
        for (String t2 : cmpList) {
            String varName;
            char reference;
            int index = valid.indexOf(t2);
            if (index < 0 || !Character.isLetter(reference = valid.charAt(index + 2)) || sa.getSVar(varName = valid.substring(index).split(",")[0].split(t2)[1].split("\\+")[0]).isEmpty() && !source.hasSVar(varName)) continue;
            valid = TextUtil.fastReplace(valid, TextUtil.concatNoSpace(t2, varName), TextUtil.concatNoSpace(t2, Integer.toString(AbilityUtils.calculateAmount(source, varName, sa))));
        }
        if (sa.hasParam("AbilityCount")) {
            String var = sa.getParam("AbilityCount");
            valid = TextUtil.fastReplace(valid, var, Integer.toString(AbilityUtils.calculateAmount(source, var, sa)));
        }
        return CardLists.getValidCards((Iterable<Card>)list, valid, sa.getActivatingPlayer(), source, (CardTraitBase)sa);
    }

    /*
     * WARNING - void declaration
     */
    public static PlayerCollection getDefinedPlayers(Card card, String def, CardTraitBase sa) {
        PlayerCollection players = new PlayerCollection();
        Player player = sa instanceof SpellAbility ? ((SpellAbility)sa).getActivatingPlayer() : card.getController();
        Game game = card == null ? null : card.getGame();
        String changedDef = def == null ? "You" : AbilityUtils.applyAbilityTextChangeEffects(def, sa);
        String[] incR = changedDef.split("\\.", 2);
        sa = AbilityUtils.adjustTriggerContext(incR, sa);
        String defined = incR[0];
        if (!(defined.equals("Self") || defined.equals("TargetedCard") || defined.equals("ThisTargetedCard") || defined.equals("Convoked") || defined.startsWith("Valid") || AbilityUtils.getPaidCards(sa, incR[0]) != null || defined.equals("TargetedSource") || defined.startsWith("CardUID_"))) {
            if (defined.equals("TargetedOrController")) {
                players.addAll(AbilityUtils.getDefinedPlayers(card, "Targeted", sa));
                players.addAll(AbilityUtils.getDefinedPlayers(card, "TargetedController", sa));
            } else if ((defined.equals("Targeted") || defined.equals("TargetedPlayer")) && sa instanceof SpellAbility) {
                for (TargetChoices targetChoices : ((SpellAbility)sa).getAllTargetChoices()) {
                    players.addAll(targetChoices.getTargetPlayers());
                }
            } else if (defined.startsWith("PlayerUID_")) {
                int id = Integer.parseInt(defined.split("PlayerUID_")[1]);
                for (Player p : game.getRegisteredPlayers()) {
                    if (p.getId() != id) continue;
                    players.add(p);
                }
            } else if (defined.equals("ParentTarget") && sa instanceof SpellAbility) {
                SpellAbility parent = ((SpellAbility)sa).getParentTargetingPlayer();
                if (parent != null) {
                    players.addAll(parent.getTargets().getTargetPlayers());
                }
            } else if (defined.equals("ThisTargetedPlayer") && sa instanceof SpellAbility) {
                if (((SpellAbility)sa).getTargets() != null) {
                    Iterables.addAll(players, ((SpellAbility)sa).getTargets().getTargetPlayers());
                }
            } else if (defined.equals("TargetedController")) {
                for (Card card2 : AbilityUtils.getDefinedCards(card, "Targeted", sa)) {
                    players.add(card2.getController());
                }
                for (SpellAbility spellAbility : AbilityUtils.getDefinedSpellAbilities(card, "Targeted", sa)) {
                    players.add(spellAbility.getActivatingPlayer());
                }
            } else if (defined.equals("TargetedOwner")) {
                for (Card card3 : AbilityUtils.getDefinedCards(card, "Targeted", sa)) {
                    players.add(card3.getOwner());
                }
            } else if (defined.equals("TargetedAndYou") && sa instanceof SpellAbility) {
                SpellAbility saTargeting = ((SpellAbility)sa).getSATargetingPlayer();
                if (saTargeting != null) {
                    players.addAll(saTargeting.getTargets().getTargetPlayers());
                    players.add(((SpellAbility)sa).getActivatingPlayer());
                }
            } else if (defined.equals("ThisTargetedController")) {
                for (Card card4 : AbilityUtils.getDefinedCards(card, "ThisTargetedCard", sa)) {
                    players.add(card4.getController());
                }
                for (SpellAbility spellAbility : AbilityUtils.getDefinedSpellAbilities(card, "ThisTargeted", sa)) {
                    players.add(spellAbility.getActivatingPlayer());
                }
            } else if (defined.equals("ThisTargetedOwner")) {
                for (Card card5 : AbilityUtils.getDefinedCards(card, "ThisTargetedCard", sa)) {
                    players.add(card5.getOwner());
                }
            } else if (defined.equals("ParentTargetedController")) {
                for (Card card6 : AbilityUtils.getDefinedCards(card, "ParentTarget", sa)) {
                    players.add(card6.getController());
                }
                for (SpellAbility spellAbility : AbilityUtils.getDefinedSpellAbilities(card, "Targeted", sa)) {
                    players.add(spellAbility.getActivatingPlayer());
                }
            } else if (defined.startsWith("Remembered")) {
                AbilityUtils.addPlayer(card.getRemembered(), defined, players);
            } else if (defined.startsWith("Imprinted")) {
                AbilityUtils.addPlayer(card.getImprintedCards(), defined, players);
            } else if (defined.startsWith("EffectSource")) {
                Card root = AbilityUtils.findEffectRoot(card);
                if (root != null) {
                    AbilityUtils.addPlayer(Lists.newArrayList(root), defined, players);
                }
            } else if (defined.startsWith("OriginalHost")) {
                Card originalHost = sa.getOriginalHost();
                if (originalHost != null) {
                    AbilityUtils.addPlayer(Lists.newArrayList(originalHost), defined, players);
                }
            } else if (defined.startsWith("DelayTriggerRemembered") && sa instanceof SpellAbility) {
                SpellAbility root = ((SpellAbility)sa).getRootAbility();
                if (root != null) {
                    AbilityUtils.addPlayer(root.getTriggerRemembered(), defined, players);
                } else {
                    System.err.println("Warning: couldn't find trigger SA in the chain of SpellAbility " + sa);
                }
            } else if (defined.startsWith("Triggered") && sa instanceof SpellAbility) {
                Object c;
                String defParsed;
                String string = defParsed = defined.endsWith("AndYou") ? defined.substring(0, defined.indexOf("AndYou")) : defined;
                if (defined.endsWith("AndYou")) {
                    players.add(((SpellAbility)sa).getActivatingPlayer());
                }
                SpellAbility spellAbility = ((SpellAbility)sa).getRootAbility();
                Object o = null;
                if (defParsed.endsWith("Controller")) {
                    boolean orCont = defParsed.endsWith("OrController") || defParsed.endsWith("OriginalController");
                    String triggeringType = defParsed.substring(9);
                    if (!triggeringType.equals("OriginalController")) {
                        triggeringType = triggeringType.substring(0, triggeringType.length() - (orCont ? 12 : 10));
                    }
                    Object c2 = spellAbility.getTriggeringObject(AbilityKey.fromString(triggeringType));
                    if (orCont && c2 instanceof Player) {
                        o = c2;
                    } else if (c2 instanceof Card) {
                        o = ((Card)c2).getController();
                    } else if (c2 instanceof SpellAbility) {
                        o = ((SpellAbility)c2).getActivatingPlayer();
                    } else if (c2 instanceof Iterable) {
                        if (orCont) {
                            AbilityUtils.addPlayer(Iterables.filter((Iterable)c2, Player.class), "", players);
                        }
                        AbilityUtils.addPlayer(Iterables.filter((Iterable)c2, Card.class), "Controller", players);
                    }
                } else if (defParsed.endsWith("Opponent")) {
                    String triggeringType = defParsed.substring(9);
                    c = spellAbility.getTriggeringObject(AbilityKey.fromString(triggeringType = triggeringType.substring(0, triggeringType.length() - 8)));
                    if (c instanceof Card) {
                        o = ((Card)c).getController().getOpponents();
                    }
                    if (c instanceof SpellAbility) {
                        o = ((SpellAbility)c).getActivatingPlayer().getOpponents();
                    }
                    if (c instanceof CardCollection) {
                        o = ((Card)((CardCollection)c).get(false)).getController().getOpponents();
                    }
                } else if (defParsed.endsWith("Owner")) {
                    String triggeringType = defParsed.substring(9);
                    c = spellAbility.getTriggeringObject(AbilityKey.fromString(triggeringType = triggeringType.substring(0, triggeringType.length() - 5)));
                    if (c instanceof Card) {
                        o = ((Card)c).getOwner();
                    }
                    if (c instanceof CardCollection) {
                        o = ((Card)((CardCollection)c).get(false)).getOwner();
                    }
                } else {
                    String triggeringType = defParsed.substring(9);
                    o = spellAbility.getTriggeringObject(AbilityKey.fromString(triggeringType));
                }
                if (o != null) {
                    if (o instanceof Player) {
                        players.add((Player)o);
                    }
                    if (o instanceof Iterable) {
                        players.addAll(Iterables.filter((Iterable)o, Player.class));
                    }
                }
            } else if (defined.startsWith("OppNon")) {
                players.addAll(player.getOpponents());
                players.removeAll(AbilityUtils.getDefinedPlayers(card, defined.substring(6), sa));
            } else if (defined.startsWith("Replaced") && sa instanceof SpellAbility) {
                void var10_52;
                Object c;
                String replacingType;
                SpellAbility root = ((SpellAbility)sa).getRootAbility();
                Object var10_44 = null;
                if (defined.endsWith("Controller")) {
                    replacingType = defined.substring(8);
                    c = root.getReplacingObject(AbilityKey.fromString(replacingType = replacingType.substring(0, replacingType.length() - 10)));
                    if (c instanceof Card) {
                        Player player2 = ((Card)c).getController();
                    }
                    if (c instanceof SpellAbility) {
                        Player player3 = ((SpellAbility)c).getHostCard().getController();
                    }
                } else if (defined.endsWith("Owner")) {
                    replacingType = defined.substring(8);
                    c = root.getReplacingObject(AbilityKey.fromString(replacingType = replacingType.substring(0, replacingType.length() - 5)));
                    if (c instanceof Card) {
                        Player player4 = ((Card)c).getOwner();
                    }
                } else {
                    replacingType = defined.substring(8);
                    Object object = root.getReplacingObject(AbilityKey.fromString(replacingType));
                }
                if (var10_52 != null && var10_52 instanceof Player) {
                    players.add((Player)var10_52);
                }
            } else if (defined.startsWith("Non")) {
                players.addAll(game.getPlayersInTurnOrder());
                players.removeAll(AbilityUtils.getDefinedPlayers(card, defined.substring(3), sa));
            } else if (defined.equals("Registered")) {
                players.addAll(game.getRegisteredPlayers());
            } else if (defined.equals("EnchantedPlayer")) {
                GameEntity o = sa.getHostCard().getEntityAttachedTo();
                if (o instanceof Player) {
                    players.add((Player)o);
                }
            } else if (defined.startsWith("Enchanted")) {
                if (card.isAttachedToEntity()) {
                    AbilityUtils.addPlayer(Lists.newArrayList(card.getEntityAttachedTo()), defined, players);
                }
            } else if (defined.startsWith("Equipped")) {
                if (card.isEquipping()) {
                    AbilityUtils.addPlayer(Lists.newArrayList(card.getEquipping()), defined, players);
                }
            } else if (defined.equals("AttackingPlayer")) {
                if (game.getPhaseHandler().inCombat()) {
                    players.add(game.getCombat().getAttackingPlayer());
                }
            } else if (defined.equals("DefendingPlayer")) {
                players.add(game.getCombat().getDefendingPlayerRelatedTo(card));
            } else if (defined.equals("ChoosingPlayer")) {
                players.add(((SpellAbility)sa).getRootAbility().getChoosingPlayer());
            } else if (defined.equals("ChosenPlayer")) {
                Player p = card.getChosenPlayer();
                if (p != null) {
                    players.add(p);
                }
            } else if (defined.equals("Promised")) {
                Player p = card.getPromisedGift();
                if (p != null) {
                    players.add(p);
                }
            } else if (defined.startsWith("ChosenCard")) {
                AbilityUtils.addPlayer(card.getChosenCards(), defined, players);
            } else if (defined.equals("SourceController")) {
                players.add(sa.getHostCard().getController());
            } else if (defined.equals("CardController")) {
                players.add(card.getController());
            } else if (defined.equals("CardOwner")) {
                players.add(card.getOwner());
            } else if (defined.startsWith("PlayerNamed_")) {
                for (Player player5 : game.getPlayersInTurnOrder()) {
                    if (!player5.getName().equals(defined.substring(12))) continue;
                    players.add(player5);
                }
            } else if (defined.startsWith("Flipped")) {
                for (Player player6 : game.getPlayersInTurnOrder()) {
                    if (null == sa.getHostCard().getFlipResult(player6) || !sa.getHostCard().getFlipResult(player6).equals(defined.substring(7))) continue;
                    players.add(player6);
                }
            } else if (defined.equals("Caster")) {
                if (sa.getHostCard().wasCast()) {
                    players.add(sa.getHostCard().getCastSA().getActivatingPlayer());
                }
            } else if (defined.equals("ActivePlayer")) {
                players.add(game.getPhaseHandler().getPlayerTurn());
            } else if (defined.equals("You")) {
                players.add(player);
            } else if (defined.equals("Opponent")) {
                players.addAll(player.getOpponents());
            } else if (defined.startsWith("NextPlayerToYour")) {
                Direction dir = defined.substring(16).equals("Left") ? Direction.Left : Direction.Right;
                players.add(game.getNextPlayerAfter(player, dir));
            } else if (defined.startsWith("NextOpponentToYour")) {
                void var10_56;
                Direction dir = defined.substring(18).equals("Left") ? Direction.Left : Direction.Right;
                Player player7 = game.getNextPlayerAfter(player, dir);
                while (!var10_56.isOpponentOf(player)) {
                    Player player8 = game.getNextPlayerAfter((Player)var10_56, dir);
                }
                players.add(var10_56);
            } else {
                players.addAll(game.getPlayersInTurnOrder());
            }
        }
        if (incR.length > 1 && !players.isEmpty()) {
            void var10_60;
            String[] valids = incR[1].split(",");
            boolean bl = false;
            while (var10_60 < valids.length) {
                valids[var10_60] = "Player." + valids[var10_60];
                ++var10_60;
            }
            return players.filter(PlayerPredicates.restriction(valids, player, card, sa));
        }
        return players;
    }

    public static FCollection<SpellAbility> getDefinedSpellAbilities(Card card, String def, CardTraitBase sa) {
        FCollection<SpellAbility> sas = new FCollection<SpellAbility>();
        String changedDef = def == null ? "Self" : AbilityUtils.applyAbilityTextChangeEffects(def, sa);
        Player player = sa instanceof SpellAbility ? ((SpellAbility)sa).getActivatingPlayer() : card.getController();
        Game game = card.getGame();
        String[] incR = changedDef.split("\\.", 2);
        sa = AbilityUtils.adjustTriggerContext(incR, sa);
        String defined = incR[0];
        SpellAbility s2 = null;
        if (defined.equals("Self") && sa instanceof SpellAbility) {
            s2 = (SpellAbility)sa;
        } else if (defined.equals("Parent") && sa instanceof SpellAbility) {
            s2 = ((SpellAbility)sa).getRootAbility();
        } else if (defined.equals("Remembered")) {
            for (Object o : card.getRemembered()) {
                if (o instanceof Card) {
                    Card rem = (Card)o;
                    sas.addAll(game.getCardState(rem).getSpellAbilities());
                    continue;
                }
                if (!(o instanceof SpellAbility)) continue;
                sas.add((SpellAbility)o);
            }
        } else if (defined.equals("Imprinted")) {
            for (Card imp : card.getImprintedCards()) {
                sas.addAll(imp.getSpellAbilities());
            }
        } else if (defined.equals("EffectSource")) {
            if (card.getEffectSourceAbility() != null) {
                sas.add(card.getEffectSourceAbility().getRootAbility());
            }
        } else if (defined.equals("SourceFirstSpell")) {
            SpellAbility spell = game.getStack().getSpellMatchingHost(card);
            if (spell != null) {
                sas.add(spell);
            }
        } else if (defined.startsWith("Triggered") && sa instanceof SpellAbility) {
            String triggeringType;
            SpellAbility root = ((SpellAbility)sa).getRootAbility();
            Object o = root.getTriggeringObject(AbilityKey.fromString(triggeringType = defined.substring(9)));
            if (o instanceof SpellAbility) {
                s2 = (SpellAbility)o;
            } else if (o instanceof SpellAbilityStackInstance) {
                s2 = ((SpellAbilityStackInstance)o).getSpellAbility();
            }
        } else if (defined.endsWith("Targeted") && sa instanceof SpellAbility) {
            List<TargetChoices> targets = defined.startsWith("This") ? Arrays.asList(((SpellAbility)sa).getTargets()) : ((SpellAbility)sa).getAllTargetChoices();
            for (TargetChoices tc : targets) {
                for (SpellAbility targetSpell : tc.getTargetSpells()) {
                    SpellAbilityStackInstance stackInstance = game.getStack().getInstanceMatchingSpellAbilityID(targetSpell);
                    if (stackInstance != null) {
                        SpellAbility instanceSA = stackInstance.getSpellAbility();
                        if (instanceSA == null) continue;
                        sas.add(instanceSA);
                        continue;
                    }
                    sas.add(targetSpell);
                }
            }
        } else if (defined.startsWith("ValidStack")) {
            String[] valid = changedDef.split(" ", 2)[1].split(",");
            for (SpellAbilityStackInstance stackInstance : game.getStack()) {
                SpellAbility instanceSA = stackInstance.getSpellAbility();
                if (instanceSA == null || !instanceSA.isValid(valid, player, card, sa)) continue;
                sas.add(instanceSA);
            }
        }
        if (s2 != null) {
            sas.add(s2);
        }
        return sas;
    }

    public static void resolve(SpellAbility sa) {
        ApiType api;
        Card host;
        if (sa == null) {
            return;
        }
        Player pl = sa.getActivatingPlayer();
        Game game = pl.getGame();
        if (sa.isTrigger() && !sa.getTrigger().isStatic() && sa.getParent() == null) {
            game.getTriggerHandler().resetActiveTriggers();
        }
        AbilityUtils.resolvePreAbilities(sa, game);
        if (!sa.isWrapper() && (host = sa.getHostCard()) != null) {
            host.addAbilityResolved(sa);
        }
        if ((api = sa.getApi()) == null) {
            sa.resolve();
            if (sa.getSubAbility() != null) {
                AbilityUtils.resolve(sa.getSubAbility());
            }
            return;
        }
        AbilityUtils.resolveApiAbility(sa, game);
    }

    private static void resolvePreAbilities(SpellAbility sa, Game game) {
        Player controller = sa.getActivatingPlayer();
        Card source = sa.getHostCard();
        if (!sa.isSpell() || source.isPermanent()) {
            return;
        }
        if (source.hasKeyword(Keyword.ASCEND) && controller.getZone(ZoneType.Battlefield).size() >= 10) {
            controller.setBlessing(true);
        }
        if (source.hasKeyword(Keyword.GIFT) && sa.isOptionalCostPaid(OptionalCost.PromiseGift)) {
            game.getAction().checkStaticAbilities();
            AbilitySub giftAbility = (AbilitySub)sa.getAdditionalAbility("GiftAbility");
            if (giftAbility != null) {
                giftAbility.setActivatingPlayer(controller);
                AbilityUtils.resolveApiAbility(giftAbility, game);
            }
        }
    }

    private static void resolveSubAbilities(SpellAbility sa, Game game) {
        AbilitySub abSub = sa.getSubAbility();
        if (abSub == null || sa.isWrapper()) {
            return;
        }
        game.getAction().checkStaticAbilities();
        if (sa.isReplacementAbility()) {
            for (Card lki : sa.getRootAbility().getLastStateBattlefield()) {
                game.getTriggerHandler().registerActiveLTBTrigger(lki);
            }
            game.getTriggerHandler().collectTriggerForWaiting();
        } else {
            game.getTriggerHandler().resetActiveTriggers();
        }
        AbilityUtils.resolveApiAbility(abSub, game);
    }

    private static void resolveApiAbility(SpellAbility sa, Game game) {
        Card card = sa.getHostCard();
        String msg = "AbilityUtils:resolveApiAbility: try to resolve API ability";
        Breadcrumb bread = new Breadcrumb(msg);
        bread.setData("Api", sa.getApi().toString());
        bread.setData("Card", card.getName());
        bread.setData("SA", sa.toString());
        Sentry.addBreadcrumb(bread);
        if (!sa.isWrapper() && sa.isKeyword(Keyword.GIFT)) {
            game.getTriggerHandler().runTrigger(TriggerType.GiveGift, AbilityKey.mapFromPlayer(sa.getActivatingPlayer()), false);
        }
        if (sa.metConditions()) {
            if (sa.isWrapper() || StringUtils.isBlank(sa.getParam("UnlessCost"))) {
                sa.resolve();
            } else {
                AbilityUtils.handleUnlessCost(sa, game);
                return;
            }
        }
        AbilityUtils.resolveSubAbilities(sa, game);
    }

    private static void handleUnlessCost(SpellAbility sa, Game game) {
        Card source = sa.getHostCard();
        String pays = sa.getParamOrDefault("UnlessPayer", "TargetedController");
        PlayerCollection allPayers = AbilityUtils.getDefinedPlayers(source, pays, sa);
        String resolveSubs = sa.getParam("UnlessResolveSubs");
        boolean execSubsWhenPaid = "WhenPaid".equals(resolveSubs) || StringUtils.isBlank(resolveSubs);
        boolean execSubsWhenNotPaid = "WhenNotPaid".equals(resolveSubs) || StringUtils.isBlank(resolveSubs);
        boolean isSwitched = sa.hasParam("UnlessSwitched");
        String unlessCost = sa.getParam("UnlessCost").trim();
        Cost cost = AbilityUtils.calculateUnlessCost(sa, unlessCost, true);
        if (cost == null) {
            sa.resolve();
            AbilityUtils.resolveSubAbilities(sa, game);
            return;
        }
        boolean alreadyPaid = false;
        for (Player payer : allPayers) {
            if (!payer.isInGame()) continue;
            if (unlessCost.equals("LifeTotalHalfUp")) {
                String halfup = Integer.toString(Math.max(0, (int)Math.ceil((double)payer.getLife() / 2.0)));
                cost = new Cost("PayLife<" + halfup + ">", true);
            }
            alreadyPaid |= payer.getController().payCostToPreventEffect(cost, sa, alreadyPaid, allPayers);
        }
        if (alreadyPaid == isSwitched) {
            sa.resolve();
        }
        if (alreadyPaid && execSubsWhenPaid || !alreadyPaid && execSubsWhenNotPaid) {
            AbilityUtils.resolveSubAbilities(sa, game);
        }
    }

    public static Cost calculateUnlessCost(SpellAbility sa, String unlessCost, boolean beforePayment) {
        Cost cost;
        Card source = sa.getHostCard();
        if (unlessCost.equals("ChosenNumber")) {
            cost = new Cost(new ManaCost(new ManaCostParser(String.valueOf(source.getChosenNumber()))), true);
        } else if (unlessCost.startsWith("DefinedCost")) {
            CardCollection definedCards = AbilityUtils.getDefinedCards(source, unlessCost.split("_")[1], sa);
            if (definedCards.isEmpty()) {
                return null;
            }
            Card card = (Card)definedCards.getFirst();
            ManaCostBeingPaid newCost = new ManaCostBeingPaid(card.getManaCost());
            if (unlessCost.split("_").length == 3) {
                String modifier = unlessCost.split("_")[2];
                if (modifier.startsWith("Minus")) {
                    int max = Integer.parseInt(modifier.substring(5));
                    if (sa.hasParam("UnlessUpTo") && beforePayment) {
                        max = sa.getActivatingPlayer().getController().chooseNumber(sa, Localizer.getInstance().getMessage("lblChooseNumber", new Object[0]), 0, max);
                    }
                    newCost.decreaseGenericMana(max);
                } else {
                    newCost.increaseGenericMana(Integer.parseInt(modifier.substring(4)));
                }
            }
            cost = new Cost(newCost.toManaCost(), true);
        } else if (unlessCost.startsWith("DefinedSACost")) {
            FCollection<SpellAbility> definedSAs = AbilityUtils.getDefinedSpellAbilities(source, unlessCost.split("_")[1], sa);
            if (definedSAs.isEmpty()) {
                return null;
            }
            Card host = definedSAs.getFirst().getHostCard();
            if (host.getManaCost() == null) {
                cost = new Cost(ManaCost.ZERO, true);
            } else {
                int xCount = host.getManaCost().countX();
                int xPaid = host.getXManaCostPaid() * xCount;
                ManaCostBeingPaid toPay = new ManaCostBeingPaid(host.getManaCost());
                toPay.decreaseShard(ManaCostShard.X, xCount);
                toPay.increaseGenericMana(xPaid);
                cost = new Cost(toPay.toManaCost(), true);
            }
        } else if (!StringUtils.isBlank(sa.getSVar(unlessCost)) && !unlessCost.equals("X")) {
            int xCost = AbilityUtils.calculateAmount(source, TextUtil.fastReplace(sa.getParam("UnlessCost"), " ", ""), sa);
            ManaCostBeingPaid toPay = new ManaCostBeingPaid(ManaCost.ZERO);
            byte xColor = ManaAtom.fromName(sa.getParamOrDefault("UnlessColor", "1"));
            toPay.increaseShard(ManaCostShard.valueOf(xColor), xCost);
            cost = new Cost(toPay.toManaCost(), true);
        } else {
            cost = new Cost(unlessCost, true);
        }
        return cost;
    }

    public static void handleRemembering(SpellAbility sa) {
        Card host = sa.getHostCard();
        if (sa.hasParam("RememberTargets") && sa.usesTargeting()) {
            if (sa.hasParam("ForgetOtherTargets")) {
                host.clearRemembered();
            }
            host.addRemembered(sa.getTargets());
            if (sa.hasParam("IncludeAllComponentCards")) {
                for (Card c : sa.getTargets().getTargetCards()) {
                    host.addRemembered(c.getAllComponentCards(false));
                }
            }
        }
        if (sa.hasParam("RememberCostMana")) {
            host.clearRemembered();
            ManaCostBeingPaid activationMana = new ManaCostBeingPaid(sa.getPayCosts().getTotalMana());
            if (sa.getXManaCostPaid() != null) {
                activationMana.setXManaCostPaid(sa.getXManaCostPaid(), null);
            }
            int activationShards = activationMana.getConvertedManaCost();
            List<Mana> payingMana = sa.getPayingMana();
            List<Mana> activationPaid = payingMana.subList(0, activationShards);
            StringBuilder sb = new StringBuilder();
            int nMana = 0;
            for (Mana m4 : activationPaid) {
                if (nMana > 0) {
                    sb.append(" ");
                }
                sb.append(m4.toString());
                ++nMana;
            }
            host.addRemembered(sb.toString());
        }
    }

    /*
     * WARNING - void declaration
     */
    public static int xCount(Card c, String s2, CardTraitBase ctb) {
        CardCollection list;
        String restriction;
        CounterType cType;
        String[] parts;
        CardCollectionView cards;
        Object rest;
        String[] sqparts;
        String validFilter;
        String[] workingCopy;
        String note;
        String[] props;
        SpellAbility castSA;
        String[] lparts;
        String s22 = AbilityUtils.applyAbilityTextChangeEffects(s2, ctb);
        String[] l = s22.split("/");
        String expr = CardFactoryUtil.extractOperators(s22);
        Player player = null;
        if (ctb != null) {
            if (ctb instanceof SpellAbility) {
                player = ((SpellAbility)ctb).getActivatingPlayer();
            }
            if (player == null) {
                player = ctb.getHostCard().getController();
            }
        }
        if (l[0].startsWith("Number$")) {
            String number = l[0].substring(7);
            return AbilityUtils.doXMath(Integer.parseInt(number), expr, c, ctb);
        }
        if (l[0].startsWith("Count$")) {
            l[0] = l[0].substring(6);
        }
        if (l[0].startsWith("SVar$")) {
            String n = l[0].substring(5);
            String v = ctb == null ? c.getSVar(n) : ctb.getSVar(n);
            return AbilityUtils.doXMath(AbilityUtils.xCount(c, v, ctb), expr, c, ctb);
        }
        Object[] sq = l[0].split("\\.");
        Game game = c.getGame();
        if (ctb != null) {
            if (sq[0].startsWith("Compare")) {
                int rhs;
                String[] compString = sq[0].split(" ");
                int lhs = AbilityUtils.calculateAmount(c, compString[1], ctb);
                boolean v = Expressions.compare(lhs, compString[2], rhs = AbilityUtils.calculateAmount(c, compString[2].substring(2), ctb));
                return AbilityUtils.doXMath(AbilityUtils.calculateAmount(c, sq[v ? 1 : 2], ctb), expr, c, ctb);
            }
            if (sq[0].startsWith("IsPrime")) {
                String[] compString = sq[0].split(" ");
                int lhs = AbilityUtils.calculateAmount(c, compString[1], ctb);
                boolean v = IntMath.isPrime(lhs);
                return AbilityUtils.doXMath(AbilityUtils.calculateAmount(c, sq[v ? 1 : 2], ctb), expr, c, ctb);
            }
            if (ctb instanceof SpellAbility) {
                SpellAbility sa = (SpellAbility)ctb;
                if (sq[0].contains("xPaid")) {
                    SpellAbility root = sa.getRootAbility();
                    if (root.getXManaCostPaid() != null) {
                        return AbilityUtils.doXMath(root.getXManaCostPaid(), expr, c, ctb);
                    }
                    if (sa.isCopiedTrait() && !sa.getHostCard().equals(c)) {
                        return AbilityUtils.doXMath(0, expr, c, ctb);
                    }
                    if (root.isTrigger()) {
                        Trigger t2 = root.getTrigger();
                        if (t2.getSpawningAbility() != null) {
                            root = t2.getSpawningAbility().getRootAbility();
                            return AbilityUtils.doXMath(root.getXManaCostPaid() == null ? 0 : root.getXManaCostPaid(), expr, c, ctb);
                        }
                        if (TriggerType.ChangesZone.equals((Object)t2.getMode()) && ZoneType.Battlefield.name().equals(t2.getParam("Destination"))) {
                            return AbilityUtils.doXMath(c.getXManaCostPaid(), expr, c, ctb);
                        }
                        if (TriggerType.SpellCast.equals((Object)t2.getMode())) {
                            SpellAbilityStackInstance castSI = (SpellAbilityStackInstance)root.getTriggeringObject(AbilityKey.StackInstance);
                            if (castSI == null || castSI.getSpellAbility().getXManaCostPaid() == null) {
                                return AbilityUtils.doXMath(0, expr, c, ctb);
                            }
                            return AbilityUtils.doXMath(castSI.getSpellAbility().getXManaCostPaid(), expr, c, ctb);
                        }
                        if (TriggerType.Cycled.equals((Object)t2.getMode())) {
                            SpellAbility cycleSA = (SpellAbility)sa.getTriggeringObject(AbilityKey.Cause);
                            if (cycleSA == null || cycleSA.getXManaCostPaid() == null) {
                                return AbilityUtils.doXMath(0, expr, c, ctb);
                            }
                            return AbilityUtils.doXMath(cycleSA.getXManaCostPaid(), expr, c, ctb);
                        }
                        if (TriggerType.TurnFaceUp.equals((Object)t2.getMode())) {
                            SpellAbility turnupSA = (SpellAbility)sa.getTriggeringObject(AbilityKey.Cause);
                            if (turnupSA == null || turnupSA.getXManaCostPaid() == null) {
                                return AbilityUtils.doXMath(0, expr, c, ctb);
                            }
                            return AbilityUtils.doXMath(turnupSA.getXManaCostPaid(), expr, c, ctb);
                        }
                    }
                    if (root.isReplacementAbility() && sa.hasParam("ETB")) {
                        return AbilityUtils.doXMath(c.getXManaCostPaid(), expr, c, ctb);
                    }
                    return AbilityUtils.doXMath(0, expr, c, ctb);
                }
                if (sq[0].startsWith("Kicked")) {
                    boolean kicked = sa.isKicked() || !AbilityUtils.isUnlinkedFromCastSA(ctb, c) && c.getKickerMagnitude() > 0;
                    return AbilityUtils.doXMath(Integer.parseInt(kicked ? sq[1] : sq[2]), expr, c, ctb);
                }
                if (sq[0].startsWith("Bargain")) {
                    return AbilityUtils.doXMath(AbilityUtils.calculateAmount(c, sq[sa.isBargained() ? 1 : 2], ctb), expr, c, ctb);
                }
                if (sq[0].startsWith("Freerunning")) {
                    return AbilityUtils.doXMath(AbilityUtils.calculateAmount(c, sq[sa.isFreerunning() ? 1 : 2], ctb), expr, c, ctb);
                }
                if (sq[0].startsWith("Madness")) {
                    return AbilityUtils.doXMath(AbilityUtils.calculateAmount(c, sq[sa.isMadness() ? 1 : 2], ctb), expr, c, ctb);
                }
                if (sq[0].contains("HasNumChosenColors")) {
                    int sum = 0;
                    for (Card card : AbilityUtils.getDefinedCards(c, sq[1], sa)) {
                        sum += card.getColor().getSharedColors(ColorSet.fromNames(c.getChosenColors())).countColors();
                    }
                    return sum;
                }
                if (sq[0].startsWith("TriggerRememberAmount")) {
                    SpellAbility root = sa.getRootAbility();
                    int count = 0;
                    for (Object object : root.getTriggerRemembered()) {
                        if (!(object instanceof Integer)) continue;
                        count += ((Integer)object).intValue();
                    }
                    return count;
                }
                if (sq[0].startsWith("TriggeredManaCostDevotion")) {
                    SpellAbility root = sa.getRootAbility();
                    Card triggeringObject = (Card)root.getTriggeringObject(AbilityKey.Card);
                    int count = 0;
                    byte by = ManaAtom.fromName(sq[1]);
                    for (ManaCostShard sh : triggeringObject.getManaCost()) {
                        if (!sh.isColor(by)) continue;
                        ++count;
                    }
                    return count;
                }
                if (sq[0].startsWith("TriggeredPayingMana")) {
                    SpellAbility root = sa.getRootAbility();
                    String mana = (String)root.getTriggeringObject(AbilityKey.PayingMana);
                    int count = 0;
                    Matcher matcher = Pattern.compile(StringUtils.join(sq, "|", 1, sq.length)).matcher(mana);
                    while (matcher.find()) {
                        ++count;
                    }
                    return count;
                }
                if (sq[0].startsWith("AmountManaProduced")) {
                    SpellAbility root = sa.getRootAbility();
                    int amount = 0;
                    if (root != null) {
                        for (AbilityManaPart abilityManaPart : root.getAllManaParts()) {
                            amount += abilityManaPart.getLastManaProduced().size();
                        }
                    }
                    return AbilityUtils.doXMath(amount, expr, c, ctb);
                }
                if (sq[0].startsWith("NumTimesChoseMode")) {
                    int amount = 0;
                    for (SpellAbility sub = sa.getRootAbility(); sub != null; sub = sub.getSubAbility()) {
                        if (!sub.getDirectSVars().containsKey("CharmOrder")) continue;
                        ++amount;
                    }
                    return AbilityUtils.doXMath(amount, expr, c, ctb);
                }
                if (sq[0].equals("ManaColorsPaid")) {
                    SpellAbility root = sa.getRootAbility();
                    return AbilityUtils.doXMath(root == null ? 0 : root.getPayingColors().countColors(), expr, c, ctb);
                }
                if (((String)sq[0]).startsWith("Adamant")) {
                    String payingMana = StringUtils.join(sa.getRootAbility().getPayingMana());
                    int num = ((String)sq[0]).length() > 7 ? Integer.parseInt(((String)sq[0]).split("_")[1]) : 3;
                    boolean adamant = StringUtils.countMatches((CharSequence)payingMana, MagicColor.toShortString((String)sq[1])) >= num;
                    return AbilityUtils.doXMath(AbilityUtils.calculateAmount(c, (String)sq[adamant ? 2 : 3], ctb), expr, c, ctb);
                }
                if (((String)sq[0]).startsWith("LastStateBattlefield")) {
                    CardCollectionView list2;
                    String[] k = l[0].split(" ");
                    if (((String)sq[0]).contains("WithFallback")) {
                        if (!sa.getHostCard().wasCast()) {
                            return AbilityUtils.doXMath(0, expr, c, ctb);
                        }
                        CardCollection list3 = sa.getHostCard().getCastSA().getLastStateBattlefield();
                    } else {
                        list2 = sa.getLastStateBattlefield();
                    }
                    if (list2 == null || list2.isEmpty()) {
                        if (((String)sq[0]).contains("WithFallback")) {
                            list2 = game.getCardsIn(ZoneType.Battlefield);
                        } else {
                            return AbilityUtils.doXMath(0, expr, c, ctb);
                        }
                    }
                    list2 = CardLists.getValidCards((Iterable<Card>)list2, k[1], player, c, (CardTraitBase)sa);
                    return AbilityUtils.doXMath(list2.size(), expr, c, ctb);
                }
                if (((String)sq[0]).startsWith("LastStateGraveyard")) {
                    CardCollectionView list3;
                    String[] k = l[0].split(" ");
                    if (((String)sq[0]).contains("WithFallback")) {
                        if (!sa.getHostCard().wasCast()) {
                            return AbilityUtils.doXMath(0, expr, c, ctb);
                        }
                        CardCollection list4 = sa.getHostCard().getCastSA().getLastStateGraveyard();
                    } else {
                        list3 = sa.getLastStateGraveyard();
                    }
                    if (sa.getLastStateGraveyard() == null || list3.isEmpty()) {
                        if (((String)sq[0]).contains("WithFallback")) {
                            list3 = game.getCardsIn(ZoneType.Graveyard);
                        } else {
                            return AbilityUtils.doXMath(0, expr, c, ctb);
                        }
                    }
                    list3 = CardLists.getValidCards((Iterable<Card>)list3, k[1], player, c, (CardTraitBase)sa);
                    return AbilityUtils.doXMath(list3.size(), expr, c, ctb);
                }
                if (((String)sq[0]).equals("ResolvedThisTurn")) {
                    return AbilityUtils.doXMath(sa.getResolvedThisTurn(), expr, c, ctb);
                }
                if (((String)sq[0]).startsWith("TotalManaSpent ")) {
                    String[] k = ((String)sq[0]).split(" ");
                    int v = 0;
                    if (sa.getRootAbility().getPayingMana() != null) {
                        for (Mana mana : sa.getRootAbility().getPayingMana()) {
                            Card source = mana.getSourceCard();
                            if (source == null || !source.isValid(k[1].split(","), player, c, (CardTraitBase)sa)) continue;
                            ++v;
                        }
                    }
                    return AbilityUtils.doXMath(v, expr, c, ctb);
                }
            } else {
                if (sq[0].startsWith("LastStateBattlefield")) {
                    String[] k = l[0].split(" ");
                    CardCollectionView list4 = game.getLastStateBattlefield();
                    list4 = CardLists.getValidCards((Iterable<Card>)list4, k[1], player, c, ctb);
                    return AbilityUtils.doXMath(list4.size(), expr, c, ctb);
                }
                if (sq[0].startsWith("LastStateGraveyard")) {
                    String[] k = l[0].split(" ");
                    CardCollectionView list5 = game.getLastStateGraveyard();
                    list5 = CardLists.getValidCards((Iterable<Card>)list5, k[1], player, c, ctb);
                    return AbilityUtils.doXMath(list5.size(), expr, c, ctb);
                }
                if (sq[0].startsWith("xPaid")) {
                    return AbilityUtils.doXMath(c.getXManaCostPaid(), expr, c, ctb);
                }
            }
            if (sq[0].equals("CastTotalManaSpent")) {
                return AbilityUtils.doXMath(c.getCastSA() != null ? c.getCastSA().getTotalManaSpent() : 0, expr, c, ctb);
            }
            if (sq[0].startsWith("CastTotalManaSpent ")) {
                String[] k = sq[0].split(" ");
                int v = 0;
                if (c.getCastSA() != null) {
                    for (Mana m5 : c.getCastSA().getPayingMana()) {
                        Card card = m5.getSourceCard();
                        if (card == null || !card.isValid(k[1].split(","), player, c, ctb)) continue;
                        ++v;
                    }
                }
                return AbilityUtils.doXMath(v, expr, c, ctb);
            }
            if (sq[0].equals("hasOptionalKeywordAmount")) {
                return AbilityUtils.doXMath(c.getCastSA() != null && c.getCastSA().hasOptionalKeywordAmount(ctb.getKeyword()) ? 1 : 0, expr, c, ctb);
            }
            if (sq[0].equals("OptionalKeywordAmount")) {
                return AbilityUtils.doXMath(c.getCastSA() != null ? c.getCastSA().getOptionalKeywordAmount(ctb.getKeyword()) : 0, expr, c, ctb);
            }
            if (sq[0].contains("Devotion")) {
                int colorOccurrences = 0;
                String colorName = sq[1];
                if (colorName.contains("Chosen")) {
                    colorName = MagicColor.toShortString(c.getChosenColor());
                }
                byte colorCode = ManaAtom.fromName(colorName);
                if (sq[0].equals("DevotionDual")) {
                    colorCode = (byte)(colorCode | ManaAtom.fromName(sq[2]));
                }
                for (Card card : player.getCardsIn(ZoneType.Battlefield)) {
                    for (ManaCostShard sh : card.getManaCost()) {
                        if (!sh.isColor(colorCode)) continue;
                        ++colorOccurrences;
                    }
                    colorOccurrences += card.getAmountOfKeyword("Your devotion to each color and each combination of colors is increased by one.");
                }
                return AbilityUtils.doXMath(colorOccurrences, expr, c, ctb);
            }
        }
        if (sq[0].contains("SearchedLibrary")) {
            int sum = 0;
            for (Player p : AbilityUtils.getDefinedPlayers(c, sq[1], ctb)) {
                sum += p.getLibrarySearched();
            }
            return AbilityUtils.doXMath(sum, expr, c, ctb);
        }
        String[] paidparts = l[0].split("\\$", 2);
        Iterable<Card> someCards = null;
        if (sq[0].startsWith("Valid")) {
            lparts = paidparts[0].split(" ", 2);
            Iterator<Integer> cardsInZones2 = null;
            if (lparts[0].contains("All")) {
                cardsInZones2 = game.getCardsInGame();
            } else if (lparts[0].endsWith("Self")) {
                cardsInZones2 = new CardCollection(c);
            } else {
                SpellAbility sa;
                List<ZoneType> list5 = ZoneType.listValueOf(lparts[0].length() > 5 ? lparts[0].substring(5) : "Battlefield");
                boolean usedLastState = false;
                if (ctb instanceof SpellAbility && list5.size() == 1 && (sa = (SpellAbility)ctb).isReplacementAbility()) {
                    if (list5.get(0).equals((Object)ZoneType.Battlefield)) {
                        cardsInZones2 = sa.getRootAbility().getLastStateBattlefield();
                        usedLastState = true;
                    } else if (list5.get(0).equals((Object)ZoneType.Graveyard)) {
                        cardsInZones2 = sa.getRootAbility().getLastStateGraveyard();
                        usedLastState = true;
                    }
                }
                if (!usedLastState) {
                    cardsInZones2 = game.getCardsIn(list5);
                }
            }
            someCards = CardLists.getValidCards((Iterable<Card>)((Object)cardsInZones2), lparts[1], player, c, ctb);
        }
        if (sq[0].startsWith("RememberedSize")) {
            return AbilityUtils.doXMath(c.getRememberedCount(), expr, c, ctb);
        }
        if (sq[0].startsWith("ChosenSize")) {
            return AbilityUtils.doXMath(c.getChosenCards().size(), expr, c, ctb);
        }
        if (sq[0].startsWith("ImprintedSize")) {
            return AbilityUtils.doXMath(c.getImprintedCards().size(), expr, c, ctb);
        }
        if (sq[0].startsWith("RememberedNumber")) {
            int num = 0;
            for (Object e : c.getRemembered()) {
                if (!(e instanceof Integer)) continue;
                num += ((Integer)e).intValue();
            }
            return AbilityUtils.doXMath(num, expr, c, ctb);
        }
        if (sq[0].startsWith("RememberedWithSharedCardType")) {
            int maxNum = 1;
            for (Object object : c.getRemembered()) {
                if (!(object instanceof Card)) continue;
                int num = 1;
                Iterator<CardType.CoreType> firstCard = (Card)object;
                for (Object p : c.getRemembered()) {
                    Card secondCard;
                    if (!(p instanceof Card) || ((GameEntity)((Object)firstCard)).equals(secondCard = (Card)p) || !((Card)((Object)firstCard)).sharesCardTypeWith(secondCard)) continue;
                    ++num;
                }
                if (num <= maxNum) continue;
                maxNum = num;
            }
            return AbilityUtils.doXMath(maxNum, expr, c, ctb);
        }
        if (game != null) {
            c = game.getChangeZoneLKIInfo(c);
        }
        if (sq[0].contains("CardMulticolor")) {
            boolean isMulti = c.getColor().isMulticolor();
            return AbilityUtils.doXMath(Integer.parseInt(sq[isMulti ? 1 : 2]), expr, c, ctb);
        }
        if (sq[0].equals("ColorsColorIdentity")) {
            return AbilityUtils.doXMath(c.getController().getCommanderColorID().countColors(), expr, c, ctb);
        }
        if (sq[0].startsWith("Foretold")) {
            return AbilityUtils.doXMath(AbilityUtils.calculateAmount(c, sq[c.isForetold() ? 1 : 2], ctb), expr, c, ctb);
        }
        if (sq[0].startsWith("Kicked")) {
            return AbilityUtils.doXMath(AbilityUtils.calculateAmount(c, sq[!AbilityUtils.isUnlinkedFromCastSA(ctb, c) && c.getKickerMagnitude() > 0 ? 1 : 2], ctb), expr, c, ctb);
        }
        if (sq[0].startsWith("Escaped")) {
            return AbilityUtils.doXMath(AbilityUtils.calculateAmount(c, (String)sq[c.getCastSA() != null && c.getCastSA().isEscape() ? 1 : 2], ctb), expr, c, ctb);
        }
        if (sq[0].startsWith("Emerged")) {
            return AbilityUtils.doXMath(AbilityUtils.calculateAmount(c, (String)sq[!AbilityUtils.isUnlinkedFromCastSA(ctb, c) && c.getCastSA() != null && c.getCastSA().isEmerge() ? 1 : 2], ctb), expr, c, ctb);
        }
        if (((String)sq[0]).startsWith("AltCost")) {
            return AbilityUtils.doXMath(AbilityUtils.calculateAmount(c, (String)sq[c.isOptionalCostPaid(OptionalCost.AltCost) ? 1 : 2], ctb), expr, c, ctb);
        }
        if (((String)sq[0]).startsWith("OptionalGenericCostPaid")) {
            return AbilityUtils.doXMath(AbilityUtils.calculateAmount(c, (String)sq[c.isOptionalCostPaid(OptionalCost.Generic) ? 1 : 2], ctb), expr, c, ctb);
        }
        if (((String)sq[0]).equals("CardPower")) {
            return AbilityUtils.doXMath(c.getNetPower(), expr, c, ctb);
        }
        if (((String)sq[0]).equals("CardBasePower")) {
            return AbilityUtils.doXMath(c.getCurrentPower(), expr, c, ctb);
        }
        if (((String)sq[0]).equals("CardToughness")) {
            return AbilityUtils.doXMath(c.getNetToughness(), expr, c, ctb);
        }
        if (((String)sq[0]).equals("CardSumPT")) {
            return AbilityUtils.doXMath(c.getNetPower() + c.getNetToughness(), expr, c, ctb);
        }
        if (((String)sq[0]).equals("CardNumNotedTypes")) {
            return AbilityUtils.doXMath(c.getNumNotedTypes(), expr, c, ctb);
        }
        if (((String)sq[0]).equals("CardNumColors")) {
            return AbilityUtils.doXMath(c.getColor().countColors(), expr, c, ctb);
        }
        if (((String)sq[0]).equals("CardNumAttacksThisTurn")) {
            return AbilityUtils.doXMath(c.getDamageHistory().getCreatureAttacksThisTurn(), expr, c, ctb);
        }
        if (((String)sq[0]).equals("CardNumAttacksThisGame")) {
            return AbilityUtils.doXMath(c.getDamageHistory().getAttacksThisGame(), expr, c, ctb);
        }
        if (((String)sq[0]).equals("CrewSize")) {
            return AbilityUtils.doXMath(c.getCrewedByThisTurn() == null ? 0 : c.getCrewedByThisTurn().size(), expr, c, ctb);
        }
        if (((String)sq[0]).equals("Intensity")) {
            return AbilityUtils.doXMath(c.getIntensity(true), expr, c, ctb);
        }
        if (((String)sq[0]).contains("CardCounters")) {
            int count = 0;
            if (((String)sq[1]).equals("ALL")) {
                for (Integer n : c.getCounters().values()) {
                    if (n == null || n <= 0) continue;
                    count += n.intValue();
                }
            } else {
                count = c.getCounters(CounterType.getType((String)sq[1]));
            }
            return AbilityUtils.doXMath(count, expr, c, ctb);
        }
        if (((String)sq[0]).contains("TotalValue")) {
            return AbilityUtils.doXMath(c.getKeywordMagnitude(Keyword.smartValueOf(l[0].split(" ")[1])), expr, c, ctb);
        }
        if (((String)sq[0]).contains("TimesKicked")) {
            return AbilityUtils.doXMath(AbilityUtils.isUnlinkedFromCastSA(ctb, c) ? 0 : c.getKickerMagnitude(), expr, c, ctb);
        }
        if (((String)sq[0]).contains("TimesMutated")) {
            return AbilityUtils.doXMath(c.getTimesMutated(), expr, c, ctb);
        }
        if (((String)sq[0]).equals("RegeneratedThisTurn")) {
            return AbilityUtils.doXMath(c.getRegeneratedThisTurn(), expr, c, ctb);
        }
        if (((String)sq[0]).contains("Converge")) {
            castSA = c.getCastSA();
            return AbilityUtils.doXMath(castSA == null ? 0 : castSA.getPayingColors().countColors(), expr, c, ctb);
        }
        if (((String)sq[0]).startsWith("EachPhyrexianPaidWithLife")) {
            castSA = c.getCastSA();
            if (castSA == null) {
                return 0;
            }
            return AbilityUtils.doXMath(castSA.getSpendPhyrexianMana(), expr, c, ctb);
        }
        if (((String)sq[0]).startsWith("EachSpentToCast")) {
            castSA = c.getCastSA();
            if (castSA == null) {
                return 0;
            }
            List<Mana> paidMana = castSA.getPayingMana();
            Object object = sq[1];
            int count = 0;
            for (Mana m6 : paidMana) {
                if (!m6.toString().equals(object)) continue;
                ++count;
            }
            return AbilityUtils.doXMath(count, expr, c, ctb);
        }
        if (((String)sq[0]).startsWith("wasCastFrom")) {
            void var13_115;
            boolean your = ((String)sq[0]).contains("Your");
            boolean byYou = ((String)sq[0]).contains("ByYou");
            String string = ((String)sq[0]).substring(11);
            if (your) {
                String string2 = string.substring(4);
            }
            if (byYou) {
                void var13_113;
                String string3 = var13_113.substring(0, var13_113.indexOf("ByYou", 0));
            }
            boolean zonesMatch = !(c.getCastFrom() == null || c.getCastFrom().getZoneType() != ZoneType.smartValueOf((String)var13_115) || byYou && !player.equals(c.getCastSA().getActivatingPlayer()) || your && !c.getCastFrom().getPlayer().equals(player));
            return AbilityUtils.doXMath(AbilityUtils.calculateAmount(c, (String)sq[zonesMatch ? 1 : 2], ctb), expr, c, ctb);
        }
        if (((String)sq[0]).startsWith("Presence")) {
            int ctrl;
            int n;
            String type = ((String)sq[0]).split("_")[1];
            boolean found = false;
            if (c.getCastFrom() != null && c.getCastSA() != null && (n = AbilityUtils.calculateAmount(c, "Revealed$Valid " + type, c.getCastSA())) + (ctrl = AbilityUtils.calculateAmount(c, "Count$LastStateBattlefield " + type + ".YouCtrl", c.getCastSA())) >= 1) {
                found = true;
            }
            return AbilityUtils.doXMath(AbilityUtils.calculateAmount(c, (String)sq[found ? 1 : 2], ctb), expr, c, ctb);
        }
        if (((String)sq[0]).startsWith("Devoured")) {
            String validDevoured = ((String)sq[0]).split(" ")[1];
            CardCollection cl = CardLists.getValidCards((Iterable<Card>)c.getDevouredCards(), validDevoured, player, c, ctb);
            return AbilityUtils.doXMath(cl.size(), expr, c, ctb);
        }
        if (((String)sq[0]).contains("ChosenNumber")) {
            Integer i = c.getChosenNumber();
            return AbilityUtils.doXMath(i == null ? 0 : i, expr, c, ctb);
        }
        if (((String)sq[0]).contains("IfCastInOwnMainPhase")) {
            PhaseHandler cPhase = game.getPhaseHandler();
            boolean isMyMain = cPhase.getPhase().isMain() && cPhase.isPlayerTurn(player) && c.getCastFrom() != null;
            return AbilityUtils.doXMath(Integer.parseInt((String)sq[isMyMain ? 1 : 2]), expr, c, ctb);
        }
        if (((String)sq[0]).startsWith("FinishedUpkeepsThisTurn")) {
            return AbilityUtils.doXMath(game.getPhaseHandler().getNumUpkeep() - (game.getPhaseHandler().is(PhaseType.UPKEEP) ? 1 : 0), expr, c, ctb);
        }
        if (((String)sq[0]).startsWith("AttachedTo")) {
            String[] k = l[0].split(" ");
            int sum = CardLists.getValidCardCount(c.getAttachedCards(), k[1], player, c, ctb);
            return AbilityUtils.doXMath(sum, expr, c, ctb);
        }
        if (((String)sq[0]).contains("CardManaCost")) {
            int cmc = c.getCMC();
            if (((String)sq[0]).contains("LKI") && !c.isInZone(ZoneType.Stack) && c.getManaCost() != null) {
                cmc = ctb instanceof SpellAbility && ((SpellAbility)ctb).getXManaCostPaid() != null ? (cmc += ((SpellAbility)ctb).getXManaCostPaid() * c.getManaCost().countX()) : (cmc += c.getXManaCostPaid() * c.getManaCost().countX());
            }
            return AbilityUtils.doXMath(cmc, expr, c, ctb);
        }
        if (((String)sq[0]).equals("EnchantedControllerCreatures")) {
            int v = 0;
            if (c.getEnchantingCard() != null) {
                v = CardLists.count(c.getEnchantingCard().getController().getCardsIn(ZoneType.Battlefield), CardPredicates.Presets.CREATURES);
            }
            return AbilityUtils.doXMath(v, expr, c, ctb);
        }
        if (((String)sq[0]).equals("Hellbent")) {
            return AbilityUtils.doXMath(AbilityUtils.calculateAmount(c, (String)sq[player.hasHellbent() ? 1 : 2], ctb), expr, c, ctb);
        }
        if (((String)sq[0]).equals("Metalcraft")) {
            return AbilityUtils.doXMath(AbilityUtils.calculateAmount(c, (String)sq[player.hasMetalcraft() ? 1 : 2], ctb), expr, c, ctb);
        }
        if (((String)sq[0]).equals("Delirium")) {
            return AbilityUtils.doXMath(AbilityUtils.calculateAmount(c, (String)sq[player.hasDelirium() ? 1 : 2], ctb), expr, c, ctb);
        }
        if (((String)sq[0]).equals("FatefulHour")) {
            return AbilityUtils.doXMath(AbilityUtils.calculateAmount(c, (String)sq[player.getLife() <= 5 ? 1 : 2], ctb), expr, c, ctb);
        }
        if (((String)sq[0]).equals("Revolt")) {
            return AbilityUtils.doXMath(AbilityUtils.calculateAmount(c, (String)sq[player.hasRevolt() ? 1 : 2], ctb), expr, c, ctb);
        }
        if (((String)sq[0]).equals("Landfall")) {
            return AbilityUtils.doXMath(AbilityUtils.calculateAmount(c, (String)sq[player.hasLandfall() ? 1 : 2], ctb), expr, c, ctb);
        }
        if (((String)sq[0]).equals("Monarch")) {
            return AbilityUtils.doXMath(AbilityUtils.calculateAmount(c, (String)sq[player.isMonarch() ? 1 : 2], ctb), expr, c, ctb);
        }
        if (((String)sq[0]).equals("Initiative")) {
            return AbilityUtils.doXMath(AbilityUtils.calculateAmount(c, (String)sq[player.hasInitiative() ? 1 : 2], ctb), expr, c, ctb);
        }
        if (((String)sq[0]).equals("StartingPlayer")) {
            return AbilityUtils.doXMath(AbilityUtils.calculateAmount(c, (String)sq[player.isStartingPlayer() ? 1 : 2], ctb), expr, c, ctb);
        }
        if (((String)sq[0]).equals("Blessing")) {
            return AbilityUtils.doXMath(AbilityUtils.calculateAmount(c, (String)sq[player.hasBlessing() ? 1 : 2], ctb), expr, c, ctb);
        }
        if (((String)sq[0]).equals("Threshold")) {
            return AbilityUtils.doXMath(AbilityUtils.calculateAmount(c, (String)sq[player.hasThreshold() ? 1 : 2], ctb), expr, c, ctb);
        }
        if (((String)sq[0]).equals("CommittedCrimeThisTurn")) {
            return AbilityUtils.doXMath(AbilityUtils.calculateAmount(c, (String)sq[player.getCommittedCrimeThisTurn() > 0 ? 1 : 2], ctb), expr, c, ctb);
        }
        if (((String)sq[0]).equals("ExtraTurn")) {
            return AbilityUtils.doXMath(AbilityUtils.calculateAmount(c, (String)sq[game.getPhaseHandler().getPlayerTurn().isExtraTurn() ? 1 : 2], ctb), expr, c, ctb);
        }
        if (((String)sq[0]).equals("Averna")) {
            String str = "As you cascade, you may put a land card from among the exiled cards onto the battlefield tapped.";
            return AbilityUtils.doXMath(player.getKeywords().getAmount(str), expr, c, ctb);
        }
        if (((String)sq[0]).equals("YourStartingLife")) {
            return AbilityUtils.doXMath(player.getStartingLife(), expr, c, ctb);
        }
        if (((String)sq[0]).equals("YourLifeTotal")) {
            return AbilityUtils.doXMath(player.getLife(), expr, c, ctb);
        }
        if (((String)sq[0]).equals("OppGreatestLifeTotal")) {
            return AbilityUtils.doXMath(player.getOpponentsGreatestLifeTotal(), expr, c, ctb);
        }
        if (((String)sq[0]).equals("YouDrewThisTurn")) {
            return AbilityUtils.doXMath(player.getNumDrawnThisTurn(), expr, c, ctb);
        }
        if (((String)sq[0]).equals("YouDrewLastTurn")) {
            return AbilityUtils.doXMath(player.getNumDrawnLastTurn(), expr, c, ctb);
        }
        if (((String)sq[0]).equals("YouRollThisTurn")) {
            return AbilityUtils.doXMath(player.getNumRollsThisTurn(), expr, c, ctb);
        }
        if (((String)sq[0]).equals("YouSurveilThisTurn")) {
            return AbilityUtils.doXMath(player.getSurveilThisTurn(), expr, c, ctb);
        }
        if (((String)sq[0]).equals("YouDescendedThisTurn")) {
            return AbilityUtils.doXMath(player.getDescended(), expr, c, ctb);
        }
        if (((String)sq[0]).equals("YouCastThisGame")) {
            return AbilityUtils.doXMath(player.getSpellsCastThisGame(), expr, c, ctb);
        }
        if (((String)sq[0]).equals("Night")) {
            return AbilityUtils.doXMath(AbilityUtils.calculateAmount(c, (String)sq[game.isNight() ? 1 : 2], ctb), expr, c, ctb);
        }
        if (((String)sq[0]).equals("NumPiledGuessedSA")) {
            return AbilityUtils.doXMath(game.getNumPiledGuessedSA(), expr, c, ctb);
        }
        if (((String)sq[0]).startsWith("CommanderCastFromCommandZone")) {
            return AbilityUtils.doXMath(player.getCommanderCast(c), expr, c, ctb);
        }
        if (l[0].startsWith("TotalCommanderCastFromCommandZone")) {
            return AbilityUtils.doXMath(player.getTotalCommanderCast(), expr, c, ctb);
        }
        if (((String)sq[0]).contains("LifeYouLostThisTurn")) {
            return AbilityUtils.doXMath(player.getLifeLostThisTurn(), expr, c, ctb);
        }
        if (((String)sq[0]).contains("LifeYouGainedThisTurn")) {
            return AbilityUtils.doXMath(player.getLifeGainedThisTurn(), expr, c, ctb);
        }
        if (((String)sq[0]).contains("LifeYourTeamGainedThisTurn")) {
            return AbilityUtils.doXMath(player.getLifeGainedByTeamThisTurn(), expr, c, ctb);
        }
        if (((String)sq[0]).contains("LifeYouGainedTimesThisTurn")) {
            return AbilityUtils.doXMath(player.getLifeGainedTimesThisTurn(), expr, c, ctb);
        }
        if (((String)sq[0]).contains("LifeOppsLostThisTurn")) {
            return AbilityUtils.doXMath(player.getOpponentLostLifeThisTurn(), expr, c, ctb);
        }
        if (((String)sq[0]).equals("BloodthirstAmount")) {
            return AbilityUtils.doXMath(player.getBloodthirstAmount(), expr, c, ctb);
        }
        if (((String)sq[0]).startsWith("YourCounters")) {
            String counterType = ((String)sq[0]).substring(12);
            return AbilityUtils.doXMath(player.getCounters(CounterType.getType(counterType)), expr, c, ctb);
        }
        if (((String)sq[0]).contains("TotalOppPoisonCounters")) {
            return AbilityUtils.doXMath(player.getOpponentsTotalPoisonCounters(), expr, c, ctb);
        }
        if (((String)sq[0]).equals("TotalDamageDoneByThisTurn")) {
            return AbilityUtils.doXMath(c.getTotalDamageDoneBy(), expr, c, ctb);
        }
        if (((String)sq[0]).equals("TotalDamageReceivedThisTurn")) {
            return AbilityUtils.doXMath(c.getAssignedDamage(), expr, c, ctb);
        }
        if (((String)sq[0]).equals("ExcessDamageReceivedThisTurn")) {
            return AbilityUtils.doXMath(c.getExcessDamageThisTurn(), expr, c, ctb);
        }
        if (((String)sq[0]).equals("MaxOppDamageThisTurn")) {
            return AbilityUtils.doXMath(player.getMaxOpponentAssignedDamage(), expr, c, ctb);
        }
        if (((String)sq[0]).contains("TotalDamageThisTurn")) {
            props = l[0].split(" ");
            int sum = 0;
            for (Pair<Integer, Boolean> p : c.getDamageReceivedThisTurn()) {
                if (!game.getDamageLKI(p).getLeft().isValid(props[1], player, c, ctb)) continue;
                sum += p.getLeft().intValue();
            }
            return AbilityUtils.doXMath(sum, expr, c, ctb);
        }
        if (((String)sq[0]).contains("DamageThisTurn")) {
            void var13_121;
            List<Integer> dmgInstances;
            props = l[0].split(" ");
            Boolean isCombat = null;
            if (((String)sq[0]).contains("CombatDamage")) {
                isCombat = !((String)sq[0]).contains("Non");
            }
            if (!(dmgInstances = game.getDamageDoneThisTurn(isCombat, false, props[1], props[2], c, player, ctb)).isEmpty() && ((String)sq[0]).contains("Max")) {
                int n = Collections.max(dmgInstances);
            } else if (((String)sq[0]).startsWith("Num")) {
                int n = dmgInstances.size();
            } else {
                int n = Aggregates.sum(dmgInstances, Functions.identity());
            }
            return AbilityUtils.doXMath((int)var13_121, expr, c, ctb);
        }
        if (((String)sq[0]).equals("YourTurns")) {
            return AbilityUtils.doXMath(player.getTurn(), expr, c, ctb);
        }
        if (((String)sq[0]).equals("NotedNumber")) {
            return AbilityUtils.doXMath(player.getNotedNumberForName(c.getName()), expr, c, ctb);
        }
        if (((String)sq[0]).equals("DraftNotesHighest")) {
            note = player.getDraftNotes().getOrDefault(sq[1], "0");
            int highest = 0;
            for (String n : note.split(",")) {
                int num = Integer.parseInt(n);
                if (num <= highest) continue;
                highest = num;
            }
            return AbilityUtils.doXMath(highest, expr, c, ctb);
        }
        if (((String)sq[0]).equals("DraftNotesCount")) {
            note = player.getDraftNotes().getOrDefault(sq[1], null);
            if (note == null) {
                return 0;
            }
            int highest = note.split(";").length;
            return AbilityUtils.doXMath(highest, expr, c, ctb);
        }
        if (((String)sq[0]).startsWith("TypesSharedWith")) {
            HashSet<CardType.CoreType> thisTypes = Sets.newHashSet(c.getType().getCoreTypes());
            HashSet<CardType.CoreType> matches = new HashSet<CardType.CoreType>();
            for (Card c1 : AbilityUtils.getDefinedCards(ctb.getHostCard(), l[0].split(" ", 2)[1], ctb)) {
                for (CardType.CoreType type : Sets.newHashSet(c1.getType().getCoreTypes())) {
                    if (!thisTypes.contains((Object)type)) continue;
                    matches.add(type);
                }
            }
            return matches.size();
        }
        if (((String)sq[0]).equals("TopOfLibraryCMC")) {
            int cmc = player.getCardsIn(ZoneType.Library).isEmpty() ? 0 : ((Card)player.getCardsIn(ZoneType.Library).getFirst()).getCMC();
            return AbilityUtils.doXMath(cmc, expr, c, ctb);
        }
        if (((String)sq[0]).startsWith("AttackersDeclared")) {
            List<Card> attackers = player.getCreaturesAttackedThisTurn();
            ArrayList<Card> differentAttackers = new ArrayList<Card>();
            for (Card attacker : attackers) {
                boolean add = true;
                for (Card different : differentAttackers) {
                    if (!different.equalsWithGameTimestamp(attacker)) continue;
                    add = false;
                    break;
                }
                if (!add) continue;
                differentAttackers.add(attacker);
            }
            return AbilityUtils.doXMath(differentAttackers.size(), expr, c, ctb);
        }
        if (((String)sq[0]).startsWith("CreaturesAttackedThisTurn")) {
            workingCopy = l[0].split(" ", 2);
            validFilter = workingCopy[1];
            return AbilityUtils.doXMath(CardLists.getValidCardCount(player.getCreaturesAttackedThisTurn(), validFilter, player, c, ctb), expr, c, ctb);
        }
        if (((String)sq[0]).startsWith("LeftBattlefieldThisTurn")) {
            workingCopy = l[0].split(" ", 2);
            validFilter = workingCopy[1];
            return AbilityUtils.doXMath(CardLists.getValidCardCount(game.getLeftBattlefieldThisTurn(), validFilter, player, c, ctb), expr, c, ctb);
        }
        if (((String)sq[0]).startsWith("LeftGraveyardThisTurn")) {
            workingCopy = l[0].split(" ", 2);
            validFilter = workingCopy[1];
            return AbilityUtils.doXMath(CardLists.getValidCardCount(game.getLeftGraveyardThisTurn(), validFilter, player, c, ctb), expr, c, ctb);
        }
        if (((String)sq[0]).startsWith("UnlockedDoors")) {
            void var13_126;
            workingCopy = l[0].split(" ", 2);
            validFilter = workingCopy[1];
            boolean bl = false;
            for (Card doorCard : CardLists.getValidCards((Iterable<Card>)player.getCardsIn(ZoneType.Battlefield), validFilter, player, c, ctb)) {
                var13_126 += doorCard.getUnlockedRooms().size();
            }
            return AbilityUtils.doXMath((int)var13_126, expr, c, ctb);
        }
        if (((String)sq[0]).startsWith("DistinctUnlockedDoors")) {
            workingCopy = l[0].split(" ", 2);
            validFilter = workingCopy[1];
            HashSet<String> hashSet = new HashSet<String>();
            for (Card doorCard : CardLists.getValidCards((Iterable<Card>)player.getCardsIn(ZoneType.Battlefield), validFilter, player, c, ctb)) {
                for (CardStateName stateName : doorCard.getUnlockedRooms()) {
                    hashSet.add(doorCard.getState(stateName).getName());
                }
            }
            int distinctUnlocked = hashSet.size();
            return AbilityUtils.doXMath(distinctUnlocked, expr, c, ctb);
        }
        if (((String)sq[0]).startsWith("ManaPool")) {
            String color = l[0].split(":")[1];
            int v = 0;
            v = color.equals("All") ? player.getManaPool().totalMana() : player.getManaPool().getAmountOfColor(ManaAtom.fromName(color));
            return AbilityUtils.doXMath(v, expr, c, ctb);
        }
        if (((String)sq[0]).startsWith("Domain")) {
            int n = 0;
            Player neededPlayer = ((String)sq[0]).equals("DomainActivePlayer") ? game.getPhaseHandler().getPlayerTurn() : player;
            CardCollection cardCollection = neededPlayer.getLandsInPlay();
            for (String basic : MagicColor.Constant.BASIC_LANDS) {
                if (CardLists.getType(cardCollection, basic).isEmpty()) continue;
                ++n;
            }
            return AbilityUtils.doXMath(n, expr, c, ctb);
        }
        if (((String)sq[0]).contains("AbilityYouCtrl")) {
            CardCollection all = CardLists.getValidCards((Iterable<Card>)player.getCardsIn(ZoneType.Battlefield), "Creature", player, c, ctb);
            int count = 0;
            for (String ab : ((String)sq[0]).substring(15).split(",")) {
                CardCollection found = CardLists.getValidCards((Iterable<Card>)all, "Creature.with" + ab, player, c, ctb);
                if (found.isEmpty()) continue;
                ++count;
            }
            return AbilityUtils.doXMath(count, expr, c, ctb);
        }
        if (((String)sq[0]).contains("Party")) {
            int n;
            CardCollection adventurers = CardLists.getValidCards((Iterable<Card>)player.getCardsIn(ZoneType.Battlefield), "Creature.Cleric,Creature.Rogue,Creature.Warrior,Creature.Wizard", player, c, ctb);
            HashSet<String> partyTypes = Sets.newHashSet("Cleric", "Rogue", "Warrior", "Wizard");
            boolean bl = false;
            HashMap<String, Card> chosenParty = new HashMap<String, Card>();
            ArrayList<Card> wildcard = Lists.newArrayList();
            HashMap<Card, Set<String>> multityped = new HashMap<Card, Set<String>>();
            for (Card card : adventurers) {
                Set<String> creatureTypes = card.getType().getCreatureTypes();
                creatureTypes.retainAll(partyTypes);
                if (creatureTypes.size() == 4) {
                    wildcard.add(card);
                    if (wildcard.size() < 4) continue;
                    break;
                }
                if (creatureTypes.size() == 1) {
                    String type = (String)creatureTypes.toArray()[0];
                    if (chosenParty.containsKey(type)) continue;
                    chosenParty.put(type, card);
                    continue;
                }
                multityped.put(card, creatureTypes);
            }
            if ((n = Math.min(chosenParty.size() + wildcard.size(), 4)) < 4) {
                partyTypes.removeAll(chosenParty.keySet());
                for (Card multi : multityped.keySet()) {
                    Set types = (Set)multityped.get(multi);
                    types.retainAll(partyTypes);
                    Iterator iterator = types.iterator();
                    if (!iterator.hasNext()) continue;
                    String type = (String)iterator.next();
                    chosenParty.put(type, multi);
                    partyTypes.remove(type);
                }
            }
            int n2 = Math.min(chosenParty.size() + wildcard.size(), 4);
            return AbilityUtils.doXMath(n2, expr, c, ctb);
        }
        if (((String)sq[0]).startsWith("UniqueManaColorsProduced")) {
            boolean untappedOnly = ((String)sq[1]).contains("ByUntappedSources");
            int uniqueColors = 0;
            CardCollectionView cardCollectionView = player.getCardsIn(ZoneType.Battlefield);
            block29: for (byte color : MagicColor.WUBRG) {
                for (Card card : cardCollectionView) {
                    if (card.isTapped() && untappedOnly) continue;
                    for (SpellAbility ma : card.getManaAbilities()) {
                        if (!ma.canProduce(MagicColor.toShortString(color))) continue;
                        ++uniqueColors;
                        continue block29;
                    }
                }
            }
            return AbilityUtils.doXMath(uniqueColors, expr, c, ctb);
        }
        if (((String)sq[0]).contains("xColorPaid")) {
            void var13_135;
            String[] attrs = ((String)sq[0]).split(" ");
            StringBuilder colors = new StringBuilder();
            boolean bl = true;
            while (var13_135 < attrs.length) {
                colors.append(attrs[var13_135]);
                ++var13_135;
            }
            return AbilityUtils.doXMath(c.getXManaCostPaidCount(colors.toString()), expr, c, ctb);
        }
        if (((String)sq[0]).startsWith("UrzaLands")) {
            return AbilityUtils.doXMath(AbilityUtils.calculateAmount(c, (String)sq[player.hasUrzaLands() ? 1 : 2], ctb), expr, c, ctb);
        }
        if (((String)sq[0]).startsWith("Morbid")) {
            List<Card> res = CardUtil.getThisTurnEntered(ZoneType.Graveyard, ZoneType.Battlefield, "Creature", c, ctb, player);
            return AbilityUtils.doXMath(AbilityUtils.calculateAmount(c, (String)sq[res.size() > 0 ? 1 : 2], ctb), expr, c, ctb);
        }
        if (((String)sq[0]).startsWith("CreatureType")) {
            sqparts = l[0].split(" ", 2);
            rest = sqparts[1].split(",");
            CardCollectionView cardCollectionView = sqparts[0].length() > 12 ? game.getCardsIn(ZoneType.listValueOf(sqparts[0].substring(12))) : game.getCardsIn(ZoneType.Battlefield);
            CardCollection cards2 = CardLists.getValidCards((Iterable<Card>)cardCollectionView, rest, player, c, ctb);
            HashSet creatTypes = Sets.newHashSet();
            for (Card card : cards2) {
                Iterables.addAll(creatTypes, card.getType().getCreatureTypes());
            }
            return AbilityUtils.doXMath(creatTypes.size(), expr, c, ctb);
        }
        if (((String)sq[0]).startsWith("Chroma")) {
            if (((String)sq[0]).contains("ChromaSource")) {
                cards = new CardCollection(c);
            } else {
                ZoneType sourceZone = ((String)sq[0]).contains("ChromaInGrave") ? ZoneType.Graveyard : ZoneType.Battlefield;
                cards = player.getCardsIn(sourceZone);
            }
            int colorOcurrencices = 0;
            if (sq.length > 1) {
                byte by = ManaAtom.fromName((String)sq[1]);
            } else {
                int n = 31;
            }
            for (Card c0 : cards) {
                for (ManaCostShard sh : c0.getManaCost()) {
                    void var13_139;
                    if (!sh.isColor((byte)var13_139)) continue;
                    ++colorOcurrencices;
                }
            }
            return AbilityUtils.doXMath(colorOcurrencices, expr, c, ctb);
        }
        if (l[0].contains("ExactManaCost")) {
            sqparts = l[0].split(" ", 2);
            rest = sqparts[1].split(",");
            CardCollectionView cardCollectionView = sqparts[0].length() > 13 ? game.getCardsIn(ZoneType.listValueOf(sqparts[0].substring(13))) : game.getCardsIn(ZoneType.Battlefield);
            CardCollection cards3 = CardLists.getValidCards((Iterable<Card>)cardCollectionView, rest, player, c, ctb);
            HashSet<String> manaCost = Sets.newHashSet();
            for (Card card : cards3) {
                manaCost.add(card.getManaCost().getShortString());
            }
            return AbilityUtils.doXMath(manaCost.size(), expr, c, ctb);
        }
        if (((String)sq[0]).equals("StormCount")) {
            return AbilityUtils.doXMath(game.getStack().getSpellsCastThisTurn().size() - 1, expr, c, ctb);
        }
        if (((String)sq[0]).equals("FinalChapterNr")) {
            return AbilityUtils.doXMath(c.getFinalChapterNr(), expr, c, ctb);
        }
        if (((String)sq[0]).startsWith("PlanarDiceSpecialActionThisTurn")) {
            return game.getPhaseHandler().getPlanarDiceSpecialActionThisTurn();
        }
        if (((String)sq[0]).equals("AllTypes")) {
            cards = AbilityUtils.getDefinedCards(c, (String)sq[1], ctb);
            int amount = AbilityUtils.countCardTypesFromList(cards, false) + AbilityUtils.countSuperTypesFromList(cards) + AbilityUtils.countSubTypesFromList(cards);
            return AbilityUtils.doXMath(amount, expr, c, ctb);
        }
        if (((String)sq[0]).equals("TotalTurns")) {
            return AbilityUtils.doXMath(game.getPhaseHandler().getTurn(), expr, c, ctb);
        }
        if (((String)sq[0]).equals("MaxDistinctOnStack")) {
            return AbilityUtils.doXMath(game.getStack().getMaxDistinctSources(), expr, c, ctb);
        }
        if (((String)sq[0]).equals("MaxSameStoredRolls")) {
            int max = 0;
            List<Integer> rolls = c.getStoredRolls();
            if (rolls != null) {
                boolean bl = false;
                for (Integer roll : rolls) {
                    int n;
                    if (roll.equals(n)) continue;
                    int tally = Collections.frequency(rolls, roll);
                    if (tally > max) {
                        max = tally;
                    }
                    n = roll;
                }
            }
            return AbilityUtils.doXMath(max, expr, c, ctb);
        }
        if (((String)sq[0]).equals("Random")) {
            int min2 = AbilityUtils.calculateAmount(c, (String)sq[1], ctb);
            int max = AbilityUtils.calculateAmount(c, (String)sq[2], ctb);
            return MyRandom.getRandom().nextInt(1 + max - min2) + min2;
        }
        if (((String)sq[0]).startsWith("ThisTurnCast") || ((String)sq[0]).startsWith("LastTurnCast") || ((String)sq[0]).startsWith("CastSince")) {
            workingCopy = paidparts[0].split("_");
            validFilter = workingCopy[1];
            someCards = workingCopy[0].contains("This") ? CardUtil.getThisTurnCast(validFilter, c, ctb, player) : (workingCopy[0].contains("SinceBeginningOfYourLastTurn") ? CardUtil.getCastSinceBeginningOfYourLastTurn(validFilter, c, ctb, player) : CardUtil.getLastTurnCast(validFilter, c, ctb, player));
        }
        if (((String)sq[0]).startsWith("ThisTurnActivated")) {
            workingCopy = paidparts[0].split("_");
            validFilter = workingCopy[1];
            return CardUtil.getThisTurnActivated(validFilter, c, ctb, player).size();
        }
        if (((String)sq[0]).startsWith("ThisTurnEntered") || ((String)sq[0]).startsWith("LastTurnEntered")) {
            workingCopy = paidparts[0].split("_", 5);
            ZoneType destination = ZoneType.smartValueOf(workingCopy[1]);
            boolean bl = workingCopy[2].equals("from");
            ZoneType origin = bl ? ZoneType.smartValueOf(workingCopy[3]) : null;
            String validFilter2 = workingCopy[bl ? 4 : 2];
            someCards = workingCopy[0].contains("This") ? CardUtil.getThisTurnEntered(destination, origin, validFilter2, c, ctb, player) : CardUtil.getLastTurnEntered(destination, origin, validFilter2, c, ctb, player);
        }
        if (((String)sq[0]).startsWith("CountersAddedThisTurn")) {
            parts = l[0].split(" ");
            cType = CounterType.getType(parts[1]);
            return AbilityUtils.doXMath(game.getCounterAddedThisTurn(cType, parts[2], parts[3], c, player, ctb), expr, c, ctb);
        }
        if (((String)sq[0]).startsWith("CountersRemovedThisTurn")) {
            parts = l[0].split(" ");
            cType = CounterType.getType(parts[1]);
            return AbilityUtils.doXMath(game.getCounterRemovedThisTurn(cType, parts[2], c, player, ctb), expr, c, ctb);
        }
        if (((String)sq[0]).startsWith("MostCardName")) {
            lparts = l[0].split(" ", 2);
            rest = lparts[1].split(",");
            CardCollectionView cardCollectionView = lparts[0].length() > 12 ? game.getCardsIn(ZoneType.listValueOf(lparts[0].substring(12))) : game.getCardsIn(ZoneType.Battlefield);
            CardCollection cards4 = CardLists.getValidCards((Iterable<Card>)cardCollectionView, rest, player, c, ctb);
            HashMap<String, Integer> map = Maps.newHashMap();
            for (Card card : cards4) {
                String name;
                Integer count = (Integer)map.get(name = card.getName());
                map.put(name, count == null ? 1 : count + 1);
            }
            int max = 0;
            for (Map.Entry entry : map.entrySet()) {
                if (max >= (Integer)entry.getValue()) continue;
                max = (Integer)entry.getValue();
            }
            return max;
        }
        if (((String)sq[0]).startsWith("DifferentCardNames_")) {
            ArrayList<String> crdname = Lists.newArrayList();
            String restriction2 = l[0].substring(19);
            CardCollection cardCollection = CardLists.getValidCards((Iterable<Card>)game.getCardsInGame(), restriction2, player, c, ctb);
            for (Card card : cardCollection) {
                String name = card.getName();
                if (crdname.contains(name) || name.isEmpty()) continue;
                crdname.add(name);
            }
            return AbilityUtils.doXMath(crdname.size(), expr, c, ctb);
        }
        if (((String)sq[0]).startsWith("MostProminentCreatureType")) {
            restriction = l[0].split(" ")[1];
            list = CardLists.getValidCards((Iterable<Card>)game.getCardsIn(ZoneType.Battlefield), restriction, player, c, ctb);
            return AbilityUtils.doXMath(CardFactoryUtil.getMostProminentCreatureTypeSize(list), expr, c, ctb);
        }
        if (((String)sq[0]).startsWith("SecondMostProminentColor")) {
            restriction = l[0].split(" ")[1];
            list = CardLists.getValidCards((Iterable<Card>)game.getCardsIn(ZoneType.Battlefield), restriction, player, c, ctb);
            int[] nArray = CardFactoryUtil.SortColorsFromList(list);
            return AbilityUtils.doXMath(nArray[nArray.length - 2], expr, c, ctb);
        }
        if (((String)sq[0]).startsWith("ColorsCtrl")) {
            restriction = l[0].substring(11);
            list = CardLists.getValidCards((Iterable<Card>)player.getCardsIn(ZoneType.Battlefield), restriction, player, c, ctb);
            return AbilityUtils.doXMath(CardUtil.getColorsFromCards(list).countColors(), expr, c, ctb);
        }
        if (((String)sq[0]).startsWith("ColorsDefined")) {
            restriction = l[0].substring(14);
            list = AbilityUtils.getDefinedCards(c, restriction, ctb);
            return AbilityUtils.doXMath(CardUtil.getColorsFromCards(list).countColors(), expr, c, ctb);
        }
        if (((String)sq[0]).startsWith("SumPower")) {
            String[] restrictions = l[0].split("_");
            CardCollection filteredCards = CardLists.getValidCards((Iterable<Card>)game.getCardsIn(ZoneType.Battlefield), restrictions[1], player, c, ctb);
            return AbilityUtils.doXMath(Aggregates.sum(filteredCards, Card::getNetPower), expr, c, ctb);
        }
        if (((String)sq[0]).startsWith("DifferentPower_")) {
            restriction = l[0].substring(15);
            list = CardLists.getValidCards((Iterable<Card>)game.getCardsIn(ZoneType.Battlefield), restriction, player, c, ctb);
            Iterable<Card> iterable = Aggregates.uniqueByLast(list, Card::getNetPower);
            return AbilityUtils.doXMath(Iterables.size(iterable), expr, c, ctb);
        }
        if (((String)sq[0]).startsWith("DifferentCounterKinds_")) {
            HashSet<CounterType> kinds = Sets.newHashSet();
            rest = l[0].substring(22);
            CardCollection cardCollection = CardLists.getValidCards((Iterable<Card>)game.getCardsIn(ZoneType.Battlefield), (String)rest, player, c, ctb);
            for (Card card : cardCollection) {
                kinds.addAll(card.getCounters().keySet());
            }
            return AbilityUtils.doXMath(kinds.size(), expr, c, ctb);
        }
        Integer num = null;
        if (someCards == null) {
            someCards = AbilityUtils.getCardListForXCount(c, player, (String[])sq, ctb);
        } else if (paidparts.length > 1) {
            num = AbilityUtils.handlePaid(someCards, paidparts[1], c, ctb);
        }
        if (num == null) {
            num = Iterables.size(someCards);
        }
        return AbilityUtils.doXMath(num, expr, c, ctb);
    }

    public static final void applyManaColorConversion(ManaConversionMatrix matrix, String conversion) {
        String[] stringArray = conversion.split(" ");
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String pair;
            boolean additive = (pair = stringArray[i]).contains("->");
            String[] sides = pair.split(additive ? "->" : "<-");
            byte replacedColor = ManaAtom.fromConversion(sides[1]);
            if (sides[0].equals("AnyColor") || sides[0].equals("AnyType")) {
                for (byte c : sides[0].equals("AnyColor") ? MagicColor.WUBRG : MagicColor.WUBRGC) {
                    matrix.adjustColorReplacement(c, replacedColor, additive);
                }
                continue;
            }
            if (sides[0].startsWith("non")) {
                byte originalColor = ManaAtom.fromConversion(sides[0]);
                for (byte b : ManaAtom.MANATYPES) {
                    if ((originalColor & b) == 0) continue;
                    matrix.adjustColorReplacement(b, replacedColor, additive);
                }
                continue;
            }
            matrix.adjustColorReplacement(ManaAtom.fromConversion(sides[0]), replacedColor, additive);
        }
    }

    public static final List<SpellAbility> getBasicSpellsFromPlayEffect(Card tgtCard, Player controller) {
        return AbilityUtils.getSpellsFromPlayEffect(tgtCard, controller, CardStateName.Original, false);
    }

    public static final List<SpellAbility> getSpellsFromPlayEffect(Card tgtCard, Player controller, CardStateName state, boolean withAltCost) {
        ArrayList<SpellAbility> sas = new ArrayList<SpellAbility>();
        ArrayList<SpellAbility> list = new ArrayList<SpellAbility>();
        AbilityUtils.collectSpellsForPlayEffect(list, tgtCard.getState(tgtCard.getCurrentStateName()), controller, withAltCost);
        CardState original = tgtCard.getState(state);
        if (tgtCard.isFaceDown()) {
            AbilityUtils.collectSpellsForPlayEffect(list, original, controller, withAltCost);
        } else {
            if (state == CardStateName.Transformed && tgtCard.isPermanent() && !tgtCard.isAura()) {
                SpellPermanent sp = new SpellPermanent(tgtCard, original);
                sp.setCardState(original);
                list.add(sp);
            }
            if (tgtCard.isModal()) {
                AbilityUtils.collectSpellsForPlayEffect(list, tgtCard.getState(CardStateName.Modal), controller, withAltCost);
            }
        }
        for (SpellAbility s2 : list) {
            if (s2.isLandAbility()) {
                s2.setActivatingPlayer(controller);
                if (!controller.getGame().getPhaseHandler().isPlayerTurn(controller) || !controller.canPlayLand(tgtCard, true, s2)) continue;
                sas.add(s2);
                continue;
            }
            Spell newSA = (Spell)s2.copy(controller);
            SpellAbilityRestriction res = new SpellAbilityRestriction();
            res.setPlayerTurn(s2.getRestrictions().getPlayerTurn());
            res.setOpponentTurn(s2.getRestrictions().getOpponentTurn());
            res.setPhases(s2.getRestrictions().getPhases());
            res.setZone(null);
            newSA.setRestrictions(res);
            if (!res.checkTimingRestrictions(tgtCard, newSA) || !res.checkOtherRestrictions(tgtCard, newSA, controller)) continue;
            newSA.setCastFromPlayEffect(true);
            sas.add(newSA);
        }
        return sas;
    }

    private static void collectSpellsForPlayEffect(List<SpellAbility> result, CardState state, Player controller, boolean withAltCost) {
        if (state.getType().isLand()) {
            result.add(state.getFirstSpellAbility());
        }
        FCollectionView<SpellAbility> spells = state.getSpellAbilities();
        for (SpellAbility sa : spells) {
            if (!sa.isSpell() || !withAltCost && !sa.isBasicSpell()) continue;
            result.add(sa);
            if (!withAltCost) continue;
            result.addAll(GameActionUtil.getAlternativeCosts(sa, controller, true));
        }
    }

    public static final String applyAbilityTextChangeEffects(String def, CardTraitBase ability) {
        if (ability == null || !ability.isIntrinsic() || ability.hasParam("LockInText")) {
            return def;
        }
        return AbilityUtils.applyTextChangeEffects(def, ability.getHostCard(), false);
    }

    public static final String applyKeywordTextChangeEffects(String kw, Card card) {
        if (!CardUtil.isKeywordModifiable(kw)) {
            return kw;
        }
        return AbilityUtils.applyTextChangeEffects(kw, card, false);
    }

    public static final String applyDescriptionTextChangeEffects(String def, CardTraitBase ability) {
        if (ability == null || !ability.isIntrinsic() || ability.hasParam("LockInText")) {
            return def;
        }
        return AbilityUtils.applyTextChangeEffects(def, ability.getHostCard(), true);
    }

    public static final String applyDescriptionTextChangeEffects(String def, Card card) {
        return AbilityUtils.applyTextChangeEffects(def, card, true);
    }

    private static String applyTextChangeEffects(String def, Card card, boolean isDescriptive) {
        return AbilityUtils.applyTextChangeEffects(def, isDescriptive, card.getChangedTextColorWords(), card.getChangedTextTypeWords());
    }

    public static final String applyTextChangeEffects(String def, boolean isDescriptive, Map<String, String> colorMap, Map<String, String> typeMap) {
        String key;
        if (StringUtils.isEmpty(def)) {
            return def;
        }
        String replaced = def;
        for (Map.Entry<String, String> e : colorMap.entrySet()) {
            key = e.getKey();
            if (key.equals("Any")) {
                for (byte c : MagicColor.WUBRG) {
                    String colorLowerCase = MagicColor.toLongString(c).toLowerCase();
                    String colorCaptCase = StringUtils.capitalize(MagicColor.toLongString(c));
                    if (e.getValue().equalsIgnoreCase(colorLowerCase)) continue;
                    replaced = AbilityUtils.getReplacedText(replaced, colorLowerCase, e.getValue().toLowerCase(), isDescriptive);
                    replaced = AbilityUtils.getReplacedText(replaced, colorCaptCase, e.getValue(), isDescriptive);
                }
                continue;
            }
            replaced = AbilityUtils.getReplacedText(replaced, key.toLowerCase(), e.getValue().toLowerCase(), isDescriptive);
            replaced = AbilityUtils.getReplacedText(replaced, key, e.getValue(), isDescriptive);
        }
        for (Map.Entry<String, String> e : typeMap.entrySet()) {
            key = e.getKey();
            if (isDescriptive) {
                replaced = AbilityUtils.getReplacedText(replaced, CardType.getPluralType(key), CardType.getPluralType(e.getValue()), isDescriptive);
            }
            replaced = AbilityUtils.getReplacedText(replaced, key, e.getValue(), isDescriptive);
        }
        return replaced;
    }

    private static String getReplacedText(String text, String originalWord, String newWord, boolean isDescriptive) {
        if (isDescriptive) {
            newWord = "<strike>" + originalWord + "</strike> " + newWord;
        }
        return text.replaceAll((isDescriptive ? "(?<!>)" : "") + "(?<!named.{0,100})\\b(non)?" + originalWord, "$1" + newWord);
    }

    public static final String getSVar(CardTraitBase ability, String sVarName) {
        String val = ability.getSVar(sVarName);
        if (!ability.isIntrinsic() || StringUtils.isEmpty(val)) {
            return val;
        }
        return AbilityUtils.applyAbilityTextChangeEffects(val, ability);
    }

    private static void addPlayer(Iterable<?> objects, String def, FCollection<Player> players) {
        AbilityUtils.addPlayer(objects, def, players, false);
    }

    private static void addPlayer(Iterable<?> objects, String def, FCollection<Player> players, boolean skipRemembered) {
        for (Object o : objects) {
            GameObject c;
            if (o instanceof Player) {
                Player p = (Player)o;
                if (def.endsWith("Opponents")) {
                    players.addAll(p.getOpponents());
                    continue;
                }
                players.add(p);
                continue;
            }
            if (o instanceof Card) {
                c = (Card)o;
                if (def.endsWith("Controller")) {
                    players.add(((Card)c).getController());
                    continue;
                }
                if (def.endsWith("Owner")) {
                    players.add(((Card)c).getOwner());
                    continue;
                }
                if (!def.endsWith("Remembered") || skipRemembered) continue;
                AbilityUtils.addPlayer(((Card)c).getRemembered(), def, players, true);
                continue;
            }
            if (!(o instanceof SpellAbility)) continue;
            c = (SpellAbility)o;
            if (!def.endsWith("Controller")) continue;
            players.add(((CardTraitBase)c).getHostCard().getController());
        }
    }

    public static SpellAbility addSpliceEffects(SpellAbility sa) {
        Card source = sa.getHostCard();
        Player player = sa.getActivatingPlayer();
        if (!sa.isSpell() || source.isCopiedSpell()) {
            return sa;
        }
        CardCollectionView hand = player.getCardsIn(ZoneType.Hand);
        if (hand.isEmpty()) {
            return sa;
        }
        CardCollection splices = CardLists.filter((Iterable<Card>)hand, input -> {
            for (KeywordInterface inst : input.getKeywords(Keyword.SPLICE)) {
                String k = inst.getOriginal();
                String[] n = k.split(":");
                if (!source.isValid(n[1].split(","), player, (Card)input, (CardTraitBase)sa)) continue;
                return true;
            }
            return false;
        });
        splices.remove(source);
        if (splices.isEmpty()) {
            return sa;
        }
        List<Card> choosen = player.getController().chooseCardsForSplice(sa, splices);
        if (choosen.isEmpty()) {
            return sa;
        }
        SpellAbility newSA = sa.copy();
        for (Card c : choosen) {
            AbilityUtils.addSpliceEffect(newSA, c);
        }
        return newSA;
    }

    public static void addSpliceEffect(SpellAbility sa, Card c) {
        Cost spliceCost = null;
        for (KeywordInterface inst : c.getKeywords(Keyword.SPLICE)) {
            String k = inst.getOriginal();
            String[] n = k.split(":");
            spliceCost = new Cost(n[2], false);
        }
        if (spliceCost == null) {
            return;
        }
        SpellAbility firstSpell = c.getFirstSpellAbility();
        HashMap<String, String> params = Maps.newHashMap(firstSpell.getMapParams());
        ApiType api = AbilityFactory.AbilityRecordType.getRecordType(params).getApiTypeOf(params);
        AbilitySub subAbility = (AbilitySub)AbilityFactory.getAbility(AbilityFactory.AbilityRecordType.SubAbility, api, params, null, c.getCurrentState(), c.getCurrentState());
        subAbility.setActivatingPlayer(sa.getActivatingPlayer());
        subAbility.setHostCard(sa.getHostCard());
        sa.appendSubAbility(subAbility);
        sa.setBasicSpell(false);
        sa.setPayCosts(spliceCost.add(sa.getPayCosts()));
        sa.setDescription(sa.getDescription() + " (Splicing " + c + " onto it)");
        sa.addSplicedCards(c);
    }

    public static int doXMath(int num, String operators, Card c, CardTraitBase ctb) {
        if (operators == null || operators.equals("none")) {
            return num;
        }
        String[] s2 = operators.split("\\.");
        int secondaryNum = 0;
        try {
            if (s2.length == 2) {
                secondaryNum = Integer.parseInt(s2[1]);
            }
        }
        catch (Exception e) {
            secondaryNum = AbilityUtils.calculateAmount(c, s2[1], ctb);
        }
        if (s2[0].contains("Plus")) {
            return num + secondaryNum;
        }
        if (s2[0].contains("NMinus")) {
            return secondaryNum - num;
        }
        if (s2[0].contains("Minus")) {
            return num - secondaryNum;
        }
        if (s2[0].contains("Twice")) {
            return num * 2;
        }
        if (s2[0].contains("Thrice")) {
            return num * 3;
        }
        if (s2[0].contains("HalfUp")) {
            return (int)Math.ceil((double)num / 2.0);
        }
        if (s2[0].contains("HalfDown")) {
            return (int)Math.floor((double)num / 2.0);
        }
        if (s2[0].contains("ThirdUp")) {
            return (int)Math.ceil((double)num / 3.0);
        }
        if (s2[0].contains("ThirdDown")) {
            return (int)Math.floor((double)num / 3.0);
        }
        if (s2[0].contains("Negative")) {
            return num * -1;
        }
        if (s2[0].contains("Times")) {
            return num * secondaryNum;
        }
        if (s2[0].contains("DivideEvenlyUp")) {
            if (secondaryNum == 0) {
                return 0;
            }
            return num / secondaryNum + (num % secondaryNum == 0 ? 0 : 1);
        }
        if (s2[0].contains("DivideEvenlyDown")) {
            if (secondaryNum == 0) {
                return 0;
            }
            return num / secondaryNum;
        }
        if (s2[0].contains("Mod")) {
            return num % secondaryNum;
        }
        if (s2[0].contains("Abs")) {
            return Math.abs(num);
        }
        if (s2[0].contains("LimitMax")) {
            if (num < secondaryNum) {
                return num;
            }
            return secondaryNum;
        }
        if (s2[0].contains("LimitMin")) {
            if (num > secondaryNum) {
                return num;
            }
            return secondaryNum;
        }
        return num;
    }

    public static int playerXCount(List<Player> players, String s2, Card source, CardTraitBase ctb) {
        if (players.isEmpty()) {
            return 0;
        }
        String[] l = s2.split("/");
        String m4 = CardFactoryUtil.extractOperators(s2);
        Player controller = ctb instanceof SpellAbility ? ((SpellAbility)ctb).getActivatingPlayer() : source.getController();
        int n = 0;
        if (l[0].startsWith("TotalCommanderCastFromCommandZone")) {
            int totCast = 0;
            for (Player player : players) {
                totCast += player.getTotalCommanderCast();
            }
            return AbilityUtils.doXMath(totCast, m4, source, ctb);
        }
        if (l[0].startsWith("Highest")) {
            for (Player player : players) {
                int n2 = AbilityUtils.playerXProperty(player, TextUtil.fastReplace(s2, "Highest", ""), source, ctb);
                if (n2 <= n) continue;
                n = n2;
            }
            return AbilityUtils.doXMath(n, m4, source, ctb);
        }
        if (l[0].startsWith("Lowest")) {
            n = 99999;
            for (Player player : players) {
                int n3 = AbilityUtils.playerXProperty(player, TextUtil.fastReplace(s2, "Lowest", ""), source, ctb);
                if (n3 >= n) continue;
                n = n3;
            }
            return AbilityUtils.doXMath(n, m4, source, ctb);
        }
        if (l[0].startsWith("TiedForHighestLife")) {
            int maxLife = Integer.MIN_VALUE;
            for (Player player : players) {
                int highestTotal = AbilityUtils.playerXProperty(player, "LifeTotal", source, ctb);
                if (highestTotal <= maxLife) continue;
                maxLife = highestTotal;
            }
            int numTied = 0;
            for (Player player : players) {
                if (player.getLife() != maxLife) continue;
                ++numTied;
            }
            return AbilityUtils.doXMath(numTied, m4, source, ctb);
        }
        if (l[0].startsWith("TiedForLowestLife")) {
            int minLife = Integer.MAX_VALUE;
            for (Player player : players) {
                int lowestTotal = AbilityUtils.playerXProperty(player, "LifeTotal", source, ctb);
                if (lowestTotal >= minLife) continue;
                minLife = lowestTotal;
            }
            int numTied = 0;
            for (Player player : players) {
                if (player.getLife() != minLife) continue;
                ++numTied;
            }
            return AbilityUtils.doXMath(numTied, m4, source, ctb);
        }
        String[] sq = l[0].split("\\.");
        if (sq[0].equals("Amount")) {
            return AbilityUtils.doXMath(players.size(), m4, source, ctb);
        }
        if (sq[0].startsWith("HasProperty")) {
            int totPlayer = 0;
            String string = sq[0].substring(11);
            for (Player p : players) {
                if (!p.hasProperty(string, controller, source, ctb)) continue;
                ++totPlayer;
            }
            return AbilityUtils.doXMath(totPlayer, m4, source, ctb);
        }
        if (l[0].startsWith("Condition")) {
            int totPlayer = 0;
            String[] stringArray = l[0].split(" ", 2);
            boolean def = stringArray[0].equals("Condition");
            String comparator = !def ? stringArray[0].substring(9, 11) : "GE";
            int y = !def ? AbilityUtils.calculateAmount(source, stringArray[0].substring(11), ctb) : 1;
            for (Player p : players) {
                int x = AbilityUtils.playerXProperty(p, stringArray[1], source, ctb);
                if (!Expressions.compare(x, comparator, y)) continue;
                ++totPlayer;
            }
            return AbilityUtils.doXMath(totPlayer, m4, source, ctb);
        }
        if (sq[0].contains("DamageThisTurn")) {
            int totDmg = 0;
            for (Player p : players) {
                totDmg += p.getAssignedDamage();
            }
            return AbilityUtils.doXMath(totDmg, m4, source, ctb);
        }
        if (players.size() > 0) {
            int totCount = 0;
            for (Player p : players) {
                totCount += AbilityUtils.playerXProperty(p, s2, source, ctb);
            }
            return totCount;
        }
        return AbilityUtils.doXMath(n, m4, source, ctb);
    }

    public static int playerXProperty(Player player, String s2, Card source, CardTraitBase ctb) {
        String[] l = s2.split("/");
        String m4 = CardFactoryUtil.extractOperators(s2);
        Game game = player.getGame();
        if (l[0].startsWith("Valid ")) {
            String restrictions = l[0].substring(6);
            int num = CardLists.getValidCardCount(game.getCardsIn(ZoneType.Battlefield), restrictions, player, source, ctb);
            return AbilityUtils.doXMath(num, m4, source, ctb);
        }
        if (l[0].startsWith("Valid")) {
            String[] lparts = l[0].split(" ", 2);
            List<ZoneType> vZone = ZoneType.listValueOf(lparts[0].split("Valid")[1]);
            String restrictions = TextUtil.fastReplace(l[0], TextUtil.addSuffix(lparts[0], " "), "");
            int num = CardLists.getValidCardCount(game.getCardsIn(vZone), restrictions, player, source, ctb);
            return AbilityUtils.doXMath(num, m4, source, ctb);
        }
        if (l[0].startsWith("ThisTurnEntered")) {
            String[] workingCopy = l[0].split("_");
            ZoneType destination = ZoneType.smartValueOf(workingCopy[1]);
            boolean hasFrom = workingCopy[2].equals("from");
            ZoneType origin = hasFrom ? ZoneType.smartValueOf(workingCopy[3]) : null;
            String validFilter = workingCopy[hasFrom ? 4 : 2];
            List<Card> res = CardUtil.getThisTurnEntered(destination, origin, validFilter, source, ctb, player);
            return AbilityUtils.doXMath(res.size(), m4, source, ctb);
        }
        if (l[0].startsWith("SacrificedThisTurn")) {
            List<Card> list = player.getSacrificedThisTurn();
            if (l[0].contains(" ")) {
                String[] lparts = l[0].split(" ", 2);
                String restrictions = TextUtil.fastReplace(l[0], TextUtil.addSuffix(lparts[0], " "), "");
                list = CardLists.getValidCardsAsList(list, restrictions, player, source, ctb);
            }
            return AbilityUtils.doXMath(list.size(), m4, source, ctb);
        }
        if (l[0].startsWith("SacrificedPermanentTypesThisTurn")) {
            return AbilityUtils.doXMath(AbilityUtils.countCardTypesFromList(player.getSacrificedThisTurn(), true), m4, source, ctb);
        }
        String[] sq = l[0].split("\\.");
        String value = sq[0];
        if (value.contains("NumPowerSurgeLands")) {
            return AbilityUtils.doXMath(player.getNumPowerSurgeLands(), m4, source, ctb);
        }
        if (value.contains("DomainPlayer")) {
            int n = 0;
            CardCollection someCards = player.getLandsInPlay();
            ImmutableList<String> basic = MagicColor.Constant.BASIC_LANDS;
            for (String type : basic) {
                if (CardLists.getType(someCards, type).isEmpty()) continue;
                ++n;
            }
            return AbilityUtils.doXMath(n, m4, source, ctb);
        }
        if (value.contains("CardsInHand")) {
            return AbilityUtils.doXMath(player.getCardsIn(ZoneType.Hand).size(), m4, source, ctb);
        }
        if (value.contains("CardsInLibrary")) {
            return AbilityUtils.doXMath(player.getCardsIn(ZoneType.Library).size(), m4, source, ctb);
        }
        if (value.contains("CardsInGraveyard")) {
            return AbilityUtils.doXMath(player.getCardsIn(ZoneType.Graveyard).size(), m4, source, ctb);
        }
        if (value.contains("LandsInGraveyard")) {
            return AbilityUtils.doXMath(CardLists.getType(player.getCardsIn(ZoneType.Graveyard), "Land").size(), m4, source, ctb);
        }
        if (value.contains("CardsInPlay")) {
            return AbilityUtils.doXMath(player.getCardsIn(ZoneType.Battlefield).size(), m4, source, ctb);
        }
        if (value.contains("CreaturesInPlay")) {
            return AbilityUtils.doXMath(player.getCreaturesInPlay().size(), m4, source, ctb);
        }
        if (value.contains("StartingLife")) {
            return AbilityUtils.doXMath(player.getStartingLife(), m4, source, ctb);
        }
        if (value.contains("LifeTotal")) {
            return AbilityUtils.doXMath(player.getLife(), m4, source, ctb);
        }
        if (value.contains("LifeLostThisTurn")) {
            return AbilityUtils.doXMath(player.getLifeLostThisTurn(), m4, source, ctb);
        }
        if (value.contains("LifeLostLastTurn")) {
            return AbilityUtils.doXMath(player.getLifeLostLastTurn(), m4, source, ctb);
        }
        if (value.contains("LifeGainedThisTurn")) {
            return AbilityUtils.doXMath(player.getLifeGainedThisTurn(), m4, source, ctb);
        }
        if (value.contains("LifeGainedByTeamThisTurn")) {
            return AbilityUtils.doXMath(player.getLifeGainedByTeamThisTurn(), m4, source, ctb);
        }
        if (value.contains("LifeStartedThisTurnWith")) {
            return AbilityUtils.doXMath(player.getLifeStartedThisTurnWith(), m4, source, ctb);
        }
        if (value.contains("SVarAmount")) {
            return AbilityUtils.doXMath(AbilityUtils.calculateAmount(source, ctb.getSVar(player.toString()), ctb), m4, source, ctb);
        }
        if (value.contains("Counters")) {
            int count = 0;
            count = sq[1].equals("ALL") ? Aggregates.sum(player.getCounters().values(), Functions.identity()) : player.getCounters(CounterType.getType(sq[1]));
            return AbilityUtils.doXMath(count, m4, source, ctb);
        }
        if (value.contains("TopOfLibraryCMC")) {
            return AbilityUtils.doXMath(Aggregates.sum(player.getCardsIn(ZoneType.Library, 1), Card::getCMC), m4, source, ctb);
        }
        if (value.contains("LandsPlayed")) {
            return AbilityUtils.doXMath(player.getLandsPlayedThisTurn(), m4, source, ctb);
        }
        if (value.contains("SpellsCastThisTurn")) {
            return AbilityUtils.doXMath(player.getSpellsCastThisTurn(), m4, source, ctb);
        }
        if (value.contains("CardsDrawn")) {
            return AbilityUtils.doXMath(player.getNumDrawnThisTurn(), m4, source, ctb);
        }
        if (value.contains("CardsDiscardedThisTurn")) {
            return AbilityUtils.doXMath(player.getDiscardedThisTurn().size(), m4, source, ctb);
        }
        if (value.contains("ExploredThisTurn")) {
            return AbilityUtils.doXMath(player.getNumExploredThisTurn(), m4, source, ctb);
        }
        if (value.contains("AttackersDeclared")) {
            return AbilityUtils.doXMath(player.getCreaturesAttackedThisTurn().size(), m4, source, ctb);
        }
        if (value.contains("DamageToOppsThisTurn")) {
            return AbilityUtils.doXMath(player.getOpponentsAssignedDamage(), m4, source, ctb);
        }
        if (value.contains("NonCombatDamageDealtThisTurn")) {
            return AbilityUtils.doXMath(player.getAssignedDamage() - player.getAssignedCombatDamage(), m4, source, ctb);
        }
        if (value.equals("OpponentsAttackedThisTurn")) {
            Iterable<Player> opps = player.getAttackedPlayersMyTurn();
            return AbilityUtils.doXMath(opps == null ? 0 : Iterables.size(opps), m4, source, ctb);
        }
        if (value.equals("OpponentsAttackedThisCombat")) {
            int amount = game.getCombat() == null ? 0 : game.getCombat().getAttackedOpponents(player).size();
            return AbilityUtils.doXMath(amount, m4, source, ctb);
        }
        if (value.equals("BeenDealtCombatDamageSinceLastTurn")) {
            return AbilityUtils.doXMath(player.hasBeenDealtCombatDamageSinceLastTurn() ? 1 : 0, m4, source, ctb);
        }
        if (value.equals("DungeonsCompleted")) {
            return AbilityUtils.doXMath(player.getCompletedDungeons().size(), m4, source, ctb);
        }
        if (value.equals("RingTemptedYou")) {
            return AbilityUtils.doXMath(player.getNumRingTemptedYou(), m4, source, ctb);
        }
        if (value.startsWith("DungeonCompletedNamed")) {
            String[] full = value.split("_");
            String name = full[1];
            int completed = 0;
            List<Card> dungeons = player.getCompletedDungeons();
            for (Card c : dungeons) {
                if (!c.getName().equals(name)) continue;
                ++completed;
            }
            return AbilityUtils.doXMath(completed, m4, source, ctb);
        }
        if (value.equals("DifferentlyNamedDungeonsCompleted")) {
            int amount = 0;
            List<Card> dungeons = player.getCompletedDungeons();
            for (int i = 0; i < dungeons.size(); ++i) {
                Card d1 = dungeons.get(i);
                boolean hasSameName = false;
                for (int j = i - 1; j >= 0; --j) {
                    Card d2 = dungeons.get(j);
                    if (!d1.getName().equals(d2.getName())) continue;
                    hasSameName = true;
                    break;
                }
                if (hasSameName) continue;
                ++amount;
            }
            return AbilityUtils.doXMath(amount, m4, source, ctb);
        }
        if (value.startsWith("PlaneswalkedToThisTurn")) {
            int found = 0;
            String name = value.split(" ")[1];
            List<Card> pwTo = player.getPlaneswalkedToThisTurn();
            for (Card c : pwTo) {
                if (!c.getName().equals(name)) continue;
                ++found;
                break;
            }
            return AbilityUtils.doXMath(found, m4, source, ctb);
        }
        return AbilityUtils.doXMath(0, m4, source, ctb);
    }

    public static int objectXCount(List<?> objects, String s2, Card source, CardTraitBase ctb) {
        if (objects.isEmpty()) {
            return 0;
        }
        if (s2.startsWith("Valid")) {
            return AbilityUtils.handlePaid(Iterables.filter(objects, Card.class), s2, source, ctb);
        }
        int n = s2.startsWith("Amount") ? objects.size() : 0;
        return AbilityUtils.doXMath(n, CardFactoryUtil.extractOperators(s2), source, ctb);
    }

    public static int handlePaid(Iterable<Card> paidList, String string, Card source, CardTraitBase ctb) {
        if (Iterables.isEmpty(paidList)) {
            return AbilityUtils.doXMath(0, CardFactoryUtil.extractOperators(string), source, ctb);
        }
        if (string.startsWith("Amount")) {
            return AbilityUtils.doXMath(Iterables.size(paidList), CardFactoryUtil.extractOperators(string), source, ctb);
        }
        if (string.startsWith("GreatestPower")) {
            return Aggregates.max(paidList, Card::getNetPower);
        }
        if (string.startsWith("GreatestToughness")) {
            return Aggregates.max(paidList, Card::getNetToughness);
        }
        if (string.startsWith("SumToughness")) {
            return Aggregates.sum(paidList, Card::getNetToughness);
        }
        if (string.startsWith("GreatestCMC")) {
            return Aggregates.max(paidList, Card::getCMC);
        }
        if (string.equals("DifferentColorPair")) {
            HashSet<ColorSet> diffPair = new HashSet<ColorSet>();
            for (Card card : paidList) {
                if (card.getColor().countColors() != 2) continue;
                diffPair.add(card.getColor());
            }
            return diffPair.size();
        }
        if (string.startsWith("DifferentCMC")) {
            HashSet<Integer> diffCMC = new HashSet<Integer>();
            for (Card card : paidList) {
                diffCMC.add(card.getCMC());
            }
            return diffCMC.size();
        }
        if (string.startsWith("SumCMC")) {
            return Aggregates.sum(paidList, Card::getCMC);
        }
        if (string.startsWith("Valid")) {
            String[] splitString = string.split("/", 2);
            String valid = splitString[0].substring(6);
            int num = CardLists.getValidCardCount(paidList, valid, source.getController(), source, ctb);
            return AbilityUtils.doXMath(num, splitString.length > 1 ? splitString[1] : null, source, ctb);
        }
        if (string.startsWith("CardTypes")) {
            return AbilityUtils.doXMath(AbilityUtils.countCardTypesFromList(paidList, string.startsWith("CardTypesPermanent")), CardFactoryUtil.extractOperators(string), source, ctb);
        }
        String filteredString = string;
        Iterable<Card> filteredList = paidList;
        String[] filter = filteredString.split("_");
        if (string.startsWith("FilterControlledBy")) {
            String pString = filter[0].substring(18);
            PlayerCollection controllers = AbilityUtils.getDefinedPlayers(source, pString, ctb);
            filteredList = CardLists.filterControlledByAsList(filteredList, controllers);
            filteredString = TextUtil.fastReplace(filteredString, pString, "");
            filteredString = TextUtil.fastReplace(filteredString, "FilterControlledBy_", "");
        }
        int tot = 0;
        for (Card c : filteredList) {
            tot += AbilityUtils.xCount(c, filteredString, ctb);
        }
        return tot;
    }

    private static CardCollectionView getCardListForXCount(Card c, Player cc, String[] sq, CardTraitBase ctb) {
        PlayerCollection opps = cc.getOpponents();
        CardCollection someCards = new CardCollection();
        Game game = c.getGame();
        if (sq[0].contains("YouCtrl")) {
            someCards.addAll(cc.getCardsIn(ZoneType.Battlefield));
        }
        if (sq[0].contains("InYourYard")) {
            someCards.addAll(cc.getCardsIn(ZoneType.Graveyard));
        }
        if (sq[0].contains("InYourLibrary")) {
            someCards.addAll(cc.getCardsIn(ZoneType.Library));
        }
        if (sq[0].contains("InYourHand")) {
            someCards.addAll(cc.getCardsIn(ZoneType.Hand));
        }
        if (sq[0].contains("InYourSideboard")) {
            someCards.addAll(cc.getCardsIn(ZoneType.Sideboard));
        }
        if (sq[0].contains("OppCtrl")) {
            for (Player p : opps) {
                someCards.addAll(p.getZone(ZoneType.Battlefield).getCards());
            }
        }
        if (sq[0].contains("InOppYard")) {
            for (Player p : opps) {
                someCards.addAll(p.getCardsIn(ZoneType.Graveyard));
            }
        }
        if (sq[0].contains("InOppHand")) {
            for (Player p : opps) {
                someCards.addAll(p.getCardsIn(ZoneType.Hand));
            }
        }
        if (sq[0].contains("InChosenHand") && c.hasChosenPlayer()) {
            someCards.addAll(c.getChosenPlayer().getCardsIn(ZoneType.Hand));
        }
        if (sq[0].contains("InRememberedHand") && c.getRemembered() != null) {
            for (Object o : c.getRemembered()) {
                if (!(o instanceof Player)) continue;
                Player remPlayer = (Player)o;
                someCards.addAll(remPlayer.getCardsIn(ZoneType.Hand));
            }
        }
        if (sq[0].contains("InChosenYard") && c.hasChosenPlayer()) {
            someCards.addAll(c.getChosenPlayer().getCardsIn(ZoneType.Graveyard));
        }
        if (sq[0].contains("OnBattlefield")) {
            someCards.addAll(game.getCardsIn(ZoneType.Battlefield));
        }
        if (sq[0].contains("InAllYards")) {
            someCards.addAll(game.getCardsIn(ZoneType.Graveyard));
        }
        if (sq[0].contains("SpellsOnStack")) {
            someCards.addAll(game.getCardsIn(ZoneType.Stack));
        }
        if (sq[0].contains("InAllHands")) {
            someCards.addAll(game.getCardsIn(ZoneType.Hand));
        }
        if (sq[0].contains("InTargetedHand")) {
            for (Player tgtP : AbilityUtils.getDefinedPlayers(c, "TargetedPlayer", ctb)) {
                someCards.addAll(tgtP.getCardsIn(ZoneType.Hand));
            }
        }
        if (sq[0].contains("InTargetedLibrary")) {
            for (Player tgtP : AbilityUtils.getDefinedPlayers(c, "TargetedPlayer", ctb)) {
                someCards.addAll(tgtP.getCardsIn(ZoneType.Library));
            }
        }
        if (sq[0].contains("Type")) {
            someCards = CardLists.getType(someCards, sq[1]);
        }
        if (sq[0].contains("Named")) {
            if (sq[1].equals("CARDNAME")) {
                sq[1] = c.getName();
            }
            someCards = CardLists.filter((Iterable<Card>)someCards, CardPredicates.nameEquals(sq[1]));
        }
        if (sq[0].contains("Multicolor")) {
            someCards = CardLists.filter((Iterable<Card>)someCards, c1 -> c1.getColor().isMulticolor());
        }
        if (sq[0].contains("Monocolor")) {
            someCards = CardLists.filter((Iterable<Card>)someCards, c12 -> c12.getColor().isMonoColor());
        }
        return someCards;
    }

    private static CardCollection getPaidCards(CardTraitBase sa, String defined) {
        CardCollection list = null;
        if (sa instanceof SpellAbility) {
            SpellAbility root = ((SpellAbility)sa).getRootAbility();
            list = root.getPaidList(defined, true);
        }
        return list;
    }

    public static int countCardTypesFromList(Iterable<Card> list, boolean permanentTypes) {
        EnumSet<CardType.CoreType> types = EnumSet.noneOf(CardType.CoreType.class);
        for (Card c1 : list) {
            Iterables.addAll(types, c1.getType().getCoreTypes());
        }
        if (permanentTypes) {
            return (int)types.stream().filter(type -> type.isPermanent).count();
        }
        return types.size();
    }

    public static int countSuperTypesFromList(Iterable<Card> list) {
        EnumSet<CardType.Supertype> types = EnumSet.noneOf(CardType.Supertype.class);
        for (Card c1 : list) {
            Iterables.addAll(types, c1.getType().getSupertypes());
        }
        return types.size();
    }

    public static int countSubTypesFromList(Iterable<Card> list) {
        HashSet types = new HashSet();
        for (Card c1 : list) {
            Iterables.addAll(types, c1.getType().getSubtypes());
        }
        return types.size();
    }

    public static boolean isUnlinkedFromCastSA(CardTraitBase ctb, Card card) {
        if (ctb != null && ctb.isIntrinsic() && ctb.getHostCard().equals(card)) {
            Card host = ctb.getOriginalHost();
            SpellAbility castSA = card.getCastSA();
            if (host != null && castSA != null) {
                Card castHost = castSA.getOriginalHost();
                if (castHost == null) {
                    castHost = castSA.getHostCard();
                }
                if (!host.equals(castHost)) {
                    return true;
                }
            }
        }
        return false;
    }

    private static CardTraitBase adjustTriggerContext(String[] def, CardTraitBase ctb) {
        if (def[0].startsWith("Spawner>") && ctb instanceof SpellAbility) {
            Trigger trig = ((SpellAbility)ctb).getTrigger();
            if (trig == null) {
                return ctb;
            }
            SpellAbility spawner = trig.getSpawningAbility();
            if (spawner == null) {
                return ctb;
            }
            def[0] = def[0].substring(8);
            return spawner;
        }
        if (def[0].startsWith("TriggeredSpellAbility>") && ctb instanceof SpellAbility) {
            SpellAbility trig = (SpellAbility)((SpellAbility)ctb).getTriggeringObject(AbilityKey.SpellAbility);
            if (trig == null) {
                return ctb;
            }
            def[0] = def[0].substring(22);
            return trig;
        }
        if (def[0].startsWith("CastSA>")) {
            SpellAbility sa = ctb.getHostCard().getCastSA();
            if (sa == null) {
                return ctb;
            }
            def[0] = def[0].substring(7);
            return sa;
        }
        return ctb;
    }
}

