/*
 * Decompiled with CFR 0.152.
 */
package forge.game;

import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import forge.game.StaticEffect;
import forge.game.card.Card;
import forge.game.staticability.StaticAbility;
import java.util.Map;
import java.util.Set;

public class StaticEffects {
    private final Map<StaticAbility, StaticEffect> staticEffects = Maps.newHashMap();

    public final void clearStaticEffects(Set<Card> affectedCards) {
        for (StaticEffect se : this.staticEffects.values()) {
            Iterables.addAll(affectedCards, se.remove());
        }
        this.staticEffects.clear();
    }

    public final StaticEffect getStaticEffect(StaticAbility staticAbility) {
        StaticEffect currentEffect = this.staticEffects.get(staticAbility);
        if (currentEffect != null) {
            return currentEffect;
        }
        StaticEffect newEffect = new StaticEffect(staticAbility);
        this.staticEffects.put(staticAbility, newEffect);
        return newEffect;
    }

    public Iterable<StaticEffect> getEffects() {
        return this.staticEffects.values();
    }

    public boolean removeStaticEffect(StaticAbility staticAbility) {
        StaticEffect currentEffect = this.staticEffects.remove(staticAbility);
        if (currentEffect == null) {
            return false;
        }
        currentEffect.remove();
        return true;
    }
}

