/*
 * Decompiled with CFR 0.152.
 */
package forge.game;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import forge.game.Game;
import forge.game.ability.AbilityKey;
import forge.game.player.Player;
import forge.game.replacement.ReplacementType;
import forge.game.trigger.TriggerType;
import forge.util.MyRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;

public enum PlanarDice {
    Planeswalk,
    Chaos,
    Blank;

    public static final ImmutableList<PlanarDice> values;

    public static PlanarDice roll(Player roller, PlanarDice riggedResult) {
        Game game = roller.getGame();
        int rolls = 1;
        int ignore = 0;
        Map<AbilityKey, Object> repParams = AbilityKey.mapFromAffected(roller);
        repParams.put(AbilityKey.Number, rolls);
        repParams.put(AbilityKey.Ignore, ignore);
        switch (game.getReplacementHandler().run(ReplacementType.RollPlanarDice, repParams)) {
            case NotReplaced: {
                break;
            }
            case Updated: {
                rolls = (Integer)repParams.get((Object)AbilityKey.Number);
                ignore = (Integer)repParams.get((Object)AbilityKey.Ignore);
            }
        }
        ArrayList<PlanarDice> results = Lists.newArrayList();
        for (int r = 0; r < rolls; ++r) {
            PlanarDice thisRoll = Blank;
            int i = MyRandom.getRandom().nextInt(6);
            roller.roll();
            if (riggedResult != null) {
                thisRoll = riggedResult;
            } else if (i == 0) {
                thisRoll = Planeswalk;
            } else if (i == 1) {
                thisRoll = Chaos;
            }
            results.add(thisRoll);
        }
        for (int ig = 0; ig < ignore; ++ig) {
            results.remove((Object)roller.getController().choosePDRollToIgnore(results));
        }
        PlanarDice res = (PlanarDice)((Object)results.get(0));
        Map<AbilityKey, Object> resRepParams = AbilityKey.mapFromAffected(roller);
        resRepParams.put(AbilityKey.Result, (Object)res);
        switch (game.getReplacementHandler().run(ReplacementType.PlanarDiceResult, resRepParams)) {
            case NotReplaced: {
                break;
            }
            case Updated: {
                res = (PlanarDice)((Object)resRepParams.get((Object)AbilityKey.Result));
            }
        }
        Map<AbilityKey, Object> runParams = AbilityKey.mapFromPlayer(roller);
        runParams.put(AbilityKey.Result, (Object)res);
        game.getTriggerHandler().runTrigger(TriggerType.PlanarDice, runParams, false);
        for (int r = 0; r < rolls; ++r) {
            runParams = AbilityKey.mapFromPlayer(roller);
            runParams.put(AbilityKey.Sides, 6);
            runParams.put(AbilityKey.Result, 0);
            roller.getGame().getTriggerHandler().runTrigger(TriggerType.RolledDie, runParams, false);
        }
        runParams = AbilityKey.mapFromPlayer(roller);
        runParams.put(AbilityKey.Sides, 6);
        runParams.put(AbilityKey.Result, Arrays.asList(0));
        roller.getGame().getTriggerHandler().runTrigger(TriggerType.RolledDieOnce, runParams, false);
        if (res == Chaos) {
            runParams = AbilityKey.mapFromPlayer(roller);
            roller.getGame().getTriggerHandler().runTrigger(TriggerType.ChaosEnsues, runParams, false);
        }
        return res;
    }

    public static PlanarDice smartValueOf(String value) {
        String valToCompate = value.trim();
        for (PlanarDice v : PlanarDice.values()) {
            if (v.name().compareToIgnoreCase(valToCompate) != 0) continue;
            return v;
        }
        throw new RuntimeException("Element " + value + " not found in PlanarDice enum");
    }

    static {
        values = ImmutableList.copyOf(PlanarDice.values());
    }
}

