/*
 * Decompiled with CFR 0.152.
 */
package forge.game;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import forge.game.Game;
import forge.game.GameObject;
import forge.game.GameRules;
import forge.game.IEntityMap;
import forge.game.Match;
import forge.game.card.Card;
import forge.game.card.CardCopyService;
import forge.game.combat.Combat;
import forge.game.mana.Mana;
import forge.game.phase.PhaseHandler;
import forge.game.player.Player;
import forge.game.player.RegisteredPlayer;
import forge.game.spellability.SpellAbility;
import forge.game.spellability.SpellAbilityStackInstance;
import forge.game.trigger.TriggerType;
import forge.game.zone.PlayerZoneBattlefield;
import forge.game.zone.ZoneType;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class GameSnapshot {
    private final Game origGame;
    private Game newGame = null;
    private boolean restore = false;
    private final SnapshotEntityMap gameObjectMap = new SnapshotEntityMap();

    public GameSnapshot(Game origGame) {
        this.origGame = origGame;
    }

    public Game getCopiedGame() {
        return this.origGame;
    }

    public Game makeCopy() {
        return this.makeCopy(null, true);
    }

    public Game makeCopy(List<RegisteredPlayer> replacementPlayers, boolean includeStack) {
        List<RegisteredPlayer> newPlayers = replacementPlayers != null ? replacementPlayers : Lists.newArrayList(this.origGame.getMatch().getPlayers());
        GameRules currentRules = this.origGame.getRules();
        Match newMatch = new Match(currentRules, newPlayers, this.origGame.getView().getTitle());
        this.newGame = new Game(newPlayers, currentRules, newMatch);
        this.restore = false;
        this.assignGameState(this.origGame, this.newGame, includeStack);
        return this.newGame;
    }

    public void restoreGameState(Game currentGame) {
        System.out.println("Restoring game state with timestamp of :" + this.newGame.getTimestamp());
        this.restore = true;
        this.assignGameState(this.newGame, currentGame, true);
    }

    public void assignGameState(Game fromGame, Game toGame, boolean includeStack) {
        Object combat;
        for (int i = 0; i < fromGame.getPlayers().size(); ++i) {
            Player origPlayer = (Player)fromGame.getPlayers().get(i);
            Iterator newPlayer = this.findBy(toGame, origPlayer);
            this.assignPlayerState(origPlayer, (Player)((Object)newPlayer));
        }
        PhaseHandler origPhaseHandler = fromGame.getPhaseHandler();
        Player newPlayerTurn = this.findBy(toGame, origPhaseHandler.getPlayerTurn());
        toGame.getPhaseHandler().devModeSet(origPhaseHandler.getPhase(), newPlayerTurn, origPhaseHandler.getTurn());
        toGame.getTriggerHandler().suppressMode(TriggerType.ChangesZone);
        for (Player p : toGame.getPlayers()) {
            ((PlayerZoneBattlefield)p.getZone(ZoneType.Battlefield)).setTriggers(false);
        }
        this.copyGameState(fromGame, toGame);
        for (Player p : fromGame.getPlayers()) {
            Player toPlayer = this.findBy(toGame, p);
            p.copyCommandersToSnapshot(toPlayer, c -> this.findBy(toGame, (Card)c));
            ((PlayerZoneBattlefield)toPlayer.getZone(ZoneType.Battlefield)).setTriggers(true);
        }
        toGame.getTriggerHandler().clearSuppression(TriggerType.ChangesZone);
        for (Card c2 : toGame.getCardsInGame()) {
            Card origCard = fromGame.findById(c2.getId());
            if (origCard == null) {
                System.out.println("Missing card " + c2);
                continue;
            }
            if (origCard.hasRemembered()) {
                for (Object o : origCard.getRemembered()) {
                    if (o instanceof GameObject) {
                        if (o instanceof Card && ((Card)o).getZone() == null) continue;
                        c2.addRemembered(this.find((GameObject)o));
                        continue;
                    }
                    System.err.println(c2 + " Remembered: " + o + "/" + o.getClass());
                    c2.addRemembered(o);
                }
            }
            for (SpellAbility sa : c2.getSpellAbilities()) {
                Player activatingPlayer = sa.getActivatingPlayer();
                if (activatingPlayer == null || activatingPlayer.getGame() == toGame) continue;
                sa.setActivatingPlayer(this.findBy(toGame, activatingPlayer), true);
            }
        }
        if (origPhaseHandler.getCombat() != null) {
            combat = new Combat(origPhaseHandler.getCombat(), this.gameObjectMap);
            toGame.getPhaseHandler().setCombat((Combat)combat);
        }
        if (includeStack) {
            this.copyStack(fromGame, toGame);
        }
        if (this.restore) {
            for (Player p : toGame.getPlayers()) {
                p.updateAllZonesForView();
            }
            combat = toGame.getPhaseHandler().getCombat();
            if (combat != null) {
                toGame.updateCombatForView();
            }
        }
    }

    public void assignPlayerState(Player origPlayer, Player newPlayer) {
        if (this.restore) {
            origPlayer.dangerouslySetController(newPlayer.getController());
        }
        newPlayer.setLife(origPlayer.getLife(), null);
        newPlayer.setLifeLostLastTurn(origPlayer.getLifeLostLastTurn());
        newPlayer.setLifeLostThisTurn(origPlayer.getLifeLostThisTurn());
        newPlayer.setLifeGainedThisTurn(origPlayer.getLifeGainedThisTurn());
        newPlayer.setLifeStartedThisTurnWith(origPlayer.getLifeStartedThisTurnWith());
        newPlayer.setDamageReceivedThisTurn(origPlayer.getDamageReceivedThisTurn());
        newPlayer.setActivateLoyaltyAbilityThisTurn(origPlayer.getActivateLoyaltyAbilityThisTurn());
        newPlayer.setLandsPlayedThisTurn(origPlayer.getLandsPlayedThisTurn());
        newPlayer.setCounters(Maps.newHashMap(origPlayer.getCounters()));
        newPlayer.setBlessing(origPlayer.hasBlessing());
        newPlayer.setRevolt(origPlayer.hasRevolt());
        newPlayer.setLibrarySearched(origPlayer.getLibrarySearched());
        newPlayer.setSpellsCastLastTurn(origPlayer.getSpellsCastLastTurn());
        newPlayer.setCommitedCrimeThisTurn(origPlayer.getCommittedCrimeThisTurn());
        newPlayer.setExpentThisTurn(origPlayer.getExpentThisTurn());
        for (int j = 0; j < origPlayer.getSpellsCastThisTurn(); ++j) {
            newPlayer.addSpellCastThisTurn();
        }
        newPlayer.setMaxHandSize(origPlayer.getMaxHandSize());
        newPlayer.setUnlimitedHandSize(origPlayer.isUnlimitedHandSize());
        this.copyManaPool(origPlayer, newPlayer);
    }

    private void copyManaPool(Player fromPlayer, Player toPlayer) {
        Game toGame = toPlayer.getGame();
        toPlayer.getManaPool().resetPool();
        for (Mana m4 : fromPlayer.getManaPool()) {
            toPlayer.getManaPool().addMana(this.copyMana(m4, toGame), false);
        }
        toPlayer.updateManaForView();
    }

    private Mana copyMana(Mana m4, Game toGame) {
        Card fromCard = m4.getSourceCard();
        Card toCard = this.findBy(toGame, fromCard);
        if (toCard == null) {
            return m4;
        }
        Mana newMana = new Mana(m4.getColor(), toCard, m4.getManaAbility());
        newMana.getManaAbility().setSourceCard(toCard);
        return newMana;
    }

    private void copyStack(Game fromGame, Game toGame) {
        HashMap<Integer, SpellAbilityStackInstance> stackIds = new HashMap<Integer, SpellAbilityStackInstance>();
        for (SpellAbilityStackInstance toEntry : toGame.getStack()) {
            stackIds.put(toEntry.getId(), toEntry);
        }
        for (SpellAbilityStackInstance origEntry : fromGame.getStack()) {
            int id = origEntry.getId();
            SpellAbilityStackInstance instance = stackIds.getOrDefault(id, null);
            if (instance != null) {
                if (this.restore) continue;
                System.out.println("Might need to alter " + origEntry.getSpellAbility() + " on stack");
                continue;
            }
            System.out.println("Adding " + origEntry.getSpellAbility() + " to stack");
            SpellAbility origSa = origEntry.getSpellAbility();
            Card origHostCard = origSa.getHostCard();
            Card newCard = this.findBy(toGame, origHostCard);
            if (newCard == null) {
                newCard = this.createCardCopy(toGame, this.findBy(toGame, origHostCard.getOwner()), origHostCard);
            }
            SpellAbility newSa = null;
            if (origSa.isSpell()) {
                newSa = GameSnapshot.findSAInCard(origSa, newCard);
            }
            if (newSa == null) continue;
            newSa.setActivatingPlayer(this.findBy(toGame, origSa.getActivatingPlayer()), true);
            if (origSa.usesTargeting()) {
                for (GameObject o : origSa.getTargets()) {
                    if (o instanceof Card) {
                        newSa.getTargets().add(this.findBy(toGame, (Card)o));
                        continue;
                    }
                    if (o instanceof Player) {
                        newSa.getTargets().add(this.findBy(toGame, (Player)o));
                        continue;
                    }
                    System.out.println("Failed to restore target " + o + " for " + origSa);
                }
            }
            toGame.getStack().add(newSa, id);
        }
    }

    public void copyGameState(Game fromGame, Game toGame) {
        toGame.setAge(fromGame.getAge());
        toGame.dangerouslySetTimestamp(fromGame.getTimestamp());
        if (fromGame.getStartingPlayer() != null) {
            toGame.setStartingPlayer(this.findBy(toGame, fromGame.getStartingPlayer()));
        }
        if (fromGame.getMonarch() != null) {
            toGame.setMonarch(this.findBy(toGame, fromGame.getMonarch()));
        }
        if (fromGame.getMonarchBeginTurn() != null) {
            toGame.setMonarchBeginTurn(this.findBy(toGame, fromGame.getMonarchBeginTurn()));
        }
        if (fromGame.getHasInitiative() != null) {
            toGame.setHasInitiative(this.findBy(toGame, fromGame.getHasInitiative()));
        }
        if (fromGame.getDayTime() != null) {
            toGame.setDayTime(fromGame.getDayTime());
        }
        for (Card fromCard : fromGame.getCardsInGame()) {
            Card newCard = toGame.findById(fromCard.getId());
            Player toPlayer = this.findBy(toGame, fromCard.getController());
            ZoneType fromType = fromCard.getZone().getZoneType();
            if (newCard == null) {
                newCard = this.createCardCopy(toGame, toPlayer, fromCard);
            } else {
                ZoneType type = newCard.getZone().getZoneType();
                if (type != fromType) {
                    if (type.equals((Object)ZoneType.Stack)) {
                        toGame.getStackZone().remove(newCard);
                    } else {
                        toPlayer.getZone(type).remove(newCard);
                    }
                }
            }
            if (fromType.equals((Object)ZoneType.Stack)) {
                toGame.getStackZone().add(newCard);
                newCard.setZone(toGame.getStackZone());
            } else {
                toPlayer.getZone(fromType).add(newCard);
                newCard.setZone(toPlayer.getZone(fromType));
            }
            newCard.setGameTimestamp(fromCard.getGameTimestamp());
            newCard.setLayerTimestamp(fromCard.getLayerTimestamp());
            newCard.setTapped(fromCard.isTapped());
            newCard.setFaceDown(fromCard.isFaceDown());
            newCard.setManifested(fromCard.isManifested());
            newCard.setSickness(fromCard.hasSickness());
            newCard.setState(fromCard.getCurrentStateName(), false);
        }
        for (Card newCard : toGame.getCardsIn(ZoneType.Battlefield)) {
            Card fromCard = fromGame.findById(newCard.getId());
            if (fromCard.isAttachedToEntity()) {
                Card newAttachedTo;
                Card fromAttachedTo = fromCard.getAttachedTo();
                Card card = newAttachedTo = fromAttachedTo == null ? null : toGame.findById(fromAttachedTo.getId());
                if (newAttachedTo != null) {
                    newCard.setEntityAttachedTo(newAttachedTo);
                    newAttachedTo.addAttachedCard(newCard);
                }
            }
            if (fromCard.getCloneOrigin() != null) {
                newCard.setCloneOrigin(toGame.findById(fromCard.getCloneOrigin().getId()));
            }
            if (fromCard.getHaunting() != null) {
                newCard.setHaunting(toGame.findById(fromCard.getHaunting().getId()));
            }
            if (fromCard.getEffectSource() != null) {
                newCard.setEffectSource(toGame.findById(fromCard.getEffectSource().getId()));
            }
            if (fromCard.isPaired()) {
                newCard.setPairedWith(toGame.findById(fromCard.getPairedWith().getId()));
            }
            if (fromCard.getCopiedPermanent() == null) continue;
            newCard.setCopiedPermanent(toGame.findById(fromCard.getCopiedPermanent().getId()));
        }
    }

    private Card createCardCopy(Game newGame, Player newOwner, Card c) {
        Card newCard = new CardCopyService(c, newGame).copyCard(false, newOwner);
        newCard.dangerouslySetGame(newGame);
        return newCard;
    }

    private static SpellAbility findSAInCard(SpellAbility sa, Card c) {
        String saDesc = sa.getDescription();
        for (SpellAbility cardSa : c.getAllSpellAbilities()) {
            if (!saDesc.equals(cardSa.getDescription())) continue;
            return cardSa;
        }
        Map<String, String> origMap = sa.getOriginalMapParams();
        for (SpellAbility cardSa : c.getAllSpellAbilities()) {
            if (!origMap.equals(cardSa.getOriginalMapParams())) continue;
            return cardSa;
        }
        return null;
    }

    private Card findBy(Game toGame, Card fromCard) {
        return toGame.findById(fromCard.getId());
    }

    private Player findBy(Game toGame, Player fromPlayer) {
        return toGame.getPlayer(fromPlayer.getId());
    }

    public GameObject find(GameObject o) {
        if (o instanceof Card) {
            return this.findBy(this.newGame, (Card)o);
        }
        if (o instanceof Player) {
            return this.findBy(this.newGame, (Player)o);
        }
        return null;
    }

    public GameObject reverseFind(GameObject o) {
        if (o instanceof Card) {
            return this.findBy(this.origGame, (Card)o);
        }
        if (o instanceof Player) {
            return this.findBy(this.origGame, (Player)o);
        }
        return null;
    }

    public class SnapshotEntityMap
    implements IEntityMap {
        @Override
        public Game getGame() {
            if (GameSnapshot.this.restore) {
                return GameSnapshot.this.origGame;
            }
            return GameSnapshot.this.newGame;
        }

        @Override
        public GameObject map(GameObject o) {
            if (o instanceof Player) {
                return GameSnapshot.this.findBy(this.getGame(), (Player)o);
            }
            if (o instanceof Card) {
                return GameSnapshot.this.findBy(this.getGame(), (Card)o);
            }
            return null;
        }

        @Override
        public Card map(Card c) {
            return GameSnapshot.this.findBy(this.getGame(), c);
        }

        @Override
        public Player map(Player p) {
            return GameSnapshot.this.findBy(this.getGame(), p);
        }
    }
}

